* Figure A8

clear
set more off
set scheme s1mono

******************************
* ALM task content over time *
******************************

use panel_occ_ind.dta, clear

drop if math==.
drop if dcp==.
drop if sts==.
drop if finger==.
drop if ehf==.
collapse (sum) perwt (mean) math dcp sts finger ehf , by(occ1950 year)

* Merge wage data
so occ1950 year
merge 1:1 occ1950 year using wage-occ1950-year.dta
tab _m
drop _m

* Distribution of occupations over time

egen noj=count(year),by(occ1950)
su noj, d

* Command to make panel balanced

keep if noj==7

* Transform variables

gen abstract=(math+dcp)/2
gen routine=(finger+sts)/2

egen totperwt=sum(perwt),by(year)
gen empshare=perwt/totperwt
egen p_wage=rank(wage),by(year)
egen temp=max(p_wage),by(year)
replace p_wage=p_wage/temp
drop temp

foreach var of varlist math dcp sts finger ehf abstract routine {
egen p_`var'=rank(`var'),by(year)
egen temp=max(p_`var'),by(year)
replace p_`var'=p_`var'/temp
drop temp
gen temp=empshare*p_`var'
egen me_`var'=sum(temp),by(year)
drop temp
}

collapse (mean) me_abstract me_routine me_math me_dcp me_sts me_finger me_ehf , by(year)

* Index numbers

foreach var in abstract routine math dcp sts finger ehf {
gen temp=me_`var' if year==1880
egen me_`var'_1880=max(temp)
drop temp
gen ie_`var'=me_`var'/me_`var'_1880
}

* Employment 3 categories
twoway (scatter ie_abstract year , c(l) msymbol(i) lpattern(solid) lcolor(black) lwidth(thick)) (scatter ie_routine year, c(l) msymbol(i) lpattern(solid) lcolor(gs12) lwidth(thick)) (scatter ie_ehf year, c(l) msymbol(i) lpattern(solid) lcolor(black) lwidth(medium)), title("Employment", size(medium)) ytitle("Employment Weighted Percentile Score", size(small)) xtitle("Year", size(small)) xlabel (1880 1900 1920 1940 1960 1980 2000) legend(lab(1 "Abstract") lab(2 "Routine") lab(3 "Manual") cols(3) size(small))

* Employment 5 categories
twoway (scatter ie_math year , c(l) msymbol(i) lpattern(solid) lcolor(black) lwidth(thick)) (scatter ie_dcp year, c(l) msymbol(i) lpattern(solid) lcolor(gs12) lwidth(thick)) (scatter ie_sts year , c(l) msymbol(i) lpattern(dash) lcolor(black) lwidth(thick)) (scatter ie_finger year, c(l) msymbol(i) lpattern(dash) lcolor(gs12) lwidth(thick)) (scatter ie_ehf year, c(l) msymbol(i) lpattern(solid) lcolor(black) lwidth(medium)), title("Figure A8:  Employment", size(medium)) ytitle("Employment Weighted Percentile Score", size(small)) xtitle("Year", size(small)) xlabel (1880 1900 1920 1940 1960 1980 2000) legend(lab(1 "Non-routine Analytic") lab(2 "Non-Routine Interactive") lab(3 "Routine Cognitive") lab(4 "Routine Manual") lab(5 "Non-routine Manual") cols(3) rows(2) size(vsmall)) note("Note: Employment-weighted mean of 1991 DOTs numerical scores in each year, as used in Autor, Levy and Murnane (2003).", size(vsmall))

