
* Figure A9
* Figure A10

set scheme s1color

use thesaurustaskcontent.dta, clear

* T is task content of employment
* I is index of task content of employment that is one in 1880

egen rk_T=rank(T), by(year) field
egen rk_I=rank(I), by(year) field
egen mx_rk_T=max(rk_T), by(year)
egen mx_rk_I=max(rk_I), by(year)

gen temp=rk_I if year==2000
egen rk_I_2000=max(temp), by(section)
drop temp
egen mx_rk_I_2000=max(rk_I_2000)

gsort -T
*browse verb year freq freqocc T if year==2000

* Thesaurus section names

/*
1 Class I. Words Expressing Abstract Relations
1.1 Section I. Existence
1.2 Section II. Relation
1.3 Section III. Quantity
1.4 Section IV. Order
1.5 Section V. Number
1.6 Section VI. Time
1.7 Section VII. Change
1.8 Section VIII. Causation
2 Class II. Words Relating to Space
2.1 Section I. Space in General
2.2 Section II. Dimensions
2.3 Section III. Form
2.4 Section IV. Motion
3 Class III. Words Relating to Matter
3.1 Section I. Matter in General
3.2 Section II. Inorganic Matter
3.3 Section III. Organic Matter
4 Class IV. Words Relating to the Intellectual Faculties
4.1 Division I. Formation of Ideas
4.1.1 Section I. Operations of Intellect in General
4.1.2 Section II. Precursory Conditions and Operations
4.1.3 Section III. Materials for Reasoning
4.1.4 Section IV. Reasoning Processes
4.1.5 Section V. Results Of Reasoning
4.1.6 Section VI. Extension of Thought
4.1.7 Section VII. Creative Thought
4.2 Division II. Communication of Ideas
4.2.1 Section I. Nature of Ideas Communicated
4.2.2 Section II. Modes of Communication
4.2.3 Section III. Means of Communicating Ideas
5 Class V. Words Relating to the Voluntary Powers
5.1 Division I. Individual Volition
5.1.1 Section I. Volition in General
5.1.2 Section II. Prospective Volition
5.1.3 Section III. Voluntary Action
5.1.4 Section IV. Antagonism
5.1.5 Section V. Results of Voluntary Action
5.2 Division II. Intersocial Volition
5.2.1 Section I. General Intersocial Volition
5.2.2 Section II. Special Intersocial Volition
5.2.3 Section III. Conditional Intersocial Volition
5.2.4 Section IV. Possessive Relations
6 Class VI. Words Relating to the Sentient and Moral Powers
6.1 Section I. Affections in General
6.2 Section II. Personal Affections
6.2.1 1. Passive Affections
6.2.2 2. Discriminative Affections
6.2.3 3. Prospective Affections
6.2.4 4. Contemplative Affections
6.2.5 5. Extrinsic Affections
6.3 Section III. Sympathetic Affections
6.3.1 1. Social Affections
6.3.2 2. Diffusive Sympathetic Affections
6.3.3 3. Special Sympathetic Affections
6.3.4 4. Retrospective Sympathetic Affections
6.4 Section IV. Moral Affections
6.4.1 1. Moral Obligations
6.4.2 2. Moral Sentiments
6.4.3 3. Moral Conditions
6.4.4 4. Moral Practice
6.4.5 5. Moral Institutions
6.5 Section V. Religious Affections
6.5.1 1. Superhuman Beings and Regions
6.5.2 2. Religious Doctrines
6.5.3 3. Religious Sentiments
6.5.4 4. Acts Of Religion
6.5.5 5. Religious Institutions
*/

* c4d1s1 is missing
* because it does not have any of our verbs

gen sectionname="C1S1:Existence" if section=="c1s1"
replace sectionname="C1S2:Relation" if section=="c1s2"
replace sectionname="C1S3:Quantity" if section=="c1s3"
replace sectionname="C1S4:Order" if section=="c1s4"
replace sectionname="C1S5:Number" if section=="c1s5"
replace sectionname="C1S6:Time" if section=="c1s6"
replace sectionname="C1S7:Change" if section=="c1s7"
replace sectionname="C1S8:Causation" if section=="c1s8"
replace sectionname="C2S1:General" if section=="c2s1"
replace sectionname="C2S2:Dimensions" if section=="c2s2"
replace sectionname="C2S3:Form" if section=="c2s3"
replace sectionname="C2S4:Motion" if section=="c2s4"
replace sectionname="C3S1:General" if section=="c3s1"
replace sectionname="C3S2:Inorganic" if section=="c3s2"
replace sectionname="C3S3:Organic" if section=="c3s3"
replace sectionname="C4D1S1:General Ideas" if section=="c4d1s1"
replace sectionname="C4D1S2:Precursory Ideas" if section=="c4d1s2"
replace sectionname="C4D1S3:Reason Materials" if section=="c4d1s3"
replace sectionname="C4D1S4:Reason Processes" if section=="c4d1s4"
replace sectionname="C4D1S5:Reason Results" if section=="c4d1s5"
replace sectionname="C4D1S6:Extension Thought" if section=="c4d1s6"
replace sectionname="C4D1S7:Creative Thought" if section=="c4d1s7"
replace sectionname="C4D2S1:Nature Ideas" if section=="c4d2s1"
replace sectionname="C4D2S2:Modes Communicate" if section=="c4d2s2"
replace sectionname="C4S2S3:Means Communicate" if section=="c4d2s3"
replace sectionname="C5D1S1:Volition General" if section=="c5d1s1"
replace sectionname="C5D1S2:Prospective Volition" if section=="c5d1s2"
replace sectionname="C5D1S3:Voluntary Action" if section=="c5d1s3"
replace sectionname="C5D1S4:Antagonism" if section=="c5d1s4"
replace sectionname="C5D1S5:Results Action" if section=="c5d1s5"
replace sectionname="C5D2S1:General Intersocial" if section=="c5d2s1"
replace sectionname="C5D2S2:Special Intersocial" if section=="c5d2s2"
replace sectionname="C5D2S3:Conditional Intersocial" if section=="c5d2s3"
replace sectionname="C5D2S4:Possessive Relations" if section=="c5d2s4"
replace sectionname="C6S1:Affections General" if section=="c6s1"
replace sectionname="C6S2:Personal Affections" if section=="c6s2"
replace sectionname="C6S3:Sympathetic Affections" if section=="c6s3"
replace sectionname="C6S4:Moral Affections" if section=="c6s4"
replace sectionname="C6S5:Religious Affections" if section=="c6s5"

* Top 10 sectionnames task content

display "Top 10 thesaurus task content 1880"
list sectionname if rk_T<=10&year==1880
display "Top 10 thesaurus task content 1900"
list sectionname if rk_T<=10&year==1900
display "Top 10 thesaurus task content 1920"
list sectionname if rk_T<=10&year==1920
display "Top 10 thesaurus task content 1940"
list sectionname if rk_T<=10&year==1940
display "Top 10 verbs task content 1960"
list sectionname if rk_T<=10&year==1960
display "Top 10 verbs task content 1980"
list sectionname if rk_T<=10&year==1980
display "Top 10 verbs task content 2000"
list sectionname if rk_T<=10&year==2000

* Top 20 sectionames increase task content

gsort -rk_I
display "Top 10 thesaurus largest increase in task content 1880-2000"
list sectionname if rk_I<=10&year==2000
display "Bottom 10 thesaurus smallest increase in task content 1880-2000"
list sectionname if (rk_I>mx_rk_I-10)&year==2000

* Graph section names task content

*******************************
* THESAURUS GRAPHS BY ALM BIN *
*******************************

*****************************************
* Thesaurus categories allocated to DCP *
*****************************************

local dcpsections="c1s5 c4d1s5 c4d2s2 c5d1s2 c5d2s1 c5d2s2 c5d2s3 c5d2s4 c6s4" 

levelsof sectionname if section=="c1s5", local(lg1) clean
levelsof sectionname if section=="c4d1s5", local(lg2) clean
levelsof sectionname if section=="c4d2s2", local(lg3) clean
levelsof sectionname if section=="c5d1s2", local(lg4) clean
levelsof sectionname if section=="c5d2s1", local(lg5) clean
levelsof sectionname if section=="c5d2s2", local(lg6) clean
levelsof sectionname if section=="c5d2s3", local(lg7) clean
levelsof sectionname if section=="c5d2s4", local(lg8) clean
levelsof sectionname if section=="c6s4", local(lg9) clean

***************************************
* THESAURUS GRAPHS BY THESAURUS CLASS *
***************************************

* Class 1

levelsof sectionname if section=="c1s1", local(lg1) clean
levelsof sectionname if section=="c1s2", local(lg2) clean
levelsof sectionname if section=="c1s3", local(lg3) clean
levelsof sectionname if section=="c1s4", local(lg4) clean
levelsof sectionname if section=="c1s5", local(lg5) clean
levelsof sectionname if section=="c1s6", local(lg6) clean
levelsof sectionname if section=="c1s7", local(lg7) clean
levelsof sectionname if section=="c1s8", local(lg8) clean

sort year I
twoway(scatter I year if section=="c1s1", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(black)) (scatter I year if section=="c1s2", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(gs12)) (scatter I year if section=="c1s3", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(black)) (scatter I year if section=="c1s4", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(gs12)) (scatter I year if section=="c1s5", c(l) msymbol(i) lwidth(medium) lpattern(solid) lcolor(black)) (scatter I year if section=="c1s6", c(l) msymbol(i) lwidth(medium) lpattern(solid) lcolor(gs12)) (scatter I year if section=="c1s7", c(l) msymbol(i) lwidth(medium) lpattern(dash) lcolor(black)) (scatter I year if section=="c1s8", c(l) msymbol(i) lwidth(medium) lpattern(dash) lcolor(gs12)), title("Class 1 : Abstract Relations", size(medium)) ytitle("") xtitle("Year", size(small)) ylabel(0.5 1 1.5 2 2.5) xlabel (1880 1900 1920 1940 1960 1980 2000) legend(lab(1 "`lg1'") lab(2 "`lg2'") lab(3 "`lg3'") lab(4 "`lg4'") lab(5 "`lg5'") lab(6 "`lg6'") lab(7 "`lg7'") lab(8 "`lg8'") cols(3) rows(3) size(vsmall)) name(a, replace)


* Class 2

levelsof sectionname if section=="c2s1", local(lg1) clean
levelsof sectionname if section=="c2s2", local(lg2) clean
levelsof sectionname if section=="c2s3", local(lg3) clean
levelsof sectionname if section=="c2s4", local(lg4) clean

sort year I
twoway(scatter I year if section=="c2s1", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(black)) (scatter I year if section=="c2s2", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(gs12)) (scatter I year if section=="c2s3", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(black)) (scatter I year if section=="c2s4", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(gs12)), title("Class 2 : Space", size(medium)) ytitle("") xtitle("Year", size(small)) ylabel(0.5 1 1.5 2 2.5) xlabel (1880 1900 1920 1940 1960 1980 2000) legend(lab(1 "`lg1'") lab(2 "`lg2'") lab(3 "`lg3'") lab(4 "`lg4'") cols(3) rows(2) size(vsmall)) name(b, replace)

* Class 3

levelsof sectionname if section=="c3s1", local(lg1) clean
levelsof sectionname if section=="c3s2", local(lg2) clean
levelsof sectionname if section=="c3s3", local(lg3) clean

sort year I
twoway(scatter I year if section=="c3s1", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(black)) (scatter I year if section=="c3s2", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(gs12)) (scatter I year if section=="c3s3", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(black)), title("Class 3 : Matter", size(medium)) ytitle("") xtitle("Year", size(small)) ylabel(0.5 1 1.5 2 2.5) xlabel (1880 1900 1920 1940 1960 1980 2000) legend(lab(1 "`lg1'") lab(2 "`lg2'") lab(3 "`lg3'") cols(3) rows(1) size(vsmall)) name(c, replace)

* Class 4 : Division 1

levelsof sectionname if section=="c4d1s1", local(lg1) clean
levelsof sectionname if section=="c4d1s2", local(lg2) clean
levelsof sectionname if section=="c4d1s3", local(lg3) clean
levelsof sectionname if section=="c4d1s4", local(lg4) clean
levelsof sectionname if section=="c4d1s5", local(lg5) clean
levelsof sectionname if section=="c4d1s6", local(lg6) clean
levelsof sectionname if section=="c4d1s7", local(lg7) clean

sort year I
twoway(scatter I year if section=="c4d1s1", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(black)) (scatter I year if section=="c4d1s2", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(gs12)) (scatter I year if section=="c4d1s3", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(black)) (scatter I year if section=="c4d1s4", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(gs12)) (scatter I year if section=="c4d1s5", c(l) msymbol(i) lwidth(medium) lpattern(solid) lcolor(black)) (scatter I year if section=="c4d1s6", c(l) msymbol(i) lwidth(medium) lpattern(solid) lcolor(gs12)) (scatter I year if section=="c4d1s7", c(l) msymbol(i) lwidth(medium) lpattern(dash) lcolor(black)), title("Class 4, Division 1 : Formation of Ideas", size(medium)) ytitle("") xtitle("Year", size(small)) ylabel(0.5 1 1.5 2 2.5) xlabel (1880 1900 1920 1940 1960 1980 2000) legend(lab(1 "`lg1'") lab(2 "`lg2'") lab(3 "`lg3'") lab(4 "`lg4'") lab(5 "`lg5'") lab(6 "`lg6'") lab(7 "`lg7'") cols(2) rows(4) size(vsmall)) name(d, replace)

* Class 4 : Division 2

levelsof sectionname if section=="c4d2s1", local(lg1) clean
levelsof sectionname if section=="c4d2s2", local(lg2) clean
levelsof sectionname if section=="c4d2s3", local(lg3) clean

sort year I
twoway(scatter I year if section=="c4d2s1", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(black)) (scatter I year if section=="c4d2s2", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(gs12)) (scatter I year if section=="c4d2s3", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(black)), title("Class 4, Division 2 : Communication Ideas", size(medium)) ytitle("") xtitle("Year", size(small)) ylabel(0.5 1 1.5 2 2.5) xlabel (1880 1900 1920 1940 1960 1980 2000) legend(lab(1 "`lg1'") lab(2 "`lg2'") lab(3 "`lg3'") cols(2) rows(2) size(vsmall)) name(e, replace)

* Class 5 : Division 1

levelsof sectionname if section=="c5d1s1", local(lg1) clean
levelsof sectionname if section=="c5d1s2", local(lg2) clean
levelsof sectionname if section=="c5d1s3", local(lg3) clean
levelsof sectionname if section=="c5d1s4", local(lg4) clean
levelsof sectionname if section=="c5d1s5", local(lg5) clean

sort year I
twoway (scatter I year if section=="c5d1s1", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(black)) (scatter I year if section=="c5d1s2", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(gs12)) (scatter I year if section=="c5d1s3", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(black)) (scatter I year if section=="c5d1s4", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(gs12)) (scatter I year if section=="c5d1s5", c(l) msymbol(i) lwidth(medium) lpattern(solid) lcolor(black)), title("Class 5, Division 1 : Individual Volition", size(medium)) ytitle("") xtitle("Year", size(small)) ylabel(0.5 1 1.5 2 2.5) xlabel (1880 1900 1920 1940 1960 1980 2000) legend(lab(1 "`lg1'") lab(2 "`lg2'") lab(3 "`lg3'") lab(4 "`lg4'") lab(5 "`lg5'") cols(2) rows(3) size(vsmall)) name(f, replace)

* Class 5, Division 2

levelsof sectionname if section=="c5d2s1", local(lg1) clean
levelsof sectionname if section=="c5d2s2", local(lg2) clean
levelsof sectionname if section=="c5d2s3", local(lg3) clean
levelsof sectionname if section=="c5d2s4", local(lg4) clean

sort year I
twoway (scatter I year if section=="c5d2s1", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(black)) (scatter I year if section=="c5d2s2", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(gs12)) (scatter I year if section=="c5d2s3", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(black)) (scatter I year if section=="c5d2s4", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(gs12)), title("Class 5, Division 2 : Social Volition", size(medium)) ytitle("") xtitle("Year", size(small)) ylabel(0.5 1 1.5 2 2.5) xlabel (1880 1900 1920 1940 1960 1980 2000) legend(lab(1 "`lg1'") lab(2 "`lg2'") lab(3 "`lg3'") lab(4 "`lg4'") cols(2) rows(3) size(vsmall)) name(g, replace)

* Class 6

levelsof sectionname if section=="c6s1", local(lg1) clean
levelsof sectionname if section=="c6s2", local(lg2) clean
levelsof sectionname if section=="c6s3", local(lg3) clean
levelsof sectionname if section=="c6s4", local(lg4) clean
levelsof sectionname if section=="c6s5", local(lg5) clean

sort year I
twoway (scatter I year if section=="c6s1", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(black)) (scatter I year if section=="c6s2", c(l) msymbol(i) lwidth(thick) lpattern(solid) lcolor(gs12)) (scatter I year if section=="c6s3", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(black)) (scatter I year if section=="c6s4", c(l) msymbol(i) lwidth(thick) lpattern(dash) lcolor(gs12)) (scatter I year if section=="c6s5", c(l) msymbol(i) lwidth(medium) lpattern(solid) lcolor(black)), title("Class 6 : Emotion, Religion and Morality", size(medium)) xtitle("Year", size(small)) ylabel(0.5 1 1.5 2 2.5) xlabel (1880 1900 1920 1940 1960 1980 2000) legend(lab(1 "`lg1'") lab(2 "`lg2'") lab(3 "`lg3'") lab(4 "`lg4'") lab(5 "`lg5'") cols(2) rows(3) size(vsmall)) name(h, replace)

gr combine a b c d, title("Figure A9") note("Note: Employment-weighted mean of thesaurus section task content based on verbs from time-invariant occupation" "descriptions from the 1991 DOTs.", size(vsmall)) iscale(0.6)

gr combine e f g h, title("Figure A10") note("Note: Employment-weighted mean of thesaurus section task content based on verbs from time-invariant occupation" "descriptions from the 1991 DOTs.", size(vsmall)) iscale(0.6)


