* Table 1
use y1880_coll, clear
drop if occ==. | metro==. | weight==.
gen occind = occ1*10000 + ind
collapse (first) dcp, by(occind)
keep occind
so occind
sa temp, replace
use y2000_coll, clear
drop if occ==. | metro==. | weight==.
gen occind = occ1*10000 + ind
collapse (first) dcp, by(occind)
so occind
merge occind using temp
keep if _m==3
drop _m
keep occind
so occind
sa temp_o, replace
local num = 1880
use y`num'_coll, clear
gen occind = occ1*10000 + ind
so occind
merge occind using temp_o
keep if _m==3
drop _m
drop if occ1==2 | occ1==672 | occ1==0 | occ1==. | metro==. | weight==.
drop occind
keep if ind1950>=200
drop if ind > 980
drop if occ1950==810 | occ==820 | occ==830 | occ==840 | occ==100 | occ==123
reg metro i.occ i.ind [pweight = weight], robust, if ind>=200
outreg2 using temp, replace
sa temp3, replace
so occ
bys occ: keep if _n == 1
keep occ
sa temp2, replace
use temp3, clear
so ind
bys ind: keep if _n == 1
keep ind
append using temp2
so occ ind
matrix c=e(b)'
svmat double c, name(b`num')
drop if occ==. & ind==.
tostring occ, replace
tostring ind, replace
gen occind = occ1+"x"+ind
so occind
sa temp, replace
foreach num of numlist 2000 {
use y`num'_coll, clear
gen occind = occ1*10000 + ind
so occind
merge occind using temp_o
keep if _m==3
drop _m
drop if occ1==2 | occ1==672 | occ1==0 | occ1==. | metro==. | weight==.
drop occind
keep if ind1950>=200
drop if occ1950==810 | occ==820 | occ==830 | occ==840 | occ==100 | occ==123
reg metro i.occ i.ind [pweight = weight], robust, if ind>=200
outreg2 using temp, append
sa temp3, replace
so occ
bys occ: keep if _n == 1
keep occ
sa temp2, replace
use temp3, clear
so ind
bys ind: keep if _n == 1
keep ind
append using temp2
so occ ind
matrix c=e(b)'
svmat double c, name(b`num')
drop if occ==. & ind==.
tostring occ, replace force
tostring ind, replace force
gen occind = occ1+"x"+ind
so occind
merge occind using temp
drop _m
so occind
sa temp, replace
}
use temp, clear
drop if b1880 == 0
drop if b1880 == .
drop if b2000 == 0
drop if b2000 == .
keep occ* ind b*
local xlist "1880 2000"
gen occd = occ1 !="."
foreach x of local xlist {
ren b`x'1 b`x'
gsort occd -b`x'
by occd: gen rank`x' = _n if b`x' != .
}
so occind
destring occ1, replace
destring ind, replace
label values occ1 occ1950lbl
label values ind ind1950_lbl
drop occind occd
so occ ind
gen c = occ==.
foreach var of varlist b* {
egen a = mean(`var'), by(c)
replace `var' = `var' - a
drop a
}
sa temp, replace
use temp, clear
gen diff2000 = rank2000-rank1880
drop if occ ==.
keep occ diff*
reshape long diff, i(occ) j(year)
drop if diff==.
so year diff
by year:  keep if _n<21 | _n>_N-20
by year: gen rank = _n
reshape wide occ diff, i(rank) j(year)
label define occ1950lbl 000 `"Accountants and auditors"', add
label define occ1950lbl 001 `"Actors and actresses"', add
label define occ1950lbl 002 `"Airplane pilots and navigators"', add
label define occ1950lbl 003 `"Architects"', add
label define occ1950lbl 004 `"Artists and art teachers"', add
label define occ1950lbl 005 `"Athletes"', add
label define occ1950lbl 006 `"Authors"', add
label define occ1950lbl 007 `"Chemists"', add
label define occ1950lbl 008 `"Chiropractors"', add
label define occ1950lbl 009 `"Clergymen"', add
label define occ1950lbl 010 `"College presidents and deans"', add
label define occ1950lbl 012 `"Aricultural sciences-Professors and instructors"', add
label define occ1950lbl 013 `"Biological sciences-Professors and instructors"', add
label define occ1950lbl 014 `"Chemistry-Professors and instructors"', add
label define occ1950lbl 015 `"Economics-Professors and instructors"', add
label define occ1950lbl 016 `"Engineering-Professors and instructors"', add
label define occ1950lbl 017 `"Geology and geophysics-Professors and instructors"', add
label define occ1950lbl 018 `"Mathematics-Professors and instructors"', add
label define occ1950lbl 019 `"Medical Sciences-Professors and instructors"', add
label define occ1950lbl 023 `"Physics-Professors and instructors"', add
label define occ1950lbl 024 `"Psychology-Professors and instructors"', add
label define occ1950lbl 025 `"Statistics-Professors and instructors"', add
label define occ1950lbl 026 `"Natural science (nec)-Professors and instructors"', add
label define occ1950lbl 027 `"Social sciences (nec)-Professors and instructors"', add
label define occ1950lbl 028 `"Nonscientific subjects-Professors and instructors"', add
label define occ1950lbl 029 `"Subject not specified-Professors and instructors"', add
label define occ1950lbl 031 `"Dancers and dancing teachers"', add
label define occ1950lbl 032 `"Dentists"', add
label define occ1950lbl 033 `"Designers"', add
label define occ1950lbl 034 `"Dietitians and nutritionists"', add
label define occ1950lbl 035 `"Draftsmen"', add
label define occ1950lbl 036 `"Editors and reporters"', add
label define occ1950lbl 041 `"Aeronautical-Engineers"', add
label define occ1950lbl 042 `"Chemical-Engineers"', add
label define occ1950lbl 043 `"Civil-Engineers"', add
label define occ1950lbl 044 `"Electrical-Engineers"', add
label define occ1950lbl 045 `"Industrial-Engineers"', add
label define occ1950lbl 046 `"Mechanical-Engineers"', add
label define occ1950lbl 047 `"Metallurgical, metallurgists-Engineers"', add
label define occ1950lbl 048 `"Mining-Engineers"', add
label define occ1950lbl 049 `"Engineers (nec)"', add
label define occ1950lbl 051 `"Entertainers (nec)"', add
label define occ1950lbl 052 `"Farm and home management advisors"', add
label define occ1950lbl 053 `"Foresters and conservationists"', add
label define occ1950lbl 054 `"Funeral directors and embalmers"', add
label define occ1950lbl 055 `"Lawyers and judges"', add
label define occ1950lbl 056 `"Librarians"', add
label define occ1950lbl 057 `"Musicians and music teachers"', add
label define occ1950lbl 058 `"Nurses, professional"', add
label define occ1950lbl 059 `"Nurses, student professional"', add
label define occ1950lbl 061 `"Agricultural scientists"', add
label define occ1950lbl 062 `"Biological scientists"', add
label define occ1950lbl 063 `"Geologists and geophysicists"', add
label define occ1950lbl 067 `"Mathematicians"', add
label define occ1950lbl 068 `"Physicists"', add
label define occ1950lbl 069 `"Misc. natural scientists"', add
label define occ1950lbl 070 `"Optometrists"', add
label define occ1950lbl 071 `"Osteopaths"', add
label define occ1950lbl 072 `"Personnel and labor relations workers"', add
label define occ1950lbl 073 `"Pharmacists"', add
label define occ1950lbl 074 `"Photographers"', add
label define occ1950lbl 075 `"Physicians and surgeons"', add
label define occ1950lbl 076 `"Radio operators"', add
label define occ1950lbl 077 `"Recreation and group workers"', add
label define occ1950lbl 078 `"Religious workers"', add
label define occ1950lbl 079 `"Social and welfare workers, except group"', add
label define occ1950lbl 081 `"Economists"', add
label define occ1950lbl 082 `"Psychologists"', add
label define occ1950lbl 083 `"Statisticians and actuaries"', add
label define occ1950lbl 084 `"Misc social scientists"', add
label define occ1950lbl 091 `"Sports instructors and officials"', add
label define occ1950lbl 092 `"Surveyors"', add
label define occ1950lbl 093 `"Teachers (n.e.c.)"', add
label define occ1950lbl 094 `"Medical and dental-technicians"', add
label define occ1950lbl 095 `"Testing-technicians"', add
label define occ1950lbl 096 `"Technicians (nec)"', add
label define occ1950lbl 097 `"Therapists and healers (nec)"', add
label define occ1950lbl 098 `"Veterinarians"', add
label define occ1950lbl 099 `"Professional, technical and kindred workers (nec)"', add
label define occ1950lbl 100 `"Farmers (owners and tenants)"', add
label define occ1950lbl 123 `"Farm managers"', add
label define occ1950lbl 200 `"Buyers and dept heads, store"', add
label define occ1950lbl 201 `"Buyers and shippers, farm products"', add
label define occ1950lbl 203 `"Conductors, railroad"', add
label define occ1950lbl 204 `"Credit men"', add
label define occ1950lbl 205 `"Floormen and floor managers, store"', add
label define occ1950lbl 210 `"Inspectors, public administration"', add
label define occ1950lbl 230 `"Managers and superintendants, building"', add
label define occ1950lbl 240 `"Officers, pilots, pursers and engineers, ship"', add
label define occ1950lbl 250 `"Officials and administratators (nec), public administration"', add
label define occ1950lbl 260 `"Officials, lodge, society, union, etc."', add
label define occ1950lbl 270 `"Postmasters"', add
label define occ1950lbl 280 `"Purchasing agents and buyers (nec)"', add
label define occ1950lbl 290 `"Managers, officials, and proprietors (nec)"', add
label define occ1950lbl 300 `"Agents (nec)"', add
label define occ1950lbl 301 `"Attendants and assistants, library"', add
label define occ1950lbl 302 `"Attendants, physicians and dentists office"', add
label define occ1950lbl 304 `"Baggagemen, transportation"', add
label define occ1950lbl 305 `"Bank tellers"', add
label define occ1950lbl 310 `"Bookkeepers"', add
label define occ1950lbl 320 `"Cashiers"', add
label define occ1950lbl 321 `"Collectors, bill and account"', add
label define occ1950lbl 322 `"Dispatchers and starters, vehicle"', add
label define occ1950lbl 325 `"Express messengers and railway mail clerks"', add
label define occ1950lbl 335 `"Mail carriers"', add
label define occ1950lbl 340 `"Messengers and office boys"', add
label define occ1950lbl 341 `"Office machine operators"', add
label define occ1950lbl 342 `"Shipping and receiving clerks"', add
label define occ1950lbl 350 `"Stenographers, typists, and secretaries"', add
label define occ1950lbl 360 `"Telegraph messengers"', add
label define occ1950lbl 365 `"Telegraph operators"', add
label define occ1950lbl 370 `"Telephone operators"', add
label define occ1950lbl 380 `"Ticket, station, and express agents"', add
label define occ1950lbl 390 `"Clerical and kindred workers (n.e.c.)"', add
label define occ1950lbl 400 `"Advertising agents and salesmen"', add
label define occ1950lbl 410 `"Auctioneers"', add
label define occ1950lbl 420 `"Demonstrators"', add
label define occ1950lbl 430 `"Hucksters and peddlers"', add
label define occ1950lbl 450 `"Insurance agents and brokers"', add
label define occ1950lbl 460 `"Newsboys"', add
label define occ1950lbl 470 `"Real estate agents and brokers"', add
label define occ1950lbl 480 `"Stock and bond salesmen"', add
label define occ1950lbl 490 `"Salesmen and sales clerks (nec)"', add
label define occ1950lbl 500 `"Bakers"', add
label define occ1950lbl 501 `"Blacksmiths"', add
label define occ1950lbl 502 `"Bookbinders"', add
label define occ1950lbl 503 `"Boilermakers"', add
label define occ1950lbl 504 `"Brickmasons,stonemasons, and tile setters"', add
label define occ1950lbl 505 `"Cabinetmakers"', add
label define occ1950lbl 510 `"Carpenters"', add
label define occ1950lbl 511 `"Cement and concrete finishers"', add
label define occ1950lbl 512 `"Compositors and typesetters"', add
label define occ1950lbl 513 `"Cranemen,derrickmen, and hoistmen"', add
label define occ1950lbl 514 `"Decorators and window dressers"', add
label define occ1950lbl 515 `"Electricians"', add
label define occ1950lbl 520 `"Electrotypers and stereotypers"', add
label define occ1950lbl 521 `"Engravers, except photoengravers"', add
label define occ1950lbl 522 `"Excavating, grading, and road machinery operators"', add
label define occ1950lbl 523 `"Foremen (nec)"', add
label define occ1950lbl 524 `"Forgemen and hammermen"', add
label define occ1950lbl 525 `"Furriers"', add
label define occ1950lbl 530 `"Glaziers"', add
label define occ1950lbl 531 `"Heat treaters, annealers, temperers"', add
label define occ1950lbl 532 `"Inspectors, scalers, and graders log and lumber"', add
label define occ1950lbl 533 `"Inspectors (nec)"', add
label define occ1950lbl 534 `"Jewelers, watchmakers, goldsmiths, and silversmiths"', add
label define occ1950lbl 535 `"Job setters, metal"', add
label define occ1950lbl 540 `"Linemen and servicemen, telegraph, telephone, and power"', add
label define occ1950lbl 541 `"Locomotive engineers"', add
label define occ1950lbl 542 `"Locomotive firemen"', add
label define occ1950lbl 543 `"Loom fixers"', add
label define occ1950lbl 544 `"Machinists"', add
label define occ1950lbl 545 `"Airplane-mechanics and repairmen"', add
label define occ1950lbl 550 `"Automobile-mechanics and repairmen"', add
label define occ1950lbl 551 `"Office machine-mechanics and repairmen"', add
label define occ1950lbl 552 `"Radio and television-mechanics and repairmen"', add
label define occ1950lbl 553 `"Railroad and car shop-mechanics and repairmen"', add
label define occ1950lbl 554 `"Mechanics and repairmen (nec)"', add
label define occ1950lbl 555 `"Millers, grain, flour, feed, etc"', add
label define occ1950lbl 560 `"Millwrights"', add
label define occ1950lbl 561 `"Molders, metal"', add
label define occ1950lbl 562 `"Motion picture projectionists"', add
label define occ1950lbl 563 `"Opticians and lens grinders and polishers"', add
label define occ1950lbl 564 `"Painters, construction and maintenance"', add
label define occ1950lbl 565 `"Paperhangers"', add
label define occ1950lbl 570 `"Pattern and model makers, except paper"', add
label define occ1950lbl 571 `"Photoengravers and lithographers"', add
label define occ1950lbl 572 `"Piano and organ tuners and repairmen"', add
label define occ1950lbl 573 `"Plasterers"', add
label define occ1950lbl 574 `"Plumbers and pipe fitters"', add
label define occ1950lbl 575 `"Pressmen and plate printers, printing"', add
label define occ1950lbl 580 `"Rollers and roll hands, metal"', add
label define occ1950lbl 581 `"Roofers and slaters"', add
label define occ1950lbl 582 `"Shoemakers and repairers, except factory"', add
label define occ1950lbl 583 `"Stationary engineers"', add
label define occ1950lbl 584 `"Stone cutters and stone carvers"', add
label define occ1950lbl 585 `"Structural metal workers"', add
label define occ1950lbl 590 `"Tailors and tailoresses"', add
label define occ1950lbl 591 `"Tinsmiths, coppersmiths, and sheet metal workers"', add
label define occ1950lbl 592 `"Tool makers, and die makers and setters"', add
label define occ1950lbl 593 `"Upholsterers"', add
label define occ1950lbl 594 `"Craftsmen and kindred workers (nec)"', add
label define occ1950lbl 595 `"Members of the armed services"', add
label define occ1950lbl 600 `"Auto mechanics apprentice"', add
label define occ1950lbl 601 `"Bricklayers and masons apprentice"', add
label define occ1950lbl 602 `"Carpenters apprentice"', add
label define occ1950lbl 603 `"Electricians apprentice"', add
label define occ1950lbl 604 `"Machinists and toolmakers apprentice"', add
label define occ1950lbl 605 `"Mechanics, except auto apprentice"', add
label define occ1950lbl 610 `"Plumbers and pipe fitters apprentice"', add
label define occ1950lbl 611 `"Apprentices, building trades (nec)"', add
label define occ1950lbl 612 `"Apprentices, metalworking trades (nec)"', add
label define occ1950lbl 613 `"Apprentices, printing trades"', add
label define occ1950lbl 614 `"Apprentices, other specified trades"', add
label define occ1950lbl 615 `"Apprentices, trade not specified"', add
label define occ1950lbl 620 `"Asbestos and insulation workers"', add
label define occ1950lbl 621 `"Attendants, auto service and parking"', add
label define occ1950lbl 622 `"Blasters and powdermen"', add
label define occ1950lbl 623 `"Boatmen, canalmen, and lock keepers"', add
label define occ1950lbl 624 `"Brakemen, railroad"', add
label define occ1950lbl 625 `"Bus drivers"', add
label define occ1950lbl 630 `"Chainmen, rodmen, and axmen, surveying"', add
label define occ1950lbl 631 `"Conductors, bus and street railway"', add
label define occ1950lbl 632 `"Deliverymen and routemen"', add
label define occ1950lbl 633 `"Dressmakers and seamstresses except factory"', add
label define occ1950lbl 634 `"Dyers"', add
label define occ1950lbl 635 `"Filers, grinders, and polishers, metal"', add
label define occ1950lbl 640 `"Fruit, nut, and vegetable graders, and packers, except facto"', add
label define occ1950lbl 641 `"Furnacemen, smeltermen and pourers"', add
label define occ1950lbl 642 `"Heaters, metal"', add
label define occ1950lbl 643 `"Laundry and dry cleaning Operatives"', add
label define occ1950lbl 644 `"Meat cutters, except slaughter and packing house"', add
label define occ1950lbl 645 `"Milliners"', add
label define occ1950lbl 650 `"Mine operatives and laborers"', add
label define occ1950lbl 660 `"Motormen, mine, factory, logging camp, etc"', add
label define occ1950lbl 661 `"Motormen, street, subway, and elevated railway"', add
label define occ1950lbl 662 `"Oilers and greaser, except auto"', add
label define occ1950lbl 670 `"Painters, except construction or maintenance"', add
label define occ1950lbl 671 `"Photographic process workers"', add
label define occ1950lbl 672 `"Power station operators"', add
label define occ1950lbl 673 `"Sailors and deck hands"', add
label define occ1950lbl 674 `"Sawyers"', add
label define occ1950lbl 675 `"Spinners, textile"', add
label define occ1950lbl 680 `"Stationary firemen"', add
label define occ1950lbl 681 `"Switchmen, railroad"', add
label define occ1950lbl 682 `"Taxicab drivers and chauffeurs"', add
label define occ1950lbl 683 `"Truck and tractor drivers"', add
label define occ1950lbl 684 `"Weavers, textile"', add
label define occ1950lbl 685 `"Welders and flame cutters"', add
label define occ1950lbl 690 `"Operative and kindred workers (nec)"', add
label define occ1950lbl 700 `"Housekeepers, private household"', add
label define occ1950lbl 710 `"Laundressses, private household"', add
label define occ1950lbl 720 `"Private household workers (nec)"', add
label define occ1950lbl 730 `"Attendants, hospital and other institution"', add
label define occ1950lbl 731 `"Attendants, professional and personal service (nec)"', add
label define occ1950lbl 732 `"Attendants, recreation and amusement"', add
label define occ1950lbl 740 `"Barbers, beauticians, and manicurists"', add
label define occ1950lbl 750 `"Bartenders"', add
label define occ1950lbl 751 `"Bootblacks"', add
label define occ1950lbl 752 `"Boarding and lodging house keepers"', add
label define occ1950lbl 753 `"Charwomen and cleaners"', add
label define occ1950lbl 754 `"Cooks, except private household"', add
label define occ1950lbl 760 `"Counter and fountain workers"', add
label define occ1950lbl 761 `"Elevator operators"', add
label define occ1950lbl 762 `"Firemen, fire protection"', add
label define occ1950lbl 763 `"Guards, watchmen, and doorkeepers"', add
label define occ1950lbl 764 `"Housekeepers and stewards, except private household"', add
label define occ1950lbl 770 `"Janitors and sextons"', add
label define occ1950lbl 771 `"Marshals and constables"', add
label define occ1950lbl 772 `"Midwives"', add
label define occ1950lbl 773 `"Policemen and detectives"', add
label define occ1950lbl 780 `"Porters"', add
label define occ1950lbl 781 `"Practical nurses"', add
label define occ1950lbl 782 `"Sheriffs and bailiffs"', add
label define occ1950lbl 783 `"Ushers, recreation and amusement"', add
label define occ1950lbl 784 `"Waiters and waitresses"', add
label define occ1950lbl 785 `"Watchmen (crossing) and bridge tenders"', add
label define occ1950lbl 790 `"Service workers, except private household (nec)"', add
label define occ1950lbl 810 `"Farm foremen"', add
label define occ1950lbl 820 `"Farm laborers, wage workers"', add
label define occ1950lbl 830 `"Farm laborers, unpaid family workers"', add
label define occ1950lbl 840 `"Farm service laborers, self-employed"', add
label define occ1950lbl 910 `"Fishermen and oystermen"', add
label define occ1950lbl 920 `"Garage laborers and car washers and greasers"', add
label define occ1950lbl 930 `"Gardeners, except farm, and groundskeepers"', add
label define occ1950lbl 940 `"Longshoremen and stevedores"', add
label define occ1950lbl 950 `"Lumbermen, raftsmen, and woodchoppers"', add
label define occ1950lbl 960 `"Teamsters"', add
label define occ1950lbl 970 `"Laborers (nec)"', add
label define occ1950lbl 980 `"Keeps house/housekeeping at home/housewife"', add
label define occ1950lbl 981 `"Imputed keeping house (1850-1900)"', add
label define occ1950lbl 982 `"Helping at home/helps parents/housework"', add
label define occ1950lbl 983 `"At school/student"', add
label define occ1950lbl 984 `"Retired"', add
label define occ1950lbl 985 `"Unemployed/without occupation"', add
label define occ1950lbl 986 `"Invalid/disabled w/ no occupation reported"', add
label define occ1950lbl 987 `"Inmate"', add
label define occ1950lbl 991 `"Gentleman/lady/at leisure"', add
label define occ1950lbl 995 `"Other non-occupation"', add
label define occ1950lbl 997 `"Occupation missing/unknown"', add
label define occ1950lbl 999 `"N/A (blank)"', add
label values occ1 occ1950lbl


erase temp.dta
erase temp.txt
erase temp2.dta
erase temp3.dta
erase temp_o.dta
