* Figure 1

use panel_occ_ind_metro.dta, clear
tab year, gen(yeard)
reg im1_1991 yeard* [pweight=perwt], nocons
foreach num of numlist 1(1)7 {
local all`num' = _b[yeard`num']
}
reg im1_1991 yeard* [pweight=perwt], nocons, if metro==0
foreach num of numlist 1(1)7 {
local nm`num' = _b[yeard`num']
}
reg im1_1991 yeard* [pweight=perwt], nocons, if metro==1
foreach num of numlist 1(1)7 {
local m`num' = _b[yeard`num']
}
clear
set obs 7
gen all = .
gen nm = .
gen m = .
gen year = .
foreach num of numlist 1(1)7 {
replace year = `num'*20+1860 if _n==`num'
replace all = `all`num'' if _n==`num'
replace nm = `nm`num'' if _n==`num'
replace m = `m`num'' if _n==`num'
}

twoway(line all all year, clwidth(thick) ylab(0.49(0.02)0.57) clcolor(black black) legend(order(1) lab(1 "Overall Mean")) xtitle(Year) ytitle(Interactiveness) xlab(1880(20)2000) graphregion(fcolor(white)) title("Overall mean")) , name(a, replace)
twoway(line m year, clwidth(thick) ylab(0.49(0.02)0.57) clcolor(black) legend(order(1 2) lab(1 "Metro") lab(2 "Non-Metro") )) (line nm year, title("Mean by metro") clwidth(thick) clcolor(gs8) graphregion(fcolor(white)) xtitle(Year) ytitle(Interactiveness) xlab(1880(20)2000)), name(b, replace)

graph combine a b, title("Figure 1: Mean Interactiveness in Metro and Non-Metro Areas over Time", size(medium)) graphregion(fcolor(white)) note("Notes: Mean interactiveness is the employment-weighted average of interactiveness for each occupation. Interactiveness for each" "occupation is measured using the frequency with which verbs from time-invariant occupational descriptions from the 1991 DOTs" "appear in Class IV, Division 1 (Formation of Ideas), Class IV, Division 2 (Communication of Ideas) and Class V, Division 2 (Intersocial Volition)" "of the thesaurus.", size(vsmall))
