* Figure 3
* Figure 4

use panel_decomposition, clear
collapse (sum) measure*, by(year)
so year
twoway(line measureClerical year, graphregion(fcolor(white)) clwidth(thick thick thick thick) clpattern(solid dash solid dash) clcolor(black black gs8 gs8) title("Clerical and Kindred") ylab(-0.04(0.02)0.06) xtitle("") ytitle("")), name(pa, replace)
twoway(line measureCraftsmen year, graphregion(fcolor(white)) clwidth(thick thick thick thick) clpattern(solid dash solid dash) clcolor(black black gs8 gs8) title("Craftsmen") ylab(-0.04(0.02)0.06) xtitle("") ytitle("")), name(pb, replace)
twoway(line measureOperatives year, graphregion(fcolor(white)) clwidth(thick thick thick thick) clpattern(solid dash solid dash) clcolor(black black gs8 gs8) title("Operatives") ylab(-0.04(0.02)0.06) xtitle("") ytitle("")), name(pc, replace)
twoway(line measureSalesW year, graphregion(fcolor(white)) clwidth(thick thick thick thick) clpattern(solid dash solid dash) clcolor(black black gs8 gs8) title("Sales Workers") ylab(-0.04(0.02)0.06) xtitle("") ytitle("")), name(pd, replace)
twoway(line measureServiceW year, graphregion(fcolor(white)) clwidth(thick thick thick thick) clpattern(solid dash solid dash) clcolor(black black gs8 gs8) title("Service Workers") ylab(-0.04(0.02)0.06) xtitle("") ytitle("")), name(pe, replace)
twoway(line measureManagers year, graphregion(fcolor(white)) clwidth(thick thick thick thick) clpattern(solid dash solid dash) clcolor(black black gs8 gs8) title("Managers") ylab(-0.04(0.02)0.06) xtitle("") ytitle("")), name(pf, replace)
twoway(line measureProfessional year, graphregion(fcolor(white)) clwidth(thick thick thick thick) clpattern(solid dash solid dash) clcolor(black black gs8 gs8) title("Professionals") ylab(-0.04(0.02)0.06) xtitle("") ytitle("")), name(pg, replace)
twoway(line measureLaborers year, graphregion(fcolor(white)) clwidth(thick thick thick thick) clpattern(solid dash solid dash) clcolor(black black gs8 gs8) title("Laborers") ylab(-0.04(0.02)0.06) xtitle("") ytitle("")), name(ph, replace)
graph combine pa pb pc pd ph pe pf pg, iscale(0.4) graphregion(fcolor(white)) title("Figure 3: Decomposition of Difference in Change in" "Interactiveness Between Metro and Non-Metro Areas, Occupations", size(medium)) note("Notes: Decomposition of the difference between mean and non-metro areas in the change in mean interactiveness over 20-year time periods" "(equation (25) in the paper) into the contributions of two-digit occupations. X-axes are 20-year differences. Y-axes are differences in the change" "in mean interactiveness between metro and non-metro areas. Mean interactiveness is the employment-weighted average of interactiveness for" "each three-digit occupation. Interactiveness for each three-digit occupation is measured using the frequency with which verbs from time-invariant" "occupational descriptions from the 1991 DOTs appear in Class IV, Division 1 (Formation of Ideas), Class IV, Division 2 (Communication of Ideas)" "and Class V, Division 2 (Intersocial Volition) of the thesaurus.", size(vsmall))


use panel_decomposition, clear
gen a = 0
foreach var of varlist measure* {
replace `var' = 0 if `var' ==.
replace a = a + `var'
}
replace b = "BusinessServices" if b =="Business and Repair Services"
replace b = "Construction" if b =="Construction"
replace b = "Entertainment" if b =="Entertainment and Recreation Services"
replace b = "Finance" if b =="Finance, Insurance, and Real Estate"
replace b = "Manufacturing" if b =="Manufacturing"
replace b = "Mining" if b =="Mining"
replace b = "PersonalServices" if b =="Personal Services"
replace b = "ProfessionalServices" if b =="Professional and Related Services"
replace b = "PublicAdministration" if b =="Public Administration"
replace b = "TransportationCommunication" if b =="Transportation, Communication, and Other Utilities"
replace b = "Trade" if b =="Wholesale and Retail Trade"
keep a b year
reshape wide a, i(year) j(b) string
twoway(line aBusinessServices year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Business") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(pa, replace)
twoway(line aConstruction year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Construction") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(pb, replace)
twoway(line aEntertainment year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Entertainment") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(pc, replace)
twoway(line aFinance year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Finance") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(pd, replace)
twoway(line aManufacturing year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Manufacturing") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(pe, replace)
twoway(line aMining year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Mining") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(pf, replace)
twoway(line aPersonalServices year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Personal") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(pg, replace)
twoway(line aProfessionalServices year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Professional") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(ph, replace)
twoway(line aPublicAdministration year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Public Admin") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(pi, replace)
twoway(line aTrade year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Trade") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(pj, replace)
twoway(line aTransportationCommunication year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) title("Transportation") ylab(-0.04(0.02)0.04) xtitle("") ytitle("")), name(pk, replace)

graph combine pe pf pi pd pk pc pj pb pa pg ph , iscale(0.4) graphregion(fcolor(white)) title("Figure 4: Decomposition of Difference in Change in" "Interactiveness Between Metro and Non-Metro Areas, Sectors", size(medium)) note("Notes: Decomposition of the difference between mean and non-metro areas in the change in mean interactiveness over 20-year time periods" "(equation (25) in the paper) into the contributions of two-digit sectors. X-axes are 20-year differences. Y-axes are differences in the change" "in mean interactiveness between metro and non-metro areas. Mean interactiveness is the employment-weighted average of interactiveness for" "each three-digit occupation. Interactiveness for each three-digit occupation is measured using the frequency with which verbs from time-invariant" "occupational descriptions from the 1991 DOTs appear in Class IV, Division 1 (Formation of Ideas), Class IV, Division 2 (Communication of Ideas)" "and Class V, Division 2 (Intersocial Volition) of the thesaurus.", size(vsmall))
