version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear 
set more off
cd "${TERMINAL}/Chile/"
insheet using chile_final_brands.csv, comma clear

sort countryoforigin brandcode
*egen double countrybrand = group(countryoforigin brandcode)
egen double countrybrand = group(brandcode)

drop if fobvalueusdollars == . | quantity == . | countrybrand == . | time == . | hs8 ==. | hs2 == .

drop if fobvalueusdollars <=0 | quantity <= 0


collapse (sum) fobvalueusdollars quantity, by(hs2 countrybrand countryoforigin hs8 time countryoforigin brand hs6 brandcode) fast

gen double fobunitvalueusdollars = fobvalueusdollars/quantity

bys hs2 time: egen double totalcategorysales = sum(fobvalueusdollars)

bys hs2 countrybrand time: egen double totalcbrandsales = sum(fobvalueusdollars)

gen double cbrandshare = totalcbrandsales/totalcategorysales

gen double productshare = fobvalueusdollars/totalcbrandsales

save ChileanPricesShares.dta, replace

bys hs2 countrybrand countryoforigin hs8: egen double length = count(quantity)

bys hs2 countrybrand: egen double maxlength = max(length)

keep if length == maxlength

collapse (median) fobvalueusdollars, by(hs2 countrybrand countryoforigin hs8) fast

sort hs2 countrybrand

egen double hscbrand = group(hs2 countrybrand)

gsort hscbrand -fobvalueusdollars

keep if _n == 1 | (hscbrand[_n] != hscbrand[_n-1])


sort hs2 countrybrand countryoforigin hs8

save basehs8.dta,replace

use ChileanPricesShares.dta, clear

sort hs2 countrybrand countryoforigin hs8 

merge m:1 hs2 countrybrand countryoforigin hs8 using basehs8

drop if _merge !=3
drop _merge

rename countryoforigin countryoforigin_base 
rename hs8 hs8_base

rename productshare productshare_base

rename fobunitvalueusdollars fobunitvalueusdollars_base

keep hs2 countrybrand countryoforigin_base hs8_base productshare_base fobunitvalueusdollars_base time

sort hs2 countrybrand time

save basehs8data.dta,replace

use ChileanPricesShares.dta, clear

sort hs2 countrybrand time

merge m:1 hs2 countrybrand time using basehs8data

drop if _merge !=3

drop _merge

drop if (hs8 == hs8_base) & (countryoforigin == countryoforigin_base)

sort hs2 countrybrand countryoforigin hs8
egen double product = group(hs2 countrybrand countryoforigin hs8)

drop if product == .

sort product time
xtset product time

gen double dlnprodshare = ln(productshare) - ln(productshare_base)
gen double ddlnprodshare = d.dlnprodshare
gen double dlnprice = ln(fobunitvalueusdollars) - ln(fobunitvalueusdollars_base)
gen double ddlnprice = d.dlnprice

sum ddlnprice,d
local umin = `r(p10)'
local umax = `r(p90)'
replace ddlnprice = . if ddlnprice <= `umin'
replace ddlnprice = . if ddlnprice >= `umax'

sum ddlnprodshare,d
local smin = `r(p10)'
local smax = `r(p90)'
replace ddlnprodshare = . if ddlnprodshare <= `smin'
replace ddlnprodshare = . if ddlnprodshare >= `smax'

drop if ddlnprice == .
drop if ddlnprodshare == .

gen double y2 = ddlnprice*ddlnprice
gen double z1 = ddlnprice*ddlnprodshare
gen double z2 = ddlnprodshare*ddlnprodshare

bys hs2 countrybrand countryoforigin hs8: egen double y2_bar = mean(y2)	
by hs2 countrybrand countryoforigin hs8: egen double z1_bar = mean(z1)	
by hs2 countrybrand countryoforigin hs8: egen double z2_bar = mean(z2)
by hs2 countrybrand countryoforigin hs8: egen double t = count(z2)

sum t,d

drop if t < 5

gen double weight = t^(3/2)

bys hs2: egen double sum_weight = total(weight)
gen double weight_bar = weight/sum_weight

foreach var in y2_bar z1_bar z2_bar {
		replace `var' = `var'*weight_bar
}

collapse (mean) y2_bar z1_bar z2_bar t weight_bar, by(hs2 countrybrand countryoforigin hs8) fast

bys hs2: egen double countobs = count(y2_bar)

drop if countobs < 4

sort hs2
egen double pglist = group(hs2)
save chileanestimationdata.dta,replace

sum pglist, meanonly
local max = `r(max)'

forvalues i = 1/`max' {
forvalues k = 1/5 {
use chileanestimationdata.dta, clear
keep if pglist == `i'
local pg = hs2
local u = `k'+0.001
local w = (`k')/4
capture noisily: nl (y2_bar ={c1=0}+((({sigu=`u'}-2)*({omega})-1)/((1+{omega})*({sigu}-1)))*z1_bar+({omega=`w'}/((1+{omega})*({sigu}-1)))*z2_bar), eps(1e-10) vce(robust) hasconstant(c1)
local rc = _rc 
 
if `rc' == 0 { 
capture: local sigu_est = _b[sigu: _cons] 
capture: local omega_est = _b[omega: _cons] 
capture: local sigu_se = _se[sigu: _cons] 
capture: local omega_se = _se[omega: _cons] 
capture: local ssr = e(rss) 
capture: local r2 = e(r2) 
capture: local cobs = countobs
}

drop _all
set obs 1
gen hs2 = `pg'
if `rc' == 0 {
capture: gen double sigu = `sigu_est' 
capture: gen double omega = `omega_est' 
capture: gen double sigu_SE = `sigu_se' 
capture: gen double omega_SE = `omega_se' 
capture: gen double SSR = `ssr' 
capture: gen double r2 = `r2' 
capture: gen double obs = `cobs' 
}

*gen double mergevar = 1

*sort mergevar

if `i' > 1 | `k' > 1 {
	append using ChileanEstimationLower.dta
	}
	sort hs2
	save ChileanEstimationLower.dta, replace
}
}
 
 use ChileanEstimationLower.dta, clear
*drop if obs < 30
*drop if sigu_SE == 0
*drop if omega_SE == 0
*drop if sigu < 0 | omega < 0
sort hs2 SSR
collapse (firstnm) sigu omega sigu_SE omega_SE SSR r2 obs, by(hs2) fast
drop if obs < 30
sort hs2
* save the SigmaU estimates 
save ChileanSigmaU.dta, replace

use ChileanPricesShares.dta, clear
sort hs2
merge m:1 hs2 using ChileanSigmaU.dta
drop if _merge !=3
drop _merge

bys hs2 countrybrand time: egen double meanshare = mean(ln(productshare))
gen double geomeanshare = exp(meanshare)
by hs2 countrybrand time: egen double meanprice = mean(ln(fobunitvalueusdollars))
gen double geomeanprice = exp(meanprice)
gen double upcqualityt = (fobunitvalueusdollars/geomeanprice)*((productshare/geomeanshare)^(1/(sigu-1))) 
gen double relativeshare = productshare/geomeanshare
by hs2 countrybrand time: egen double relsharesum = sum(relativeshare)
gen double firmpriceindexother = (relsharesum ^ (1/(1-sigu)))*geomeanprice
gen double relup = (fobunitvalueusdollars/upcqualityt)^(1-sigu)
by hs2 countrybrand time: egen double relusum = sum(relup)
gen double firmpriceindex = relusum^(1/(1-sigu))
gen double lnfirmpriceindex = ln(firmpriceindex)

by hs2 countrybrand time: egen double countprod = count(fobunitvalueusdollars)

gen double IV = ln(relsharesum)
* use dispersion?
*gen double IV = ln(relsharesum/countprod)
replace IV = IV*(1/(1-sigu))

collapse (firstnm) firmpriceindex lnfirmpriceindex IV totalcbrandsales, by(hs2 countrybrand time) fast

bys hs2 time: egen double totalsales = sum(totalcbrandsales)
gen double firmshare = totalcbrandsales/totalsales
gen double lnfirmshare = ln(firmshare)

sort hs2 countrybrand

egen double firmmarket = group(hs2 countrybrand)

xtset firmmarket time

sort firmmarket time

gen double difflnfirmshare = d.lnfirmshare
gen double difflnfirmprice = d.lnfirmpriceindex
gen double diffIV = d.IV

save ChileanFirmLevelData.dta, replace

bys firmmarket : gen double count_yr = _N
bys hs2: egen double max_count_yr = max(count_yr)
keep if count_yr==max_count_yr

collapse (median) firmshare, by(hs2 firmmarket) fast

gsort hs2 -firmshare

keep if _n==1 | hs2!= hs2[_n-1]

keep hs2 firmmarket
sort hs2 firmmarket
save ChileanFirmbaselist.dta, replace

use ChileanFirmLevelData.dta, clear

sort hs2 firmmarket
merge m:1 hs2 firmmarket using ChileanFirmbaselist.dta
keep if _merge == 3
drop _merge

rename firmmarket firmmarket_base
rename difflnfirmshare difflnfirmshare_base
rename difflnfirmprice difflnfirmprice_base
rename diffIV diffIV_base

keep firmmarket_base hs2 time difflnfirmshare_base difflnfirmprice_base diffIV_base

sort hs2 time
save Firmbasedata.dta, replace

use ChileanFirmLevelData.dta, clear

sort hs2 time
merge m:1 hs2 time using Firmbasedata.dta
keep if _merge == 3
drop _merge

drop if firmmarket == firmmarket_base

gen double ddlnfirmshare = difflnfirmshare - difflnfirmshare_base
gen double ddlnfirmprice = difflnfirmprice - difflnfirmprice_base
gen double ddIV = diffIV - diffIV_base

sum ddlnfirmprice,d
local umin = `r(p1)'
local umax = `r(p99)'
replace ddlnfirmprice = . if ddlnfirmprice < `umin'
replace ddlnfirmprice = . if ddlnfirmprice > `umax'

sum ddlnfirmshare,d
local smin = `r(p1)'
local smax = `r(p99)'
replace ddlnfirmshare = . if ddlnfirmshare < `smin'
replace ddlnfirmshare = . if ddlnfirmshare > `smax'


sort hs2
egen double pglist = group(hs2)
save FirmEstimationData.dta, replace

sum pglist, meanonly
local max = `r(max)'

forvalues k = 1/`max' {
use FirmEstimationData.dta, clear
keep if pglist == `k'
local pg = hs2

ivreg2 ddlnfirmshare (ddlnfirmprice = ddIV), gmm2s robust
*ivreg2 ddlnfirmshare (ddlnfirmprice = ddIV), liml fuller(1) robust 
 
capture: local sigf_est = (1-(_b[ddlnfirmprice]))
capture: local sigf_se = _se[ddlnfirmprice]
capture: local ssr = e(rss) 
capture: local r2 = e(r2) 

drop _all
set obs 1
gen hs2 = `pg'
capture: gen double sigf = `sigf_est' 
capture: gen double sigf_SE = `sigf_se' 
capture: gen double SSR = `ssr' 
capture: gen double r2 = `r2'

if `k' > 1 {
	append using EstimationUpper.dta
	}

	sort hs2
	save EstimationUpper.dta, replace
}


use ChileanFirmLevelData.dta, clear

sort hs2
merge m:1 hs2 using ChileanSigmaU.dta
drop if _merge !=3
drop _merge

sort hs2 
merge m:1 hs2 using EstimationUpper.dta
drop if _merge !=3
drop _merge 

drop if sigu <=1 | sigf <=1
drop if sigf >= sigu

* compute for each product group the geometric mean of firm share and price 
bys hs2 time: egen double meanpgshare = mean(lnfirmshare)
gen double geomeanpgshare = exp(meanpgshare)
by hs2 time: egen double meanpgprice = mean(lnfirmpriceindex)
gen double geomeanpgprice = exp(meanpgprice)

* firm quality 
gen double firmqualityt = (firmpriceindex/geomeanpgprice)*((firmshare/geomeanpgshare)^(1/(sigf-1)))
gen double relpf = (firmpriceindex/firmqualityt)^(1-sigf)

* product group price index  
bys hs2 time: egen double relsum = sum(relpf)
gen double marketpriceindex = relsum^(1/(1-sigf))

sort hs2 countrybrand time
save ChileanFirmLevelData2.dta, replace

use ChileanPricesShares.dta, clear
sort hs2

merge m:1 hs2 using ChileanSigmaU.dta
drop if _merge !=3
drop _merge

sort hs2 
merge m:1 hs2 using EstimationUpper.dta
drop if _merge !=3
drop _merge 

drop if sigu <=1 | sigf <=1
drop if sigf >= sigu

sort hs2 countrybrand time

merge m:1 hs2 countrybrand time using ChileanFirmLevelData2.dta
drop if _merge !=3
drop _merge

* perceived elasticity 
gen double perceivedelasticity = sigf - (sigf-1)*firmshare

* markup 
gen double mft = perceivedelasticity/(perceivedelasticity-1)

* marginal cost 
gen double aut = fobunitvalueusdollars/mft

* markup 
gen double markup = (fobunitvalueusdollars - aut)/aut

bys hs2 countrybrand time: egen double meanshare = mean(ln(productshare))
gen double geomeanshare = exp(meanshare)
by hs2 countrybrand time: egen double meanprice = mean(ln(fobunitvalueusdollars))
gen double geomeanprice = exp(meanprice)
gen double upcqualityt = (fobunitvalueusdollars/geomeanprice)*((productshare/geomeanshare)^(1/(sigu-1))) 

gen double lnupcmc = ln(aut)
gen double lnmft = ln(mft)
gen double lnmarkup = ln(markup)
gen double lnupcquality = ln(upcqualityt)
gen double lnfirmquality = ln(firmqualityt)

**************************

bys hs2 countrybrand time: egen firmproduc = count(productshare)
by hs2 countrybrand time: egen geomeanAut = gmean(aut)
gen double AQratio = ((aut/geomeanAut)/upcqualityt)^(1-sigu)

gen double loggeomeanaut = log(geomeanAut)
gen double logfirmprod = log(firmproduc)
gen double logtotalsales = log(totalcbrandsales)

collapse  (mean) loggeomeanaut firmproduc logfirmprod logtotalsales firmqualityt mft sigf sigu (sum) AQratio, by(hs2 countrybrand time) fast
replace AQratio = AQratio/firmproduc

gen double lnmftterm = ln(mft)*(1-sigf)
gen double lnGeomeanAut = (1-sigf)*loggeomeanaut
gen double lnFirmQuality = (sigf-1)*ln(firmqualityt)
gen double lnAQratio = (ln(AQratio))*((1-sigf)/(1-sigu))
replace logfirmprod = logfirmprod*((1-sigf)/(1-sigu))

* compute the product group averages across firms 
foreach X in logtotalsales lnFirmQuality lnAQratio lnmftterm logfirmprod lnGeomeanAut{
    bys hs2 time: egen double a`X'=mean(`X')
}
* compute the double differenced variables 
foreach X in logtotalsales lnFirmQuality lnAQratio lnmftterm logfirmprod lnGeomeanAut{
    gen double d`X'=`X'-a`X'
}
* run the variance decompistion regressions 
foreach X in logtotalsales lnFirmQuality lnAQratio lnmftterm logfirmprod lnGeomeanAut{
    reg d`X' dlogtotalsales
}


save CrossSectionDecomposition.dta, replace


 
