version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear
set more off
cd "${TERMINAL}/Chile/"

use ChileanSigmaU.dta
merge 1:1 hs2 using EstimationUpper.dta,nogen keep(3)
rename sigu AsigU
rename sigf BsigF
rename omega Cdelta
foreach v of varlist BsigF AsigU Cdelta {
qui sum `v',d
gen med`v'= `r(p50)'
qui qreg `v'
gen med`v'_se = _se[_cons]
}

collapse (mean) med*
gen id = _n

reshape long med, i(id) j(median) string
drop id
gen bin = _n
replace median = substr(regexr(median,"_se","_(SE)"),2,.)
replace median = regexr(median,"sigF","$ \sigma^F$")
replace median = regexr(median,"sigU","$ \sigma^U$")
replace median = regexr(median,"delta","$ \delta$")

labmask bin,values(median)

la var bin "\multicolumn{1}{c}{Parameter}"

local v0: var la bin
local v1 "Median Estimate"


local K = 0
foreach v in med {
local ++K
gen length= length(string(round(`v',1)))
qui sum length
local int_`K' = `r(max)'
drop length
di "`v`K''"
}

local dec_list "3"
local col_format ""
forval k = `K'(-1)1 {
local k_start = 2*(`k'-1)+1
local dec_`k' = substr("`dec_list'",`k_start',1)
local col_format "`int_`k''|`dec_`k''|`col_format'"
}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"


cd ${TERMINAL}/results/tables
tabout bin using S2_est_distro_chile_Scol.tex, c(mean med) ///
h2(`v0'&`v1'\\) h3(nil) ///
replace sum ptotal(none) f(`dec_list') ///
style(tex) bt topf(top_Scol.tex) botf(bot_chile_est_Scol.tex) ///
botstr(\,|chile:estimatestable) ///
topstr(GMM Parameter Estimates Using Chilean Trade Transactions Data|\textwidth|`col_format')


! perl -i -pe 's/\\&/\&/g' S2_est_distro_chile_Scol.tex
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' S2_est_distro_chile_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' S2_est_distro_chile_Scol.tex
! perl -i -pe 's{(\)\K|\G)\&([\d\.]+)}{&(\2)}g' S2_est_distro_chile_Scol.tex
! perl -i -pe 'undef $/; s/(\\\\)\n.*\(SE\)/\1*\n/g' S2_est_distro_chile_Scol.tex
! perl -i -pe 's/\\(\\$)/\1/g' S2_est_distro_chile_Scol.tex

forval i=1/`K' {
! perl -i -pe 's/`v`i''/{\\parbox{\\linewidth}{\\centering `v`i''}}/g' S2_est_distro_chile_Scol.tex
}


! head -50 S2_est_distro_chile_Scol.tex

