version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear 
set more off
cd "${TERMINAL}/Chile/"

use ChileanPricesShares.dta, clear
sort hs2

merge m:1 hs2 using ChileanSigmaU.dta
drop if _merge !=3
drop _merge

sort hs2 
merge m:1 hs2 using EstimationUpper.dta
drop if _merge !=3
drop _merge 

drop if sigu <=1 | sigf <=1
drop if sigf >= sigu

sort hs2 countrybrand time

merge m:1 hs2 countrybrand time using ChileanFirmLevelData2.dta
drop if _merge !=3
drop _merge

* perceived elasticity 
gen double perceivedelasticity = sigf - (sigf-1)*firmshare

* markup 
gen double mft = perceivedelasticity/(perceivedelasticity-1)

* marginal cost 
gen double aut = fobunitvalueusdollars/mft

* markup 
gen double markup = (fobunitvalueusdollars - aut)/aut

bys hs2 countrybrand time: egen double meanshare = mean(ln(productshare))
gen double geomeanshare = exp(meanshare)
by hs2 countrybrand time: egen double meanprice = mean(ln(fobunitvalueusdollars))
gen double geomeanprice = exp(meanprice)
gen double upcqualityt = (fobunitvalueusdollars/geomeanprice)*((productshare/geomeanshare)^(1/(sigu-1))) 

gen double lnupcmc = ln(aut)
gen double lnmft = ln(mft)
gen double lnmarkup = ln(markup)
gen double lnupcquality = ln(upcqualityt)
gen double lnfirmquality = ln(firmqualityt)

gen double SigmaU = sigu
gen double SigmaF = sigf

gen double firmsalestotal = totalcbrandsales

**************************
/*
bys hs2 countrybrand time: egen double firmproduc = count(productshare)
by hs2 countrybrand time: egen double geomeanAut = gmean(aut)
gen double AQratio = ((aut/geomeanAut)/hs8 countryoforigin countrybrand qualityt)^(1-sigu)

gen double loggeomeanaut = log(geomeanAut)
gen double logfirmprod = log(firmproduc)
gen double logtotalsales = log(totalcbrandsales)

*collapse  (mean) loggeomeanaut firmproduc logfirmprod logtotalsales firmqualityt mft sigf sigu (sum) AQratio, by(hs2 countrybrand time) fast
bys hs2 countrybrand time: egen double AQratiosum = sum(AQratio)
replace AQratio = AQratiosum/firmproduc

gen double lnmftterm = ln(mft)*(1-sigf)
gen double lnGeomeanAut = (1-sigf)*loggeomeanaut
gen double lnFirmQuality = (sigf-1)*ln(firmqualityt)
gen double lnAQratio = (ln(AQratio))*((1-sigf)/(1-sigu))
replace logfirmprod = logfirmprod*((1-sigf)/(1-sigu))
*/
*************************************************
* Keep the time periods used for differentiation 
keep if time  == 1 | time == 32
replace time = 2 if time == 32
bys hs2 countrybrand time: gen list = _n
gen count = 1 if list == 1
bys hs2 countrybrand: egen timeperiods = sum(count)
sum timeperiods,d
drop if timeperiods !=2
* generate variables 
bys hs2 countrybrand time: egen double firmproduc = count(fobvalueusdollars)
gen double avgsales = firmsalestotal/firmproduc
by hs2 countrybrand time: egen double totalfirmsales = total(fobvalueusdollars)
* generate per period firm share of product group 
bys hs2 time: egen double productgroupsales = total(fobvalueusdollars)
gen firmshare2=totalfirmsales/productgroupsales
* define the cutoff rule for large firms: firms with market shares larger than 0.5%
*drop if firmshare2<0.005

* Define the marketing and product upgrading effects 
gen double lnuqual = lnupcquality/firmproduc
bys hs8 countryoforigin countrybrand hs2  (time): gen double lag_uqual=lnuqual[_n-1] if time[_n] == time[_n-1]+1 & hs8[_n] == hs8[_n-1] & countryoforigin[_n] == countryoforigin[_n-1] & countrybrand[_n] == countrybrand[_n-1]
gen double current=(lnuqual!=.) 
gen double previous=(lag_uqual!=.)	
gen double common=((current==1 & previous==1))
gen double current_only=(current==1 & common==0)

bys hs2 countrybrand time: egen double common_total = total(cond(common==1,lnuqual,.))
by hs2 countrybrand time: egen double common_lag_total = total(cond(common==1,lag_uqual,.))
by hs2 countrybrand time: egen double current_only_total = total(cond(current_only==1,lnuqual,.))
gen double current_total = common_total + current_only_total

bys hs2 countrybrand (time): gen double lag_current_total = current_total[_n-1] if time[_n] == time[_n-1]+1 & countrybrand[_n] == countrybrand[_n-1] & hs2[_n] == hs2[_n-1]
bys hs2 countrybrand (time): gen double lag_lnfirmquality = lnfirmquality[_n-1] if time[_n] == time[_n-1]+1 & countrybrand[_n] == countrybrand[_n-1] & hs2[_n] == hs2[_n-1]
gen double previous_only_total = lag_current_total - common_lag_total


* marginal cost price index
bys hs2 time: egen double pgsales = sum(fobvalueusdollars)
gen double share2 = fobvalueusdollars/pgsales
bys hs8 countryoforigin countrybrand   hs2 (time): gen double lag_aut=aut[_n-1] if time[_n] == time[_n-1]+1 & hs8[_n] == hs8[_n-1] & countryoforigin[_n] == countryoforigin[_n-1] & countrybrand[_n] == countrybrand[_n-1]
bys hs8 countryoforigin countrybrand   hs2 (time): gen double lag_share2=share2[_n-1] if time[_n] == time[_n-1]+1 & hs8[_n] == hs8[_n-1] & countryoforigin[_n] == countryoforigin[_n-1] & countrybrand[_n] == countrybrand[_n-1]
gen double val = (1/2)*(share2+lag_share2)*ln(aut/lag_aut)
bys hs2: egen double lnTorn = total(cond(common==1,val,.))
gen double Torn = exp(lnTorn)

* Turnover measures
gen double indicator = 1
bys hs8 countryoforigin countrybrand hs2 (time): gen double lag_indicator=indicator[_n-1] if time[_n] == time[_n-1]+1 & hs8[_n] == hs8[_n-1] & countryoforigin[_n] == countryoforigin[_n-1] & countrybrand[_n] == countrybrand[_n-1]
bys hs2 time: egen double common_products = total(cond(common==1,indicator,.))
by hs2 time: egen double current_only_products = total(cond(current_only==1,indicator,.))
gen double current_products = common_products + current_only_products
by hs2 time: egen double common_lag_products = total(cond(common==1,lag_indicator,.))
bys countrybrand hs2 (time): gen double lag_current_products = current_products[_n-1] if time[_n] == time[_n-1]+1 & hs2[_n] == hs2[_n-1]
gen double previous_only_products = lag_current_products - common_lag_products
gen double turnover = (current_only_products + previous_only_products)/(current_products+lag_current_products)
*
**  Note: (1) puremarketingeffect2 is the first term in the firm quality decomposition equation 
*         (2) product_quality_upgrading2 is the second term in the firm quality decomposition equation

gen double puremarketingeffect = common_total - common_lag_total
gen double puremarketingeffect1 = common_total 
gen double puremarketingeffect2 = -1*common_lag_total
gen double product_quality_upgrading = current_only_total - previous_only_total
gen double product_quality_upgrading1 = current_only_total 
gen double product_quality_upgrading2 = -1*previous_only_total
gen double changeinlnfirmquality = lnfirmquality - lag_lnfirmquality
gen double totalmarketingeffect = puremarketingeffect + changeinlnfirmquality
*
* generate the other variables used in the decomposition 
bys hs2 countrybrand time: egen geomeanAut = gmean(aut)
gen double AQratio = ((aut/geomeanAut)/upcqualityt)^(1-SigmaU)
* take the log of the variables 
gen double loggeomeanaut = log(geomeanAut)
gen double logfirmprod = log(firmproduc)
gen double logtotalsales = log(totalfirmsales)
gen double lnFirmQuality = ln(firmqualityt)
replace lnFirmQuality = (SigmaF-1)*lnFirmQuality
* 
collapse  (mean) loggeomeanaut puremarketingeffect1 product_quality_upgrading1 puremarketingeffect2 product_quality_upgrading2  puremarketingeffect product_quality_upgrading firmproduc logfirmprod logtotalsales firmqualityt mft SigmaF SigmaU (sum) AQratio, by(time hs2 countrybrand) fast
*
** 
replace AQratio = AQratio/firmproduc
*

sort hs2 countrybrand
egen pf=group(hs2 countrybrand)

xtset pf time

rename loggeomeanaut lnGeomeanAut
gen double lnFirmQuality = ln(firmqualityt)
gen double lnAQratio = ln(AQratio) 
gen double lnmftterm = ln(mft)*(1-SigmaF)

*cd ${TERMINAL}/results/reg_output/geometric_mean

la var logfirmprod "$\ln\left(\#\mathrm{hs8 countryoforigin countrybrand }_{ft}\right)$"
la var lnFirmQuality "$\ln\varphi_{ft}$"
la var lnmftterm "$(1-\sigma_f)\ln m_{ft}$"
la var lnAQratio "$\ln\left[\sum_u\left(\frac{a_{ut}}{\varphi_{ut}}\right)^{1-\sigma_u}\right]$"
la var logtotalsales "$\ln s_{ft}$"


* NEW SET UP TO SUM TO ONE
replace lnGeomeanAut = (1-SigmaF)*lnGeomeanAut
replace lnFirmQuality = (SigmaF-1)*lnFirmQuality
replace lnAQratio = lnAQratio * (1-SigmaF)/(1-SigmaU)
replace logfirmprod = logfirmprod * (1-SigmaF)/(1-SigmaU)
replace puremarketingeffect =(SigmaF-1)*puremarketingeffect
replace product_quality_upgrading = (SigmaF-1)*product_quality_upgrading
replace puremarketingeffect1 =(SigmaF-1)*puremarketingeffect1
replace product_quality_upgrading1 = (SigmaF-1)*product_quality_upgrading1
replace puremarketingeffect2 =(SigmaF-1)*puremarketingeffect2
replace product_quality_upgrading2= (SigmaF-1)*product_quality_upgrading2

* generate the time differenced variable of interest (t=2011Q4, t-1=2004Q4)
gen double d_logtotalsales = d.logtotalsales 
gen double d_lnFQ = d.lnFirmQuality 
gen double d_lnAQR = d.lnAQratio 
gen double d_lnMft = d.lnmftterm 
gen double d_lnfirmprod = d.logfirmprod 
gen double d_lnGeomeanAut = d.lnGeomeanAut 
gen double d_puremarketingeffect=puremarketingeffect 
gen double d_product_quality_upgrading=product_quality_upgrading 
gen double d_puremarketingeffect1=puremarketingeffect1 
gen double d_product_quality_upgrading1=product_quality_upgrading1 
gen double d_puremarketingeffect2=puremarketingeffect2 
gen double d_product_quality_upgrading2=product_quality_upgrading2 

save vardecompdataChile.dta,replace
*save decomp_data_whole_sample_v3_diffAvg_v5_large.dta,replace
keep if time ==2
* generate the average of the time differenced variables
foreach X in d_logtotalsales d_lnFQ d_lnAQR d_lnMft d_lnfirmprod d_lnGeomeanAut d_puremarketingeffect d_product_quality_upgrading d_puremarketingeffect1 d_product_quality_upgrading1 d_puremarketingeffect2 d_product_quality_upgrading2{
    bys time hs2: egen double a`X'=mean(`X')
}
* generate the k-differenced time differenced variables (time differenced firm level variable minus the product group average of the time differenced firm level variable)
foreach X in d_logtotalsales d_lnFQ d_lnAQR d_lnMft d_lnfirmprod d_lnGeomeanAut d_puremarketingeffect d_product_quality_upgrading d_puremarketingeffect1 d_product_quality_upgrading1 d_puremarketingeffect2 d_product_quality_upgrading2{
    gen double d_`X'=`X'-a`X'
}
foreach X in d_d_lnFQ  d_d_lnAQR  d_d_lnMft  d_d_lnfirmprod  d_d_lnGeomeanAut  d_d_product_quality_upgrading2{
    reg `X' d_d_logtotalsales
}
save vardecompdataChile.dta,replace
*save decomp_data_whole_sample_v3_diffAvg2_v5_large.dta,replace
* 
* run the regressions
foreach X in d_d_lnFQ  d_d_lnAQR  d_d_lnMft  d_d_lnfirmprod  d_d_lnGeomeanAut  d_d_product_quality_upgrading2{
    reg `X' d_d_logtotalsales
}
