version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear 
set more off
cd "${TERMINAL}/Chile/"

* X Section
use CrossSectionDecomposition.dta, replace

foreach XX in "1Firm_Appeal lnFirmQuality" "5Cost_Dispersion lnAQratio" "4Markup lnmftterm" "2Product_Scope logfirmprod" "3Average_MC lnGeomeanAut" {
		local X: word 2 of `XX'
		local Xnice: word 1 of `XX'
		
		qui reg d`X' dlogtotalsales
		gen coef_xs`Xnice'=_b[dlogtotalsales]
		}
	
collapse (mean) coef* 

gen id=_n
reshape long coef_xs, i(id) j(component) string

tempfile temp
save `temp'

* Growth
use vardecompdataChile.dta,clear
*save decomp_data_whole_sample_v3_diffAvg_v5_large.dta,replace
keep if time ==2

* 
* run the regressions
foreach XX in "1Firm_Appeal d_d_lnFQ"  "5Cost_Dispersion d_d_lnAQR"  "4Markup d_d_lnMft"  "2Product_Scope d_d_lnfirmprod"  "3Average_MC d_d_lnGeomeanAut"  "6Upgrading d_d_product_quality_upgrading2" {
	local X: word 2 of `XX'
	local Xnice: word 1 of `XX'
	reg `X' d_d_logtotalsales
	gen coef_growth`Xnice'=_b[d_d_logtotalsales]
}


collapse (mean) coef* 
gen id = _n
reshape long coef_growth, i(id) j(component) string

merge 1:1 _n using `temp', nogen

save chile_vd_table, replace
*/
use chile_vd_table, clear

drop id
gen bin = _n
replace component = regexr(component,"_"," ")
replace component = substr(component,2,.)
drop if component=="Upgrading"
labmask bin, values(component)
order bin coef_xs coef_growth
la var bin "\multicolumn{1}{c}{Component}"

local v0: var la bin
local v1 "Percentage Contribution in Cross-Section"
local v2 "Percentage Contribution in Growth"


local K = 0
foreach v in coef_xs coef_growth {
	local ++K
	replace `v' = `v'*100
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	di "`v`K''"
	}

local dec_list "2 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"


cd ${TERMINAL}/results/tables
tabout bin using S3_var_decomp_chile_Scol.tex, c(mean coef_xs mean coef_growth) ///
	h2(`v0'&`v1'&`v2'\\) h3(nil) ///
	replace sum ptotal(none) f(`dec_list') ///
	style(tex) bt topf(top_Scol.tex) botf(bot_chile_vd_Scol.tex) ///
	botstr(\emph{MC} is marginal cost |chile:decomptable) ///
	topstr(Firm Sales Decomposition Using Chilean Trade Transactions Data|0.9\textwidth|`col_format')
	
	
! perl -i -pe 's/\\&/\&/g' S3_var_decomp_chile_Scol.tex
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' S3_var_decomp_chile_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' S3_var_decomp_chile_Scol.tex
! perl -i -pe 's{(\)\K|\G)\&([\d\.]+)}{&(\2)}g' S3_var_decomp_chile_Scol.tex
! perl -i -pe 'undef $/; s/(\\\\)\n.*\(SE\)/\1*\n/g' S3_var_decomp_chile_Scol.tex

forval i=1/`K' {
	! perl -i -pe 's/`v`i''/{\\parbox{\\linewidth}{\\centering `v`i''}}/g' S3_var_decomp_chile_Scol.tex
	}
	

! head -50 S3_var_decomp_chile_Scol.tex

