global TERMINAL "/mnt/data0/work/MPF_FINAL"
set type double


clear
set more off
cd ${TERMINAL}/data/

** use the dataset that contains prices, price indices etc. and merge in the estimated SigmaU, SigmaF, delta (Omega)
use NestedMPFPriceIndexRedo_v3.dta,clear
sort product_group_code
merge m:1 product_group_code using "${TERMINAL}/results/NewGMMresultsV2_test.dta", update replace
drop if _merge !=3
drop _merge
* 
count if sigf_SE == .
count if sigf_SE == 0
count if sigf >= sigu
count if sigu <= 1
count if sigf <=1

** generate the model variables by using observables and the elasticity estimates 
rename sigu SigmaU
rename sigf SigmaF
rename omega Omega


drop SigmaU
drop SigmaF

forvalues i = 4(1)40 {
forvalues k = 4(1)`i' {

cd ${TERMINAL}/data/
use NestedMPFPriceIndexRedo_v3.dta,clear
sort product_group_code
merge m:1 product_group_code using "${TERMINAL}/results/NewGMMresultsV2_test", update replace
drop if _merge !=3
drop _merge
* 
count if sigf_SE == .
count if sigf_SE == 0
count if sigf >= sigu
count if sigu <= 1
count if sigf <=1

** generate the model variables by using observables and the elasticity estimates 
rename sigu SigmaU
rename sigf SigmaF
rename omega Omega

drop SigmaU
drop SigmaF

gen double SigmaU = (`i'/2) + 0.5
gen double SigmaF = (`k'/2) 

* perceived elasticity 
gen double perceivedelasticity = SigmaF - (SigmaF-1)*sharefirmgroup

* upc markup 
gen double mft = perceivedelasticity/(perceivedelasticity-1)

* marginal cost 
gen double aut = price/mft

* cost shifter 
gen double autshifter = aut/((1+omega)*(quantity^omega))

* markup 
gen double markup = (price - aut)/aut

* firm price elasticity 
gen double ownpriceelasticity= (SigmaF-1)*sharefirmgroup*shareprodfirm +(SigmaU-SigmaF)*shareprodfirm -SigmaU

* cannibalization 
gen double cannibalization= -(SigmaU-SigmaF)/(SigmaU-1) - ((SigmaF-1)/(SigmaU-1))*sharefirmgroup
gen double cannibalfirstterm = -(SigmaU-SigmaF)/(SigmaU-1)
*bys panel_year quarter product_group_code firmid: egen double numbprodfirm = count(value)
gen double cannibalizationelasticity= -((SigmaU-SigmaF)/(SigmaU-1) - ((SigmaF-1)/(SigmaU-1))*sharefirmgroup)

* upc quality 
bys panel_year quarter product_group_code firmid: egen double meanshare = mean(lnshareprodfirm)
gen double geomeanshare = exp(meanshare)
by panel_year quarter product_group_code firmid: egen double meanprice = mean(lnprice)
gen double geomeanprice = exp(meanprice)
gen double upcqualityt = (price/geomeanprice)*((shareprodfirm/geomeanshare)^(1/(SigmaU-1))) 

* firm price index 
gen double relativeshare = shareprodfirm/geomeanshare
bys panel_year quarter product_group_code firmid: egen double relsharesum = sum(relativeshare)
gen double firmpriceindex = (relsharesum ^ (1/(1-SigmaU)))*geomeanprice
gen double lnfirmpriceindex = ln(firmpriceindex)

* save firm level variables 
sort product_group_code
save GridSearchMarginalCosts_v2.dta, replace
collapse (firstnm) lnsharefirmgroup lnfirmpriceindex firmpriceindex sharefirmgroup SigmaU SigmaF perceivedelasticity cannibalization cannibalfirstterm cannibalizationelasticity, by(panel_year quarter product_group_code firmid) fast

* compute for each product group the geometric mean of firm share and price 
bys panel_year quarter product_group_code: egen double meanpgshare = mean(lnsharefirmgroup)
gen double geomeanpgshare = exp(meanpgshare)
by panel_year quarter product_group_code: egen double meanpgprice = mean(lnfirmpriceindex)
gen double geomeanpgprice = exp(meanpgprice)

* firm quality 
gen double firmqualityt = (firmpriceindex/geomeanpgprice)*((sharefirmgroup/geomeanpgshare)^(1/(SigmaF-1)))
gen double relpf = (firmpriceindex/firmqualityt)^(1-SigmaF)

* product group price index  
bys panel_year quarter product_group_code: egen double relsum = sum(relpf)
gen double grouppriceindex = relsum^(1/(1-SigmaF))
*  
sort panel_year quarter product_group_code firmid
save GridSearchFirmQuality_v2.dta, replace

* merge firm level and product group level variables together 
use GridSearchMarginalCosts_v2.dta, clear
sort panel_year quarter product_group_code firmid
merge panel_year quarter product_group_code firmid using GridSearchFirmQuality_v2.dta
drop if _merge !=3
drop _merge

* clean 
drop if SigmaU == .

* take log
gen double lnupcmc = ln(aut)
gen double lnmft = ln(mft)
gen double lnmarkup = ln(markup)
gen double lnupcquality = ln(upcqualityt)
gen double lnfirmquality = ln(firmqualityt)

* compute the profit for each UPC 
gen double upcprofit = ((((1+omega)*mft)-1)/((1+omega)*mft))*[(firmqualityt^(SigmaF-1))*(upcqualityt^(SigmaU-1))*(firmpriceindex^(SigmaU-SigmaF))*(price^(1-SigmaU))*groupsalestotal*(grouppriceindex^(SigmaF-1))]

* sort and set the post estimation data 
gsort panel_year quarter product_group_code firmid upcprofit
* 
by panel_year quarter product_group_code firmid: gen double lowestprofit = 1 if _n == 1
gen double lpv = upcprofit*lowestprofit
by panel_year quarter product_group_code firmid: egen double lowestprofitvalue = sum(lpv)
by panel_year quarter product_group_code firmid: egen double totalvariablefirmprofit = sum(upcprofit)
sort firmid
egen double firmlist = group(firmid)
*
save GridSearchFullPostestimation_v2.dta, replace

use GridSearchFullPostestimation_v2.dta, clear
*
* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001

*
* set the directory where results are saved 
cd ${TERMINAL}/results/reg_output/geometric_mean
*
* drop missing values 
drop if firmqualityt == . | upcqualityt == . | aut == .| SigmaU == . | SigmaF == . | value == . | mft == . | grouppriceindex == .
*
* define variables 
bys product_group_code firmid panel_year quarter: egen firmproduc = count(value)
bys panel_year quarter product_group_code firmid: egen totalfirmsales = total(value)
bys panel_year quarter product_group_code: egen productgroupsales = total(value)
gen firmshare2=totalfirmsales/productgroupsales
bys product_group_code firmid panel_year quarter: egen geomeanAut = gmean(aut)
gen double AQratio = ((aut/geomeanAut)/upcqualityt)^(1-SigmaU)
*
** define cutoff for small firms: firms with less than 0.5% share and drop them 
*drop if firmshare2<0.005
*
* take logs 
gen double loggeomeanaut = log(geomeanAut)
gen double logfirmprod = log(firmproduc)
gen double logtotalsales = log(totalfirmsales)
gen double lnFirmQuality = ln(firmqualityt)
* 
collapse (firstnm) size1_units (mean) loggeomeanaut firmproduc logfirmprod logtotalsales firmqualityt mft SigmaF SigmaU (sum) AQratio, by(panel_year quarter product_group_code firmid) fast
replace AQratio = AQratio/firmproduc
*
sort panel_year quarter
egen time=group(panel_year quarter)
sort product_group_code firmid
egen pf=group(product_group_code firmid)

xtset pf time
*
rename loggeomeanaut lnGeomeanAut
gen double lnFirmQuality = ln(firmqualityt)
gen double lnAQratio = ln(AQratio) 
*
cd ${TERMINAL}/results/reg_output/geometric_mean
la var logfirmprod "$\ln\left(\#\mathrm{UPC}_{ft}\right)$"
la var lnFirmQuality "$\ln\varphi_{ft}$"
la var lnAQratio "$\ln\left[\sum_u\left(\frac{a_{ut}}{\varphi_{ut}}\right)^{1-\sigma_u}\right]$"
la var logtotalsales "$\ln s_{ft}$"

* NEW SET UP TO SUM TO ONE
gen double lnmftterm = ln(mft)*(1-SigmaF)
replace lnGeomeanAut = (1-SigmaF)*lnGeomeanAut
replace lnFirmQuality = (SigmaF-1)*lnFirmQuality
replace lnAQratio = lnAQratio * (1-SigmaF)/(1-SigmaU)
replace logfirmprod = logfirmprod * (1-SigmaF)/(1-SigmaU)

la var lnmftterm "$(1-\sigma_f)\ln m_{ft}$"

drop if lnFirmQuality == . 
sort product_group_code
egen pglist=group(product_group_code)
* compute the product group averages across firms 
foreach X in logtotalsales lnFirmQuality lnAQratio lnmftterm logfirmprod lnGeomeanAut{
    bys panel_year quarter product_group_code: egen double a`X'=mean(`X')
}
* compute the double differenced variables 
foreach X in logtotalsales lnFirmQuality lnAQratio lnmftterm logfirmprod lnGeomeanAut{
    gen double d`X'=`X'-a`X'
}
* run the variance decompistion regressions 
*foreach X in logtotalsales lnFirmQuality lnAQratio lnmftterm logfirmprod lnGeomeanAut{
*    reg d`X' dlogtotalsales
*}

 reg dlnFirmQuality dlogtotalsales
 local fq = _b[dlogtotalsales]
 
 reg dlnAQratio dlogtotalsales
 local aq = _b[dlogtotalsales]
 
 reg dlnmftterm dlogtotalsales
 local mf = _b[dlogtotalsales]
 
 reg dlogfirmprod dlogtotalsales
 local fp = _b[dlogtotalsales]
 
 reg dlnGeomeanAut dlogtotalsales
 local gm = _b[dlogtotalsales]

drop _all
set obs 1
gen double SigmaU = `i' + 0.5
gen double SigmaF = `k' 
gen double FQterm = `fq'
gen double AQterm = `aq'
gen double Mftterm = `mf'
gen double Firmprodterm = `fp'
gen double GmeanAutterm = `gm'

if `i' > 4 | `k' > 4 {
append using GridSearchDecomposition_v2.dta
}
save GridSearchDecomposition_v2.dta,replace
}
}
