version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

set more off 
cd ${TERMINAL}/data
insheet using lit_est.csv, clear

merge m:1 product_group_code using ${TERMINAL}/results/NewGMMresultsV2_test, ///
	keep(3) nogen keepus(sigf sigu)

drop if regexm(name,"(G)")
replace lit_est = -lit_est
keep name lit_est sigf source

local K = 0
foreach v of varlist lit_est sigf {
	local ++K
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	di "`int_`K''"
	}



local dec_list "2 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"

la var name "Product Category"
la var lit_est "Prior Literature"
la var sigf "$\sigma_F$"
la var source "Source"

replace name = name+"GG" if source=="Gordon"
replace name = name+"PL" if source!="Gordon"

local v0 : var la name
local v1 : var la sigf
local v2 : var la lit_est
local v3 : var la name

local NN = _N+1
set obs `NN'
replace name = "ZZAverageAA" in `NN'
qui sum lit_est
replace lit_est = `r(mean)' in `NN'
qui sum sigf
replace sigf = `r(mean)' in `NN'


cd ${TERMINAL}/results/tables
tabout name using S4_lit_comps.tex, h2(nil) h3(`v0'&`v1'&`v2'\\) ///
	c(mean sigf mean lit_est) ///
	replace sum ptotal(none) f(`dec_list') style(tex) bt  ///
	topf(top_lit.tex) botf(bot_Scol.tex) botstr(\sym{*} taken from average of prior studies in Gordon [2013] Web Appendix. \sym{\dagger} taken from Gordon [2013]. |tab:lit_comps) ///
	topstr(Comparison of Elasticities to Literature|0.66\textwidth|`col_format') ///
	/*
! perl -i -pe 's/\\&/\&/g' S4_lit_comps.tex
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' S4_lit_comps.tex
! perl -i -pe 's/\#\]\}\n//g' S4_lit_comps.tex
*! perl -i -pe 's/.\]\}\n//g' S4_lit_comps.tex
*! perl -i -pe 's/X\[c\]\{S\[table-format=\d\.\n/Y/g' S4_lit_comps.tex


! head -15 S4_lit_comps.tex 
forval i=1/`K' {
	local w`i' "`v`i''"
	local w1 "\\\$\\sigma_F\\\$"
	local ww`i' "`w`i''"
	local ww1 "\\\$\\sigma_F\\\$"
	di "`ww`i''"
	di "{\\parbox{\\linewidth}{\\centering `ww`i''}}"
	! perl -i -pe 's/&`w`i''/&{\\parbox{\\linewidth}{\\centering `ww`i''}}/g' S4_lit_comps.tex
	}
	*/

! perl -i -pe 's/GG(.*?\d{2}) \\/\1\\sym{\\dagger}\\/g' S4_lit_comps.tex
! perl -i -pe 's/PL(.*?\d{2}) \\/\1\\sym{*}\\/g' S4_lit_comps.tex
! perl -i -pe 's/AA(.*?\d{2}) \\/\1\\phantom{\\sym{*}}\\/g' S4_lit_comps.tex
! perl -i -pe 'undef $/; s/(\[htbp\]\n)/\1\\def\\sym#1{\\ifmmode^{#1}\\else\\(^{#1}\\)\\fi}\n/g' S4_lit_comps.tex 
! perl -i -pe 's/ZZAverage/\\midrule\nAverage/g' S4_lit_comps.tex
*! perl -i -pe 's{(\)\K|\G)\&([\d\.]+)}{&(\2)}g' S4_lit_comps.tex 
*! perl -i -pe 'undef $/; s/(\\\\)\n.*\(SE\)/\1*\n/g' S4_lit_comps.tex 
*! perl -i -pe 's/([\d\-\.]+)([\s\&])/\\$\1\\$\2/g' S4_lit_comps.tex 
*! perl -i -pe 's/\(([\d\-\.]+)\)/\\$(\1)\\$ /g' S4_lit_comps.tex 

! head -30 S4_lit_comps.tex 

