version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear all
set more off
set type double
cd ${TERMINAL}/data

use RedoFullPostestimationV2_v5.dta, clear
*
* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001


bys product_group_code: egen nfirms = nvals(firmid)
collapse (mean) nfirms (sum) groupsales=value (firstnm) product_group_descr, by(product_group_code)
egen totalsales = total(groupsales)
gen sharegroupaggAll = groupsales/totalsales

keep product_group_descr sharegroupaggAll nfirms
la var product_group_descr "Product Group"
la var sharegroupaggAll "Sales Share"
la var nfirms "No.\ Firms"
sort product_group_descr
order product_group_descr sharegroupaggAll nfirms
save qje/PG_table, replace
*/
use qje/PG_table, clear
cd ../results/tables
rename product_group_descr pg
replace pg = proper(pg)
replace pg = "Tobacco And Accessories " if pg=="Tobacco & Accessories"

local K = 0
foreach v in sharegroupaggAll nfirms {
	local ++K
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	di "`int_`K''"
	}



local dec_list "3 0"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"


la var pg "Product Group"
la var sharegroupaggAll "Sales Share"
la var nfirms "No.\ Firms"

local v0 : var la pg
local v1 : var la sharegroupaggAll
local v2 : var la nfirms

tabout pg using S6_pgroups_descr.tex, c(mean sharegroupaggAll mean nfirms) h2(nil) ///
	h3(`v0'&`v1'&`v2'\\) replace sum ptotal(none) f(`dec_list') ///
	style(tex) bt topf(top_Scol_long.tex) botf(bot_Scol_long.tex) ///
	topstr(Product Groups|0.8\textwidth|`col_format') ///
	botstr(\,|tab:prodgroupdescr)
	



! perl -i -pe 's/\\&/\&/g' S6_pgroups_descr.tex
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' S6_pgroups_descr.tex
! perl -i -pe 's/\#\]\}\n//g' S6_pgroups_descr.tex




local w1 "`v1'"
local w2 "No\.\\ Firms"


local ww1 "`w1'"
local ww2 "`w2'"




forval i=1/`K' {
	! perl -i -pe 's/`w`i''/{\\parbox{\\linewidth}{\\centering `ww`i''}}/g' S6_pgroups_descr.tex
	}

! head -20 S6_pgroups_descr.tex 
