version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear all
set more off
set type double

cd ${TERMINAL}/data
use RedoFullPostestimationV2_v5.dta, clear

*
* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001


bys product_group_code: egen nfirms = nvals(firmid)
collapse (mean) nfirms (sum) groupsales=value (firstnm) product_group_descr, by(product_group_code)
egen totalsales = total(groupsales)
gen sharegroupaggAll = groupsales/totalsales

keep product_group_code product_group_descr sharegroupaggAll nfirms
la var product_group_descr "Product Group"
la var sharegroupaggAll "Sales Share"
la var nfirms "No.\ Firms"
sort product_group_descr
order product_group_code product_group_descr sharegroupaggAll nfirms
save qje/PG_table, replace

cd ${TERMINAL}/results/reg_output/geometric_mean/qje


use VD_PG_regs_lnFirmQuality,clear

keep if parmseq==1
gen e_type=1
local N=_N
expand 2
local N1 = `N'+1
local N2 = _N
*replace estimate = stderr[_n-`N'] in `N1'/`N2'
replace estimate = stderr in `N1'/`N2'
replace e_type = 2 if _n>`N'

keep product_group_code estimate e_type parmseq
tempfile temp
save `temp'


use VD_PG_regs_logfirmprod.dta,clear

keep if parmseq==1
gen e_type=1
local N=_N
expand 2
local N1 = `N'+1
local N2 = _N
*replace estimate = stderr[_n-`N'] in `N1'/`N2'
replace estimate = stderr in `N1'/`N2'
replace e_type = 2 if _n>`N'

replace parmseq = 2
keep product_group_code estimate e_type parmseq
tempfile temp2
save `temp2'

use VD_PG_regs_resid,clear

keep if parmseq==1
gen e_type=1
local N=_N
expand 2
local N1 = `N'+1
local N2 = _N
*replace estimate = stderr[_n-`N'] in `N1'/`N2'
replace estimate = stderr in `N1'/`N2'
replace e_type = 2 if _n>`N'

replace parmseq = 3
keep product_group_code estimate e_type parmseq

append using `temp'
append using `temp2'
reshape wide estimate,i(product_group_code e_type) j(parmseq)


cd ${TERMINAL}/results/
merge m:1 product_group_code using NewGMMresultsV2_test, ///
	keep(3) nogen keepus(sigf sigu sigf_SE sigu_SE)
replace sigf = sigf_SE if e_type==2
replace sigu = sigu_SE if e_type==2
drop sigf_SE sigu_SE

merge m:1 product_group_code using ../data/qje/PG_table, ///
	keepus(product_group_descr sharegroupaggAll) keep(3) nogen
	
replace product_group_descr = "MEDICATIONS/REMEDIES/HEALTH AIDS" if product_group_code==6012
replace product_group_descr = "PERSONAL SOAP AND BATH ADDITIVES" if product_group_code==4508

rename product_group_descr pg
replace pg = proper(pg)
replace pg = "Tobacco And Accessories " if pg=="Tobacco & Accessories"
replace pg = pg+"(SE)" if e_type==2

bys e_type: egen pg_rank = rank(share), field
keep if pg_rank<=10

cd ${TERMINAL}/results/reg_output/geometric_mean/qje

local K = 0
foreach v of varlist estimate* sigf sigu {
	local ++K
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	di "`int_`K''"
	}



local dec_list "3 3 3 2 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"


la var pg_rank "Product Group"
la var estimate1 "Firm Appeal"
la var estimate2 "Scope"
la var estimate3 "Residual"
la var sigf "$\sigma_F$"
la var sigu "$\sigma_U$"

local v0 : var la pg
local v1 : var la estimate1
local v2 : var la estimate2
local v3 : var la estimate3
local v4 : var la sigf
local v5 : var la sigu


replace pg_rank = pg_rank+0.5 if e_type==2
replace pg_rank = pg_rank*2
labmask pg_rank, values(pg)

cd ${TERMINAL}/results/tables
tabout pg_rank using S5_PGVD_table_top10.tex , ///
	c(mean estimate1 mean estimate2 mean estimate3 mean sigf mean sigu) /// 
	h2(nil) h3(`v0'&`v1'&`v2'&`v3'&`v4'&`v5'\\) replace sum ptotal(none) ///
	f(`dec_list') style(tex) bt topf(top_Scol.tex) ///
	botf(bot_Scol.tex) botstr(Rows in rank order. Standard errors in parentheses. |tab:decomp10largest) ///
	topstr(Variance Decomposition (Top 10 Product Groups)|\textwidth|`col_format') ///

! perl -i -pe 's/\\&/\&/g' S5_PGVD_table_top10.tex  
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' S5_PGVD_table_top10.tex 
! perl -i -pe 's/\#\]\}\n//g' S5_PGVD_table_top10.tex
*! perl -i -pe 's/.\]\}\n//g' S5_PGVD_table_top10.tex 
*! perl -i -pe 's/X\[c\]\{S\[table-format=\d\.\n/Y/g' S5_PGVD_table_top10.tex 


local w1 "`v1'"
local w2 "`v2'"
local w3 "`v3'"
local w4 "\\\$\\sigma_U\\\$"
local w5 "\\\$\\sigma_F\\\$"


local ww1 "`w1'"
local ww2 "`w2'"
local ww3 "`w3'"
local ww4 "\\\$\\sigma_U\\\$ "
local ww5 "\\\$\\sigma_F\\\$ "

forval i=1/`K' {
	! perl -i -pe 's/`w`i''/{\\parbox{\\linewidth}{\\centering `ww`i''}}/g' S5_PGVD_table_top10.tex 
	}
	*/

! perl -i -pe 's{(\)\K|\G)\&([\d\.]+)}{&(\2)}g' S5_PGVD_table_top10.tex 
! perl -i -pe 'undef $/; s/(\\\\)\n.*\(SE\)/\1*\n/g' S5_PGVD_table_top10.tex 
*! perl -i -pe 's/([\d\-\.]+)([\s\&])/\\$\1\\$\2/g' S5_PGVD_table_top10.tex 
*! perl -i -pe 's/\(([\d\-\.]+)\)/\\$(\1)\\$ /g' S5_PGVD_table_top10.tex 
! head -20 S5_PGVD_table_top10.tex 
