version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear all
set more off 
*version 9.2

********************************************************
* KILTS Data
* Aggregate to natl-quarterly from HH-city-week
* Combine datasets (deleting intermediate steps)
*********************************************************

*cap prog drop KILTS_agg
*prog define KILTS_agg

	clear
	*set niceness 5
	set max_memory 256g
	set segmentsize 512m
	cd ${TERMINAL}/data/KILTS/
	

	* Retrieve KILTS data on demographic, geographic, and product ownership of panelists
	forvalues j =4(1)11{
	
		if `j' < 10 {
		use "${TERMINAL}/data/KILTS/nielsen_extracts/HMS/200`j'/Annual_Files/panelists_200`j'.dta", clear
		}

		if `j' >= 10 {
		use "${TERMINAL}/data/KILTS/nielsen_extracts/HMS/20`j'/Annual_Files/panelists_20`j'.dta", clear
		}

		keep household_code panel_year projection_factor projection_factor_magnet scantrack_market_code scantrack_market_descr

		if `j' < 10 {
		save HouseholdScantrack200`j'.dta, replace
		}
		
		if `j' >= 10 {
		save HouseholdScantrack20`j'.dta, replace
		}
		
		}



	forvalues i = 4(1)11 {
		* Use KILTS data on shopping trips (date, store, total spending) and purchases (of specific products)
		
		if `i' < 10 {
		use "${TERMINAL}/data/KILTS/nielsen_extracts/HMS/200`i'/Annual_Files/trips_200`i'.dta", clear
		merge 1:m trip_code_uc using "${TERMINAL}/data/KILTS/nielsen_extracts/HMS/200`i'/Annual_Files/purchases_200`i'.dta"
		*drop if _merge != 3
		drop _merge
		* And merge in the demographic/geographic data
		merge m:1 household_code using HouseholdScantrack200`i'.dta
		drop _merge
		erase HouseholdScantrack200`i'.dta
		}
		
		if `i' >= 10 {
		use "${TERMINAL}/data/KILTS/nielsen_extracts/HMS/20`i'/Annual_Files/trips_20`i'.dta", clear
		merge 1:m trip_code_uc using "${TERMINAL}/data/KILTS/nielsen_extracts/HMS/20`i'/Annual_Files/purchases_20`i'.dta"
		*drop if _merge != 3
		drop _merge
		* And merge in the demographic/geographic data
		merge m:1 household_code using HouseholdScantrack20`i'.dta
		drop _merge
		erase HouseholdScantrack20`i'.dta
		}
		
		
		compress

		gen double value = total_price_paid - coupon_value
		
		* Drop bad observations
		drop if value<=0
		drop if value == .
		
		*gen double total_quantity = quantity*total_uc
		drop if quantity <=0
		drop if quantity == .

		gen double price = value/quantity
		drop if price <= 0

		*sum quantity,d

		* Use Coupon Inclusive Price *
		*gen double value = total_price_paid
		

	* Create quarter variables: = 1 (Jan-Mar), = 2 (Apr-June), = 3 (July-Sept), = 4 (Oct-Dec)
		*gen double m = month(purchase_date)
		gen m = substr(purchase_date,6,2)
		destring m, replace
		gen double quarter = .
		replace quarter = 1 if m <=3
		replace quarter = 2 if m>3 & m<=6
		replace quarter = 3 if m>6 & m<=9
		replace quarter = 4 if m>9 & m<=12
		
	**Define medians by scantrack and quarter **
		*sum price,d

		
		bys upc upc_ver_uc scantrack_market_code panel_year quarter: egen double medprice = median(price)

		by upc upc_ver_uc scantrack_market_code panel_year quarter: egen double medquant = median(quantity)

	
		
		* Filtering extreme quantities and prices *
		drop if price > (3)*medprice
		drop if price < (1/3)*medprice
		*drop if price < 0.25
		*drop if price > 25
		
		drop if quantity > 24*medquant
		*drop if total_quantity > 6*medquant
		*drop if total_quantity > 6
		

		
		* Create variables from projections
		gen double rawb = 1 
		gen double buyers = rawb*projection_factor
		replace quantity = quantity*projection_factor
		replace value = value*projection_factor

	
	

		collapse (sum) quantity value rawb buyers projection_factor, by(panel_year quarter upc upc_ver_uc) fast

		merge m:1 upc upc_ver_uc using "${TERMINAL}/data/KILTS/nielsen_extracts/HMS/Master_Files/Latest/products.dta"

		*drop if _merge !=3
		drop _merge
		gen double price = value/quantity
		
		if `i' < 10 {
		save QuarterlyMktScantrack200`i'.dta, replace
		}
		
		if `i' >= 10 {
		save QuarterlyMktScantrack20`i'.dta, replace
		}
		
		}

	use QuarterlyMktScantrack2004.dta, clear
	append using QuarterlyMktScantrack2005.dta
	append using QuarterlyMktScantrack2006.dta
	append using QuarterlyMktScantrack2007.dta
	append using QuarterlyMktScantrack2008.dta
	append using QuarterlyMktScantrack2009.dta
	append using QuarterlyMktScantrack2010.dta
	append using QuarterlyMktScantrack2011.dta
	
	save KiltsNationalQuarterly.dta, replace
	
	erase QuarterlyMktScantrack2004.dta
	erase QuarterlyMktScantrack2005.dta
	erase QuarterlyMktScantrack2006.dta
	erase QuarterlyMktScantrack2007.dta
	erase QuarterlyMktScantrack2008.dta
	erase QuarterlyMktScantrack2009.dta
	erase QuarterlyMktScantrack2010.dta
	erase QuarterlyMktScantrack2011.dta
