version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

* ***************************************
* This code estimates the elasticity parameter SigmaU 
* ***************************************
clear
set more off
cd "${TERMINAL}/data"
use PreGMM1V2_v3.dta, clear

** trim the double differenced variables 
sum ddupcprice,d
local umin = `r(p1)'
local umax = `r(p99)'
replace ddupcprice = . if ddupcprice <= `umin'
replace ddupcprice = . if ddupcprice >= `umax'
*
sum ddfirmprodshare,d
local fmin = `r(p1)'
local fmax = `r(p99)'
replace ddfirmprodshare = . if ddfirmprodshare <= `fmin'
replace ddfirmprodshare = . if ddfirmprodshare >= `fmax'
drop if ddupcprice == .
drop if ddfirmprodshare == .

** generate variables used in the estimation 
* generate the squate of the double differenced variables 
gen double y2 = ddupcprice*ddupcprice
gen double z1 = ddupcprice*ddfirmprodshare
gen double z2 = ddfirmprodshare*ddfirmprodshare
* generate the product group - upc average of the squared - double differenced variables 
bys product_group_code upc: egen double weight_bar = mean(weight)
by product_group_code upc: egen double y2_bar = mean(y2)	
by product_group_code upc: egen double z1_bar = mean(z1)	
by product_group_code upc: egen double z2_bar = mean(z2)
bys product_group_code upc: egen double b1 = mean(bias1)

** clean: drop upcs with less than 10 or 20 observations in a given product group 
bys product_group_code upc: egen double t2 = count(y2)
sum t2,d
drop if t2 < 10
drop if t2 < 20 & product_group_code != 2004 & product_group_code != 5505 & product_group_code != 5509 & product_group_code != 5517 & product_group_code != 6005 & product_group_code != 6006 & product_group_code != 6007 & product_group_code != 6013

* generate the weighted mean of the squared - double differenced variables 
bys product_group_code: egen double sum_weight = total(weight_bar)
gen double weight_bar_other = weight_bar/sum_weight
foreach var in y2_bar z1_bar z2_bar {
		replace `var' = `var'*weight_bar_other
}
collapse (mean) y2_bar z1_bar z2_bar t2 weight_bar_other b1 ddfirmprodshare ddupcprice, by(product_group_code upc) fast

* drop product group with less than 3 observations
bys product_group_code: egen countobs2 = count(t2)
drop if countobs2 < 3

* save the dataset used for the estimation of SigmaU
sort product_group_code
egen double pglist = group(product_group_code)
save estimationdataTEST.dta,replace

* estimate SigmaU using the method proposed by Broda and Weinstein (2006) and a nonlinear solver 
sum pglist, meanonly
local max = `r(max)'

forvalues i = 1/`max' {
forvalues k = 1/5 {
use estimationdataTEST.dta,clear
keep if pglist == `i'
local pg = product_group_code
local u = `k'+0.001
local w = (`k')/4
capture noisily: nl (y2_bar ={c1=0}*b1+((({sigu=`u'}-2)*({omega})-1)/((1+{omega})*({sigu}-1)))*z1_bar+({omega=`w'}/((1+{omega})*({sigu}-1)))*z2_bar), eps(1e-10) vce(robust) hasconstant(c1)
local rc = _rc

if `rc' == 0 {
capture: local sigu_est = _b[sigu: _cons] 
capture: local omega_est = _b[omega: _cons] 
capture: local sigu_se = _se[sigu: _cons] 
capture: local omega_se = _se[omega: _cons] 
capture: local ssr = e(rss) 
capture: local r2 = e(r2) 
capture: local obs = countobs2
}


drop _all
set obs 1
gen group = `pg'
if `rc' == 0 {
capture: gen double sigu = `sigu_est' 
capture: gen double omega = `omega_est' 
capture: gen double sigu_SE = `sigu_se' 
capture: gen double omega_SE = `omega_se' 
capture: gen double SSR = `ssr' 
capture: gen double r2 = `r2' 
capture: gen double obs = `obs' 
}

if `i' > 1 | `k' > 1{
	append using EstimationStaggeredConTEST.dta
	}
	save EstimationStaggeredConTEST.dta, replace
}
}

use EstimationStaggeredConTEST.dta, clear
* clean the estimation output 
drop if sigu < 0 | omega < 0
drop if sigu_SE == 0
drop if omega_SE == 0
sort group SSR
collapse (firstnm) sigu omega sigu_SE omega_SE SSR r2 obs, by(group) fast
rename group product_group_code
sort product_group_code
* save the SigmaU estimates 
save EstimationStaggeredConTEST2.dta, replace

