version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

* ***************************************
* This code estimates the elasticity parameter SigmaF and merges it together with the SigmaU and delta estimates. 
* ***************************************
clear
set more off
cd "${TERMINAL}/data"
use "${TERMINAL}/data/PreGMM2V2_v3.dta", clear

** Prepare double differenced variables for the estimation and drop missing values 
gen double ddgeomeanprice = lngeoprice- lag_lngeoprice - (lngeoprice_base-lag_lngeoprice_base)

* merge in the double differenced relative price, geometric mean of the relative price etc. 
sort product_group_code
merge product_group_code using EstimationStaggeredConTEST2.dta, keep(sigu omega)
tab _merge
drop if _merge !=3
drop _merge

* clean 
drop if ddSato == .
drop if ddrelativeshare ==.
drop if ddgeomeanprice == .
gen double ddpft = ddSato
drop if ddpft == .

* rename double differenced variables to the name used by the estimation routine. 
gen double yother = ddfirmshare
gen double x1other = ddpft
gen double x2other = ddgeomeanprice
gen double x3other = ddrelativeshare*(1/(1-sigu))

* trim extreme values 
sum ddfirmshare,d
local ddfmin = `r(p1)'
local ddfmax = `r(p99)'
drop if ddfirmshare < `ddfmin'
drop if ddfirmshare > `ddfmax'
sum ddSato,d
local ddsmin = `r(p1)'
local ddsmax = `r(p99)'
drop if ddSato < `ddsmin'
drop if ddSato > `ddsmax'

* drop product groups with small number of observations
bys product_group_code fm: egen double t = count(yother)
bys product_group_code: egen tsum = sum(t)
bys product_group_code: egen countobs = count(t)
drop if countobs < 2
sort product_group_code
egen double pglist = group(product_group_code)

* saved the dataset used in the estimation 
save estimationdata2sls_test.dta,replace

* estimate SigmaF by using the IV approach
use estimationdata2sls_test.dta, clear
*
sum pglist, meanonly
local max = `r(max)'
*
forvalues i = 1/`max' {
forvalues k = 1/1 {
use estimationdata2sls_test.dta,clear
keep if pglist == `i'
local pg = product_group_code
local obs = countobs
local sumt = tsum
local f = `k'+0.0001

xtset fm time

reg yother x1other, robust

capture noisily:ivreg2 yother (x1other = x3other), gmm2s robust endogtest(x1other) small first 

local rc = _rc

if `rc' == 0 {
capture: local sigf_est = (1-(_b[x1other]))

disp `sigf_est'

capture: local sigf_se = _se[x1other] 

disp `sigf_se'

capture: local ssr = e(rss) 
capture: local r2 = e(r2) 
}

drop _all
set obs 1
gen group = `pg'
if `rc' == 0 {
capture: gen double sigf = `sigf_est' 
capture: gen double sigf_SE = `sigf_se' 
capture: gen double SSR = `ssr' 
capture: gen double obs = `obs' 
capture: gen double timesum = `sumt' 
capture: gen double r2 = `r2'
}

if `i' > 1 | `k' >1 {
	append using FirmNew2slsV2_test.dta
	}
	save FirmNew2slsV2_test.dta, replace
	
}
}


use FirmNew2slsV2_test.dta, clear

rename group product_group_code
rename SSR SSR_2
rename obs obsother
rename r2 rn_2
sort product_group_code

* merge in the SigmaU and delta estimates 
merge product_group_code using EstimationStaggeredConTEST2.dta
tab _merge
drop _merge 
* drop missing values 
gen double ssrtest = SSR_2+SSR
drop if SSR == .
drop if sigf_SE == 0
drop if sigf == .
drop if sigu == .
gsort product_group_code ssrtest
collapse (firstnm) sigu sigf omega sigu_SE sigf_SE omega_SE ssrtest SSR SSR_2 obs obsother r2 rn_2, by(product_group_code)
sum sigf,d
* drop if the number of observations is less than 30
drop if obs < 30
* save results 
save "${TERMINAL}/results/NewGMMresultsV2_test.dta", replace
