version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

* ******************************
* This code puts together the estimation outcomes and produces the post estimation data
* (RedoFullPostestimationV2_v5.dta) that is used to produce the tables and graphs in the paper
* ******************************
clear
set more off
cd ${TERMINAL}/data/

** use the dataset that contains prices, price indices etc. and merge in the estimated SigmaU, SigmaF, delta (Omega)
use NestedMPFPriceIndexRedo_v3.dta,clear
sort product_group_code
merge m:1 product_group_code using "${TERMINAL}/results/NewGMMresultsV2_test.dta", update replace
drop if _merge !=3
drop _merge
* 
count if sigf_SE == .
count if sigf_SE == 0
count if sigf >= sigu
count if sigu <= 1
count if sigf <=1

** generate the model variables by using observables and the elasticity estimates 
rename sigu SigmaU
rename sigf SigmaF
rename omega Omega

* perceived elasticity 
gen double perceivedelasticity = SigmaF - (SigmaF-1)*sharefirmgroup

* upc markup 
gen double mft = perceivedelasticity/(perceivedelasticity-1)

* marginal cost 
gen double aut = price/mft

* cost shifter 
gen double autshifter = aut/((1+omega)*(quantity^omega))

* markup 
gen double markup = (price - aut)/aut

* firm price elasticity 
gen double ownpriceelasticity= (SigmaF-1)*sharefirmgroup*shareprodfirm +(SigmaU-SigmaF)*shareprodfirm -SigmaU

* cannibalization 
gen double cannibalization= -(SigmaU-SigmaF)/(SigmaU-1) - ((SigmaF-1)/(SigmaU-1))*sharefirmgroup
gen double cannibalfirstterm = -(SigmaU-SigmaF)/(SigmaU-1)
bys panel_year quarter product_group_code firmid: egen double numbprodfirm = count(value)
gen double cannibalizationelasticity= -((SigmaU-SigmaF)/(SigmaU-1) - ((SigmaF-1)/(SigmaU-1))*sharefirmgroup)

* upc quality 
bys panel_year quarter product_group_code firmid: egen double meanshare = mean(lnshareprodfirm)
gen double geomeanshare = exp(meanshare)
by panel_year quarter product_group_code firmid: egen double meanprice = mean(lnprice)
gen double geomeanprice = exp(meanprice)
gen double upcqualityt = (price/geomeanprice)*((shareprodfirm/geomeanshare)^(1/(SigmaU-1))) 

* firm price index 
gen double relativeshare = shareprodfirm/geomeanshare
bys panel_year quarter product_group_code firmid: egen double relsharesum = sum(relativeshare)
gen double firmpriceindex = (relsharesum ^ (1/(1-SigmaU)))*geomeanprice
gen double lnfirmpriceindex = ln(firmpriceindex)

* save firm level variables 
sort product_group_code
save RedoFullProductGroupMarginalCostsV2_v5.dta, replace
collapse (firstnm) lnsharefirmgroup lnfirmpriceindex firmpriceindex sharefirmgroup SigmaU SigmaF perceivedelasticity cannibalization cannibalfirstterm cannibalizationelasticity, by(panel_year quarter product_group_code firmid) fast

* compute for each product group the geometric mean of firm share and price 
bys panel_year quarter product_group_code: egen double meanpgshare = mean(lnsharefirmgroup)
gen double geomeanpgshare = exp(meanpgshare)
by panel_year quarter product_group_code: egen double meanpgprice = mean(lnfirmpriceindex)
gen double geomeanpgprice = exp(meanpgprice)

* firm quality 
gen double firmqualityt = (firmpriceindex/geomeanpgprice)*((sharefirmgroup/geomeanpgshare)^(1/(SigmaF-1)))
gen double relpf = (firmpriceindex/firmqualityt)^(1-SigmaF)

* product group price index  
bys panel_year quarter product_group_code: egen double relsum = sum(relpf)
gen double grouppriceindex = relsum^(1/(1-SigmaF))
*  
sort panel_year quarter product_group_code firmid
save RedoFullProductGroupFirmQualityV2_v5.dta, replace

* merge firm level and product group level variables together 
use RedoFullProductGroupMarginalCostsV2_v5.dta, clear
sort panel_year quarter product_group_code firmid
merge panel_year quarter product_group_code firmid using RedoFullProductGroupFirmQualityV2_v5.dta
drop if _merge !=3
drop _merge

* clean 
drop if SigmaU == .

* take log
gen double lnupcmc = ln(aut)
gen double lnmft = ln(mft)
gen double lnmarkup = ln(markup)
gen double lnupcquality = ln(upcqualityt)
gen double lnfirmquality = ln(firmqualityt)

* compute the profit for each UPC 
gen double upcprofit = ((((1+omega)*mft)-1)/((1+omega)*mft))*[(firmqualityt^(SigmaF-1))*(upcqualityt^(SigmaU-1))*(firmpriceindex^(SigmaU-SigmaF))*(price^(1-SigmaU))*groupsalestotal*(grouppriceindex^(SigmaF-1))]

* sort and set the post estimation data 
gsort panel_year quarter product_group_code firmid upcprofit
* 
by panel_year quarter product_group_code firmid: gen double lowestprofit = 1 if _n == 1
gen double lpv = upcprofit*lowestprofit
by panel_year quarter product_group_code firmid: egen double lowestprofitvalue = sum(lpv)
by panel_year quarter product_group_code firmid: egen double totalvariablefirmprofit = sum(upcprofit)
sort firmid
egen double firmlist = group(firmid)
*
save RedoFullPostestimationV2_v5.dta, replace



