version 12.1
global TERMINAL "/mnt/data0/work/MPF_FINAL"
set type double
set more off


cd ${TERMINAL}/results
use NewGMMresultsV2_test, clear
keep if product_group_code==1503 // carbonated bevs
keep sigu sigf
local sigf = sigf
local sigu = sigu
local e1 = (sigu-sigf)/(sigu-1)+(sigf-1)/(sigu-1)*0
local e2 = (sigu-sigf)/(sigu-1)+(sigf-1)/(sigu-1)*0.2
di `e1'
di `e2'

clear
set obs 1
gen bin = 1
gen e1 = `e1'
gen e2 = `e2'


la var bin ""
la def bin 1 "Cannibalization"
la val bin bin
local vv1 "Share = 0\%"
local vv2 "Share = 20\%"


cd ${TERMINAL}/results/tables/
tabout bin using SM14_can_carbBev.tex, c(mean e1 mean e2) h2(`vv0'&`vv1'&`vv2'\\) ///
replace sum ptotal(none) f(2 2) h3(nil) ///
style(tex) bt topf(top.tex) botf(bot.tex) ///
topstr(Cannibalization in Carbonated Beverages|0.5\textwidth) ///
botstr(\;Applying equation [13] with estimated firm- and UPC-elasticities for the Carbonated Beverages product group.|tab:carb_bev_can)
