version 12.1
global TERMINAL "/mnt/data0/work/MPF_FINAL"
set type double



cd ${TERMINAL}/data
use RedoFullPostestimationV2_v5.dta, clear
drop if (product_group_code == 3501 | product_group_code == 4001)
bys panel_year quarter: egen double salestotal = sum(value)
bys panel_year quarter firmid: egen double firmintotal = sum(value)
gen double fshare = (firmintotal/salestotal)*100

collapse (firstnm) fshare, by(firmid panel_year quarter) fast

qui sum fshare,d
local r1 = `r(p99)'
local r2 = `r(max)'


clear
set obs 1
gen bin = 1
gen e1 = `r1'
gen e2 = `r2'

la var bin ""
la def bin 1 "Market Share (%)"
la val bin bin
local vv1 "99th Percentile of Firms"
local vv2 "Largest Firm"

cd ${TERMINAL}/results/tables/
tabout bin using M5_FirmShare.tex, c(mean e1 mean e2) h2(`vv0'&`vv1'&`vv2'\\) ///
replace sum ptotal(none) f(3 3) h3(nil) ///
style(tex) bt topf(top.tex) botf(bot.tex) ///
topstr(Firm Market Shares|0.5\textwidth) ///
botstr(\;|tab:fshares)
