version 12.1
global TERMINAL "/mnt/data0/work/MPF_FINAL"
set type double
set more off


cd ${TERMINAL}/data
use RedoFullPostestimationV2_v5.dta,clear
gen a =1

unique firmid, gen(count_firmid_quarter) by(time)
egen upc_uq = group(upc upc_ver_uc)
unique upc_uq, gen(count_upc) by(a)
unique upc_uq, gen(count_upc_quarter) by(time)

qui sum count_firmid_quarter,d
local firm = `r(p50)'
qui sum count_upc
local upc_total = `r(max)'
qui sum count_upc_quarter
local upc_qtr = `r(mean)'


clear
set obs 1
gen bin = 1
gen e1 = `firm'
gen e2 = `upc_total'
gen e3 = `upc_qtr'

la var bin ""
la def bin 1 "Count"
la val bin bin
local vv1 "Firms (Median Quarter)"
local vv2 "UPCs (Total)"
local vv3 "UPCs (Quarterly Average)"

cd ${TERMINAL}/results/tables/
tabout bin using M1_counts.tex, c(mean e1 mean e2 mean e3) h2(`vv0'&`vv1'&`vv2'&`vv3'\\) ///
replace sum ptotal(none) f(0 0 0) h3(nil) ///
style(tex) bt topf(top.tex) botf(bot.tex) ///
topstr(Observation Counts|0.85\textwidth) ///
botstr(\;|tab:counts)
