version 12.1
global TERMINAL "/mnt/data0/work/MPF_FINAL"

set type double
set more off

cd ${TERMINAL}/data/KILTS

use national_brand_share_sales.dta,clear
replace share = share *100
sum share,d
local brand = `r(p50)'

use national_firm_share_sales.dta,clear
replace share = share *100
sum share,d
local firm = `r(p50)'



use city_price_regression.dta,clear

reg partial_price nat_price
local r1 = `e(r2)'

clear
set obs 1
gen e1 = `brand'
gen e2 = `firm'
gen e3 = `r1'


gen bin = 1
la var bin ""
la def bin 1 ""
la val bin bin

local v1 "National Brands"
local v2 "National Firms"
local v3 "Price Levels"

local K = 0
foreach v of varlist e* {
local ++K
local V: var la `v'
*la var `v' "{\parbox{\linewidth}{\centering_`V'}}"
gen length= length(string(round(`v',1)))
qui sum length
local int_`K' = `r(max)'
drop length
}

local dec_list "1 1 2"
local col_format ""
forval k = `K'(-1)1 {
local k_start = 2*(`k'-1)+1
local dec_`k' = substr("`dec_list'",`k_start',1)
local col_format "`int_`k''|`dec_`k''|`col_format'"
}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"

cd ${TERMINAL}/results/tables

tabout bin using M4_MarketDefinition.tex, ///
c(mean e1 mean e2 mean e3) ///
h2(&\multicolumn{2}{c}{Median Expenditure Share (\%)}&\multicolumn{1}{c}{Partial $ R^2$ }\\) cl2(2-3 4-4) ///
h3(`v0'&`v1'&`v2'&`v3'\\) replace sum ptotal(none) f(`dec_list') ///
style(tex) bt topf(top_Scol.tex) botf(bot_Scol.tex) ///
topstr(City vs.\ National Prices|.9\textwidth|`col_format') ///
botstr(Partial $ R^2$ excludes fixed effects in regression of city prices on national prices with quarter--year dummies and bar-code fixed effects|tab:city_price)


! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' M4_MarketDefinition.tex
! perl -i -pe 's/\#\]\}\n//g' M4_MarketDefinition.tex

forval i=1/3 {
local w`i' "`v`i''"
local ww`i' "`w`i''"
! perl -i -pe 's/`w`i''/{\\parbox{\\linewidth}{\\centering `ww`i''}}/g' M4_MarketDefinition.tex



