version 12.1
set type double
global TERMINAL "/mnt/data0/work/MPF_FINAL"



clear
set more off
cd ${TERMINAL}/data

foreach type in "decile" "rank" {

    use RedoFullPostestimationV2_v5.dta, clear
    *
    * drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
    sort product_group_code
    drop if product_group_code==3501 | product_group_code==4001
    *
    gen double CournotElasticity = 1/((1/SigmaF)-((1/SigmaF)-1)*sharefirmgroup)
    *
    gen double CournotMarkup = (CournotElasticity/(CournotElasticity-1))-1
    gen double markup2 = (SigmaF/(SigmaF-1))-1
    gen double markup3 = (SigmaU/(SigmaU-1))-1

    collapse (mean)  markup markup2 markup3 CournotMarkup cannibalization cannibalfirstterm firmsalestotal sharefirmgroup, by(product_group_code firmid) fast

    sum markup markup2 markup3 CournotMarkup cannibalization cannibalfirstterm, d
    save markups_cannib_all_firm_v5, replace

    gen double logtotalsales = ln(firmsalestotal)

    egen decile = xtile(logtotalsales), by(product_group_code) nq(10)

    if "`type'"=="rank" {
        bys  product_group_code: egen double cumul = rank(logtotalsales), field 
        }
        
    else if "`type'"=="decile" {
        gen cumul = decile
        }
        
    sort product_group_code cumul

    replace cumul = 51 if cumul > 51

    bys product_group_code cumul: egen double meanCannib = mean(cannibalization)

    bys product_group_code cumul: egen double meanMarkup = mean(markup)

    bys product_group_code cumul: egen double meanCannib2 = mean(cannibalfirstterm)

    bys product_group_code cumul: egen double meanMarkup2 = mean(markup2)

    bys product_group_code cumul: egen double meanCannib3 = mean(sharefirmgroup)

    bys product_group_code cumul: egen double meanMarkup3 = mean(markup3)

    bys product_group_code cumul: egen double meanCournot = mean(CournotMarkup)


    collapse (sum) firmsalestotal (firstnm) meanCannib meanCournot meanMarkup meanCannib2 meanMarkup2 meanCannib3 meanMarkup3, by(product_group_code cumul) fast 

    sum meanCannib meanMarkup meanCannib2 meanMarkup2 meanCannib3 meanMarkup3 meanCournot, d

    bys product_group_code:egen double totalsales1 = sum(firmsalestotal)

    egen double totalsales2 = sum(firmsalestotal)

    gen double pgweight = totalsales1/totalsales2

    gen double wmeanCannib = meanCannib*pgweight

    gen double wmeanMarkup = meanMarkup*pgweight

    gen double wmeanCannib2 = meanCannib2*pgweight

    gen double wmeanMarkup2 = meanMarkup2*pgweight

    gen double wmeanCannib3 = meanCannib3*pgweight

    gen double wmeanMarkup3 = meanMarkup3*pgweight

    gen double wmeanCournot = meanCournot*pgweight

    collapse (sum) wmeanCannib wmeanCournot wmeanMarkup wmeanCannib2 wmeanMarkup2 wmeanCannib3 wmeanMarkup3, by(cumul) fast

    order cumul wmeanMarkup wmeanMarkup2 wmeanMarkup3 wmeanCournot wmeanCannib wmeanCannib2 wmeanCannib3
    keep cumul wmeanMarkup wmeanCournot wmeanCannib
    rename wmeanMarkup bertrand_epsilon 
    rename wmeanCournot cournot 
    rename wmeanCannib Cannibalization 
    save markup_cannib_by_`type'_v5.dta, replace
}
