version 12.1
set type double
global TERMINAL "/mnt/data0/work/MPF_FINAL"



set more off
cd ${TERMINAL}
use data/markup_cannib_by_decile_v5, clear



*egen decile = rank(cumul) // to get 10 the largest decile
egen decile = rank(-cumul) // 1 is largest decile
drop cumul

replace Cannibalization = -Cannibalization // why is this positive in the table?

*la var decile "Decile (Largest=10)"
la var decile "Ranked Decile" // for largest = 1
la var cournot "Average Cournot Markup" 
la var bertrand_epsilon "Average Bertrand Markup"
la var Cannibalization "Average Cannibalization Rate"

local K = 0
foreach v of varlist cournot bertrand_epsilon Cannibalization {
	local ++K
	local V: var la `v'
	*la var `v' "{\parbox{\linewidth}{\centering_`V'}}"
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	}
	
local dec_list "2 2 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"


local v0 : var la decile
local v1 : var la cournot
local v2 : var la bertrand_epsilon
local v3 : var la Cannibalization

cd ${TERMINAL}/results/tables/

tabout decile using M2_markup_cannib_decile_Scol.tex, c(mean cournot mean bertrand_epsilon ///
	mean Cannibalization) h3(nil) h2(`v0'&`v1'&`v2'&`v3'\\) replace sum ptotal(none) ///
	f(`dec_list') style(tex) bt topf(top_Scol.tex) botf(bot_Scol.tex) ///
	topstr(Markups and Cannibalization by Decile|.9\textwidth|`col_format') ///
	botstr(Largest decile is ranked first. Weighted average across product groups, by quarter.|tab:MarkCanDec)



	
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' M2_markup_cannib_decile_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' M2_markup_cannib_decile_Scol.tex

forval i=1/`K' {
	local w`i' "`v`i''"
	local ww`i' "`w`i''"
	local ww3 "Average Cannibalization Rate\\vphantom{p}"
	! perl -i -pe 's/`w`i''/{\\parbox{\\linewidth}{\\centering `ww`i''}}/g' M2_markup_cannib_decile_Scol.tex
	}

