version 12.1
set type double
global TERMINAL "/mnt/data0/work/MPF_FINAL"



set more off
cd ${TERMINAL}
use data/markup_cannib_by_rank_v5, clear

keep if cumul<=10
replace Cannibalization = -Cannibalization 

la var cumul "Firm Sales Rank"

* To get table in backwards order...
* to sort backwards...
/*
gsort -cumul
replace cumul=_n
la var cumul "Firm Rank (Largest=1)"
la def cumul 1 "10" 2 "9" 3 "8" 4 "7" 5 "6" 6 "5" 7 "4" 8 "3" 9 "2" 10 "1"
la val cumul cumul
*/

la var cumul "Firm Rank" // for descending by size
la var cournot "Cournot Markup" 
la var bertrand_epsilon "Bertrand Markup"
la var Cannibalization "Cannibalization Rate"

local K = 0
foreach v of varlist cournot bertrand_epsilon Cannibalization {
	local ++K
	local V: var la `v'
	*la var `v' "{\parbox{\linewidth}{\centering_`V'}}"
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	}
	
local dec_list "3 3 3"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"

local v0 : var la cumul
local v1 : var la cournot
local v2 : var la bertrand_epsilon
local v3 : var la Cannibalization

cd ${TERMINAL}/results/tables/
	
tabout cumul using M3_markup_cannib_rank_Scol.tex, c(mean cournot mean bertrand_epsilon ///
	mean Cannibalization) h3(nil) h2(`v0'&`v1'&`v2'&`v3'\\) replace sum ptotal(none) ///
	f(3 3 3) style(tex) bt topf(top_Scol.tex) botf(bot_Scol.tex) ///
	topstr(Markups and Cannibalization by Firm Rank|.9\textwidth|`col_format') ///
	botstr(Largest firm is ranked first. Weighted averages across product groups.|tab:MarkCanFirmRank)

	
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' M3_markup_cannib_rank_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' M3_markup_cannib_rank_Scol.tex

forval i=1/`K' {
	local w`i' "`v`i''"
	local ww`i' "`w`i''"
	local ww3 "Cannibalization Rate\\vphantom{p}"
	! perl -i -pe 's/`w`i''/{\\parbox{\\linewidth}{\\centering `ww`i''}}/g' M3_markup_cannib_rank_Scol.tex
	}


