version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear
set more off
cd ${TERMINAL}/data

use RedoFullPostestimationV2_v5.dta, clear
**
* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001

gen double lnupcqualityt = ln(upcqualityt)

*with time FE
xi: areg lnupcqualityt i.time, absorb(upc)
local r1 = `e(r2)'

* w/o time FE
xi: areg lnupcqualityt, absorb(upc)
local r2 = `e(r2)'

collapse (firstnm) firmqualityt, by(product_group_code firmid panel_year quarter) fast

sort product_group_code firmid

egen double firmgroup = group(product_group_code firmid)
sort panel_year quarter
egen double time = group(panel_year quarter)

gen double lnfirmqualityt = ln(firmqualityt)


*with time FE
xi: areg lnfirmqualityt i.time, absorb(firmgroup)
local r3 = `e(r2)'
* w/o time FE
xi: areg lnfirmqualityt, absorb(firmgroup)
local r4 = `e(r2)'

clear
set obs 1
gen bin = 1
gen e1 = `r1'
gen e2 = `r2'
gen e3 = `r3'
gen e4 = `r4'


la var bin ""
la def bin 1 "$ R^2$"
la val bin bin
local vv1 "With UPC FE"
local vv2 "No UPC FE"
local vv3 "With Firm FE"
local vv4 "No Firm FE"

cd ${TERMINAL}/results/tables/
tabout bin using M8_qualitytime.tex, c(mean e1 mean e2 mean e3 mean e4) ///
cl2(2-3 4-5) ///
h2(&\multicolumn{2}{c}{UPC Appeal}&\multicolumn{2}{c}{Firm Appeal}\\) ///
h3(`vv0'&`vv1'&`vv2'&`vv3'&`vv4'\\) ///
replace sum ptotal(none) f(2 2 2 2) ///
style(tex) bt topf(top.tex) botf(bot.tex) ///
topstr(Quality Regressions On Time Dummies|\textwidth) ///
botstr(\;|tab:quality_time)

! perl -i -pe 's/\\\\$/\\$/g' M8_qualitytime.tex

