version 12.1
global TERMINAL "/mnt/data0/work/MPF_FINAL"
set type double





use ${TERMINAL}/data/qje/corr_table_upc_data, clear
qui sum dC,d
local var_appeal = `r(Var)'
qui sum dD,d
local var_cost = `r(Var)'

local r1 = (`var_appeal'/`var_cost'-1)*100

collapse (mean) loggeomeanaut firmqualityt, by(panel_year quarter product_group_code firmid) fast

* NEW SET UP TO SUM TO ONE
rename loggeomeanaut lnGeomeanAut
gen double lnFirmQuality = ln(firmqualityt)

foreach X in lnFirmQuality lnGeomeanAut {
    bys panel_year quarter product_group_code: egen double a`X'=mean(`X')
    gen double d`X'=`X'-a`X'
    }

qui sum dlnFirmQuality,d
local var_appealF = `r(Var)'
qui sum dlnGeomeanAut,d
local var_costF = `r(Var)'

local r2 = (`var_appealF'/`var_costF'-1)*100

clear
set obs 1
gen bin = 1
gen e1 = `r1'
gen e2 = `r2'

la var bin ""
la def bin 1 "Exceeds by (%)"
la val bin bin
local vv1 "UPC"
local vv2 "Firm"

cd ${TERMINAL}/results/tables/
tabout bin using M9_RelativeVariance.tex, c(mean e1 mean e2) h2(`vv0'&`vv1'&`vv2'\\) ///
replace sum ptotal(none) f(2 2) h3(nil) ///
style(tex) bt topf(top.tex) botf(bot.tex) ///
topstr(Variance of Relative Appeal to Variance of Relative Cost|0.5\textwidth) ///
botstr(\;|tab:brand)
