version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear
set more off
cd ${TERMINAL}/data

use "${TERMINAL}/results/NewGMMresultsV2_test.dta", clear
rename sigf SigmaF
rename sigu SigmaU


* Welch's t-test with unequal variances*

gen double num = max((SigmaU-SigmaF),(SigmaU-SigmaF))

gen double tstat = (SigmaU-SigmaF)/((sigu_SE^2 + sigf_SE^2)^(1/2))
gen double degreesfreedomapprox = (((sigu_SE^2) + (sigf_SE^2))^(1/2))/((((sigu_SE^4)/(obs-3) + (sigf_SE^4)/(obsother-2))))
gen double df = round(degreesfreedomapprox)
replace df = 1 if df == 0
gen double pval = 2*ttail(df,tstat)

sum pval,d
qui sum
local N = `r(N)'
qui sum if pval < 0.05
local N_reject = `r(N)'
local pct_reject = `N_reject'/`N'*100
di "Reject in following percent of cases:"
di `pct_reject'

clear
set obs 1
gen bin = 1
gen reject = `pct_reject'
la var reject "Product Groups in Which \$\sigma_g^U = \sigma_g^F\$ is Rejected (\%)"
la var bin ""
la def bin 1 ""
la val bin bin
local vv1: var la reject

cd ${TERMINAL}/results/tables/
tabout bin using M7_sigmaDiff.tex, c(mean reject) h2(`vv0'&`vv1'\\) ///
	replace sum ptotal(none) f(`dec_list') h3(nil) ///
	style(tex) bt topf(top.tex) botf(bot.tex) ///
	topstr(Elasticity Differences|0.33\textwidth) ///
	botstr(\;|tab:sigma_diff)
