version 12.1
global TERMINAL "/mnt/data0/work/MPF_FINAL"
set type double




set more off
cd ${TERMINAL}/results/

use NewGMMresultsV2_brand_v2.dta,clear
sum sigf,d
local sigf = `r(p50)'
sum sigu,d
local sigu = `r(p50)'

clear
set obs 1
gen bin = 1
gen e1 = `sigf'
gen e2 = `sigu'

la var bin ""
la def bin 1 "Median Elasticity"
la val bin bin
local vv1 "\$ \sigma_g^F\$"
local vv2 "\$ \sigma_g^U\$"

cd ${TERMINAL}/results/tables/
tabout bin using M11_BrandDiffMeds.tex, c(mean e1 mean e2) h2(`vv0'&`vv1'&`vv2'\\) ///
replace sum ptotal(none) f(2 2) h3(nil) ///
style(tex) bt topf(top.tex) botf(bot.tex) ///
topstr(Brand Differenced Elasticity Estimates|0.5\textwidth) ///
botstr(\;|tab:brand)
