global TERMINAL "/mnt/data0/work/MPF_FINAL"
set type double


***************************************************************************
* Pre GMM Preparation
* Generate data for estimation, and also data to be used in post-estimation
****************************************************************************

	clear all
	set more off
	set matsize 11000
	set maxvar 32767
	set type double
	
	cd ${TERMINAL}/data/
	
		
	use NestedMPFPriceIndexRedo_v3.dta, clear
	drop if panel_year == 1994
	drop time

	sort upc  panel_year quarter
	egen double time = group(panel_year quarter)

	sort product_group_code firmid upc 
	merge m:1  product_group_code firmid upc  using baseupcs_v3.dta
	keep if _merge == 3

	drop if rawb < 20
	

	sum rawb,d

	keep bm fm product_group_code firmid panel_year quarter lnprice shareprodfirm upc  upc2 lnshareprodfirm time
	rename lnprice lnprice_base
	rename shareprodfirm shareprodfirm_base
	rename upc2 upc_base


	gen double lnshareprodfirm_base = ln(shareprodfirm_base)
	
	sort upc_base time
	xtset upc_base time

	
	**bys upc_base  firmid product_group_code (panel_year quarter): gen double lag_lnshareprodfirm_base=lnshareprodfirm_base[_n-1] if time[_n] == time[_n-1]+1 & upc_base[_n] == upc_base[_n-1]
	gen double lag_lnshareprodfirm_base=l4.lnshareprodfirm_base
	
	* produces identical values *
	*bys upc_base _base product_module_code brand_code (panel_year quarter): gen double lag_lnshareprodbrand_basetest=cond(time[_n] == time[_n-1]+1,lnshareprodbrand_base[_n-1],.)

	*by upc_base  firmid product_group_code (panel_year quarter): gen double lag_shareprodfirm_base=shareprodfirm_base[_n-1] if time[_n] == time[_n-1]+1 & upc_base[_n] == upc_base[_n-1]
	*by upc_base  firmid product_group_code (panel_year quarter): gen double lag_lnprice_base=lnprice_base[_n-1] if time[_n] == time[_n-1]+1 & upc_base[_n] == upc_base[_n-1]
	gen double lag_shareprodfirm_base=l4.shareprodfirm_base
	gen double lag_lnprice_base=l4.lnprice_base

	drop if upc_base == .


	duplicates drop firmid product_group_code panel_year quarter, force
	sort firmid product_group_code panel_year quarter

	save basedata_LongDiff.dta, replace
		
	use NestedMPFPriceIndexRedo_v3.dta, clear
	drop if panel_year == 1994
	drop time

	sort upc  panel_year quarter
	egen double time = group(panel_year quarter)

	sort firmid product_group_code panel_year quarter 


	merge m:1 firmid product_group_code panel_year quarter using basedata_LongDiff.dta
	** don't drop base upc  **
	drop _merge

	*** variables for GMM estimation ***
	*gen double dropfirm = 0
	*replace dropfirm = 1 if fm == firmid_base
	gen double dropupc = 0
	replace dropupc = 1 if upc2 == upc_base
	replace dropupc = 1 if rawb < 20

	gen double dropupc2 = 0
	replace dropupc2 = 1 if rawb < 20

	*** UPC ***
	*** error was here: no lag_lnprice or lag_lnshareprodfirm!
	
	sort upc time
	xtset upc time
	
	*bys upc  firmid product_group_code (panel_year quarter): gen double lag_lnprice=lnprice[_n-1] if time[_n] == time[_n-1]+1 & upc[_n] == upc[_n-1]
	*by upc  firmid product_group_code (panel_year quarter): gen double lag_lnshareprodfirm=lnshareprodfirm[_n-1] if time[_n] == time[_n-1]+1 & upc[_n] == upc[_n-1]
	gen double lag_lnprice=l4.lnprice
	gen double lag_lnshareprodfirm=l4.lnshareprodfirm
	
	gen double ddupcprice = (lnprice - lag_lnprice) - (lnprice_base - lag_lnprice_base)
	gen double ddfirmprodshare = (lnshareprodfirm - lag_lnshareprodfirm) - (lnshareprodfirm_base - lag_lnshareprodfirm_base)
	
	
	
	
	keep   fm upc2 upc  upc_base  rawb product_module_code firmid product_group_code panel_year quarter time rawb dropupc ddfirmprodshare ddupcprice
	
	*sort product_group_code firmid upc panel_year quarter time
	
	
	gen double lagrawb = l4.rawb
	
	gen double weight = 1/rawb + 1/lagrawb
	gen double bias1 = weight
	drop if ddupcprice == .
	drop if ddfirmprodshare == .



	
	
	* Drop if bad UPC, too small, base UPC
	drop if upc2 == upc_base
	drop if rawb < 20
	drop if dropupc == 1
	drop dropupc
	
	bys upc firmid product_group_code: egen double countobs = count(ddupcprice)
	sum countobs,d

	
	
	* Weights
	drop if weight == .
	gen double countweight = countobs^(3/2)
	replace weight = weight ^(-1/2)
	replace weight = weight*countweight
	drop countweight countobs

	


	sort upc time 

	

	*drop time
	*sort panel_year quarter
	*egen double time = group(panel_year quarter)

	

	drop if product_group_code == .
	sort product_group_code firmid upc time

	
	
	drop product_module_code firmid upc2  rawb

	order upc fm product_group_code ddupcprice ddfirmprodshare weight

	save PreGMM1V2_LongDiff.dta, replace

* ***************************************
* This code estimates the elasticity parameter SigmaU 
* ***************************************

** trim the double differenced variables 
sum ddupcprice,d
local umin = `r(p1)'
local umax = `r(p99)'
replace ddupcprice = . if ddupcprice <= `umin'
replace ddupcprice = . if ddupcprice >= `umax'
*
sum ddfirmprodshare,d
local fmin = `r(p1)'
local fmax = `r(p99)'
replace ddfirmprodshare = . if ddfirmprodshare <= `fmin'
replace ddfirmprodshare = . if ddfirmprodshare >= `fmax'
drop if ddupcprice == .
drop if ddfirmprodshare == .

** generate variables used in the estimation 
* generate the squate of the double differenced variables 
gen double y2 = ddupcprice*ddupcprice
gen double z1 = ddupcprice*ddfirmprodshare
gen double z2 = ddfirmprodshare*ddfirmprodshare
* generate the product group - upc average of the squared - double differenced variables 
bys product_group_code upc: egen double weight_bar = mean(weight)
by product_group_code upc: egen double y2_bar = mean(y2)	
by product_group_code upc: egen double z1_bar = mean(z1)	
by product_group_code upc: egen double z2_bar = mean(z2)
bys product_group_code upc: egen double b1 = mean(bias1)

** clean: drop upcs with less than 10 or 20 observations in a given product group 
bys product_group_code upc: egen double t2 = count(y2)
sum t2,d
drop if t2 < 10
drop if t2 < 20 & product_group_code != 2004 & product_group_code != 5505 & product_group_code != 5509 & product_group_code != 5517 & product_group_code != 6005 & product_group_code != 6006 & product_group_code != 6007 & product_group_code != 6013

* generate the weighted mean of the squared - double differenced variables 
bys product_group_code: egen double sum_weight = total(weight_bar)
gen double weight_bar_other = weight_bar/sum_weight
foreach var in y2_bar z1_bar z2_bar {
		replace `var' = `var'*weight_bar_other
}
collapse (mean) y2_bar z1_bar z2_bar t2 weight_bar_other b1 ddfirmprodshare ddupcprice, by(product_group_code upc) fast

* drop product group with less than 3 observations
bys product_group_code: egen countobs2 = count(t2)
drop if countobs2 < 3

* save the dataset used for the estimation of SigmaU
sort product_group_code
egen double pglist = group(product_group_code)
save estimationdata_LongDiff.dta,replace

* estimate SigmaU using the method proposed by Broda and Weinstein (2006) and a nonlinear solver 
sum pglist, meanonly
local max = `r(max)'

forvalues i = 1/`max' {
forvalues k = 1/5 {
use estimationdata_LongDiff.dta,clear
keep if pglist == `i'
local pg = product_group_code
local u = `k'+0.001
local w = (`k')/4
capture noisily: nl (y2_bar ={c1=0}*b1+((({sigu=`u'}-2)*({omega})-1)/((1+{omega})*({sigu}-1)))*z1_bar+({omega=`w'}/((1+{omega})*({sigu}-1)))*z2_bar), eps(1e-10) vce(robust) hasconstant(c1)
local rc = _rc

if `rc' == 0 {
capture: local sigu_est = _b[sigu: _cons] 
capture: local omega_est = _b[omega: _cons] 
capture: local sigu_se = _se[sigu: _cons] 
capture: local omega_se = _se[omega: _cons] 
capture: local ssr = e(rss) 
capture: local r2 = e(r2) 
capture: local obs = countobs2
}


drop _all
set obs 1
gen group = `pg'
if `rc' == 0 {
capture: gen double sigu = `sigu_est' 
capture: gen double omega = `omega_est' 
capture: gen double sigu_SE = `sigu_se' 
capture: gen double omega_SE = `omega_se' 
capture: gen double SSR = `ssr' 
capture: gen double r2 = `r2' 
capture: gen double obs = `obs' 
}

if `i' > 1 | `k' > 1{
	append using EstimationStaggeredCon_LongDiff.dta
	}
	save EstimationStaggeredCon_LongDiff.dta, replace
}
}

use EstimationStaggeredCon_LongDiff.dta, clear
* clean the estimation output 
drop if sigu < 0 | omega < 0
drop if sigu_SE == 0
drop if omega_SE == 0
sort group SSR
collapse (firstnm) sigu omega sigu_SE omega_SE SSR r2 obs, by(group) fast
rename group product_group_code
sort product_group_code
* save the SigmaU estimates 
save EstimationStaggeredCon_LongDiff2.dta, replace

use NestedMPFPriceIndexRedo_v3.dta, clear
	drop if panel_year == 1994
	drop time

	sort upc  panel_year quarter
	egen double time = group(panel_year quarter)

	sort firmid product_group_code panel_year quarter 


	merge m:1 firmid product_group_code panel_year quarter using basedata_LongDiff.dta
	** don't drop base upc  **
	drop _merge

	bys panel_year quarter: egen double totalval = total(value)
	gen double sharefirm = firmsalestotal/totalval
	
	********** Merge in estimated sigma_u's

	sort product_group_code
	merge product_group_code using EstimationStaggeredCon_LongDiff2.dta, keep(sigu omega)
	drop if _merge !=3
	drop _merge

***********************************************8
	/*gen double dropupc = 0
	replace dropupc = 1 if upc2 == upc_base
	replace dropupc = 1 if rawb < 20

	gen double dropupc2 = 0
	replace dropupc2 = 1 if rawb < 20*/

	
gen double SigmaU = sigu

	
bys time product_group_code firmid: egen double meanshare = mean(lnshareprodfirm)
gen double geomeanshare = exp(meanshare)
by time product_group_code firmid: egen double meanprice = mean(lnprice)
gen double geomeanprice = exp(meanprice)
gen double upcqualityt = (price/geomeanprice)*((shareprodfirm/geomeanshare)^(1/(SigmaU-1))) 
gen double relativeshare = shareprodfirm/geomeanshare
bys time product_group_code firmid: egen double relsharesum = sum(relativeshare)

 
gen double firmpriceindexother = (relsharesum ^ (1/(1-SigmaU)))*geomeanprice
gen double relup = (price/upcqualityt)^(1-SigmaU)
bys time product_group_code firmid: egen double relusum = sum(relup)
gen double firmpriceindex = relusum^(1/(1-SigmaU))
gen double lnfirmpriceindex = ln(firmpriceindex)
 
 *******************************************************

		
	gen double lnshare_base = ln(shareprodfirm_base)
	sort product_group_code firmid upc  panel_year quarter

	*gen double diffbaseshare = lnshare_base[_n] - lnshare_base[_n-1] if time[_n] == time[_n-1]+1 & firmid[_n] == firmid[_n-1]
	*gen double lag_lnfirmpriceindex= lnfirmpriceindex[_n-1] if time[_n] == time[_n-1]+1 & firmid[_n] == firmid[_n-1]
	
	sort upc time
	xtset upc time

	gen double lag_baseshare = L4.lnshare_base
	gen double diffbaseshare = lnshare_base - lag_baseshare
	gen double lag_lnfirmpriceindex = L4.lnfirmpriceindex
	
	bys firmid product_group_code panel_year quarter: egen double meanlspf = mean(lnshareprodfirm)
	gen double geomean = exp(meanlspf)
	gen double lngeomean = ln(geomean)
	gen double geomeanratio = shareprodfirm/geomean
	bys firmid product_group_code panel_year quarter: egen double sumgeomeanratio = sum(geomeanratio)
	gen double lngeoratio = ln(sumgeomeanratio)
	bys firmid product_group_code panel_year quarter: egen double lngeoprice = mean(lnprice)



	
	gen double Satochange = lnfirmpriceindex - lag_lnfirmpriceindex



	sort upc time
	gen double lag_lngeoratio=L4.lngeoratio
	gen double lag_lngeoprice=L4.lngeoprice
	gen double lag_lngeomean=L4.lngeomean
	gen double lag_lnsharefirmgroup=L4.lnsharefirmgroup
	gen double lag_sharefirm=L4.sharefirm
	gen double lag_sharegroup=L4.sharegroup
	
	
	*bys upc  firmid product_group_code (panel_year quarter): gen double lag_lngeoratio=lngeoratio[_n-1] if time[_n] == time[_n-1]+1 & firmid[_n] == firmid[_n-1]
	*bys upc  firmid product_group_code (panel_year quarter): gen double lag_lngeoprice=lngeoprice[_n-1] if time[_n] == time[_n-1]+1 & firmid[_n] == firmid[_n-1]
	*bys upc  firmid product_group_code (panel_year quarter): gen double lag_lngeomean=lngeomean[_n-1] if time[_n] == time[_n-1]+1 & firmid[_n] == firmid[_n-1]
	
	*bys upc  firmid product_group_code (panel_year quarter): gen double lag_lnsharefirmgroup=lnsharefirmgroup[_n-1] if time[_n] == time[_n-1]+1 & firmid[_n] == firmid[_n-1]
	*bys upc  firmid product_group_code (panel_year quarter): gen double lag_sharefirm=sharefirm[_n-1] if time[_n] == time[_n-1]+1 & firmid[_n] == firmid[_n-1]
	*bys product_group_code (panel_year quarter): gen double lag_sharegroup=sharegroup[_n-1] if time[_n] == time[_n-1]+1


	bys firmid product_group_code panel_year quarter: egen testlaggeo=mean(lag_lngeoratio)
	replace lag_lngeoratio = testlaggeo if lag_lngeoratio == .
	
	bys firmid product_group_code panel_year quarter: egen testlagme=mean(lag_lngeomean)
	replace lag_lngeomean = testlagme if lag_lngeomean == .
	
	by firmid product_group_code panel_year quarter: egen testlagprice=mean(lag_lngeoprice)
	replace lag_lngeoprice = testlagprice if lag_lngeoprice == .

	by firmid product_group_code panel_year quarter: egen testlagshareg=mean(lag_lnsharefirmgroup)
	replace lag_lnsharefirmgroup = testlagshareg if lag_lnsharefirmgroup == .

	by firmid product_group_code panel_year quarter: egen testlagshare=mean(lag_sharefirm)
	replace lag_sharefirm = testlagshare if lag_sharefirm == .

	save Prebasebrand_v3_LD.dta, replace

* XXXXXXXXXXX


	use Prebasebrand_v3_LD.dta, clear
	sort product_group_code firmid product_module_code panel_year quarter

	save Prebasebrand2_v3_LD.dta, replace

	** Choose base brand for each firm ** 

	*Criteria 1: find firms available in all years
	sort product_group_code firmid
	egen double firmmod = group(firmid)

	gen double test = sharefirm-lag_sharefirm
		
	drop if test == .

	

	bys upc firmid product_group_code: egen double countobs = count(value)

	


	collapse (firstnm) firmsalestotal sharefirm sharefirmgroup, by(firmid product_group_code panel_year quarter) fast
		
		

		bys firmid product_group_code: gen double count_yr = _N
		bys product_group_code: egen double max_count_yr = max(count_yr)
		keep if count_yr==max_count_yr
		
	*Criteria 2: find largest firms satisfying criteria 1

	collapse (sum) firmsalestotal, by(firmid product_group_code) fast
		gsort product_group_code -firmsalestotal
		drop if firmsalestotal == 0 | firmsalestotal == .
		drop if firmid == .
		** largest good as base **
		keep if _n==1 | product_group_code!= product_group_code[_n-1]
		
		keep firmid product_group_code
		sort product_group_code firmid 
		save basefirms_v3_LD.dta, replace
		
	use Prebasebrand_v3_LD.dta, clear
	
	
	
	sort product_group_code firmid


	merge m:1 product_group_code firmid  using basefirms_v3_LD.dta
	keep if _merge == 3



	bys upc firmid product_group_code: egen double countobs = count(value)

	
	

	rename lnsharefirmgroup lnsharefirmgroup_base
	rename lag_lnsharefirmgroup lag_lnsharefirmgroup_base
	rename Satochange Satochange_base
	rename lngeoratio lngeoratio_base
	rename lngeomean lngeomean_base
	rename lag_lngeomean lag_lngeomean_base
	rename lag_lngeoratio lag_lngeoratio_base
	rename lngeoprice lngeoprice_base
	rename lag_lngeoprice lag_lngeoprice_base
	gen double product_group_code_base = product_group_code
	gen double firmid_base = fm

	collapse (firstnm) lnsharefirmgroup_base lag_lnsharefirmgroup_base Satochange_base lngeoratio_base  lag_lngeoratio_base product_group_code_base firmid_base lngeomean_base lag_lngeomean_base lngeoprice_base lag_lngeoprice_base, by(product_group_code panel_year quarter) fast

	duplicates drop product_group_code panel_year quarter, force


	sort product_group_code panel_year quarter

	save basefirmdata_v3_LD.dta, replace

		*****
		


use Prebasebrand_v3_LD.dta, clear

	sort product_group_code panel_year quarter 
	merge m:1 product_group_code panel_year quarter using basefirmdata_v3_LD.dta
	
	drop _merge
	
	

	**********************************


	*** variables for GMM estimation ***
	

	*** Firm ***
	gen double ddfirmshare = (lnsharefirmgroup - lag_lnsharefirmgroup) - (lnsharefirmgroup_base - lag_lnsharefirmgroup_base)
	gen double ddSato = Satochange - Satochange_base
	gen double ddrelativeshare = lngeoratio - lag_lngeoratio - (lngeoratio_base - lag_lngeoratio_base)
	gen double firmprodshare = exp(lnshareprodfirm)
	gen double ddgeomeanshare = lngeomean - lag_lngeomean - (lngeomean_base - lag_lngeomean)
	
	
	*** Firms ***
	keep fm upc2 upc upc_base lag_lnfirmpriceindex  rawb lnsharefirmgroup lag_lnsharefirmgroup lnsharefirmgroup_base  lag_lnsharefirmgroup_base product_module_code firmid product_group_code panel_year quarter time  firmbuyers ddfirmshare ddSato ddrelativeshare firmid_base lngeoprice lngeoprice_base lag_lngeoprice lag_lngeoprice_base firmprodshare ddgeomeanshare
	*keep fm ddupcprice upc2 upc  upc_base  rawb lnsharefirmgroup lag_lnsharefirmgroup lnsharefirmgroup_base  lag_lnsharefirmgroup_base product_module_code firmid product_group_code panel_year quarter time  firmbuyers ddfirmshare ddSato ddrelativeshare firmid_base lngeoprice lngeoprice_base lag_lngeoprice lag_lngeoprice_base dropupc2 firmprodshare ddgeomeanshare
	*bys upc firmid product_group_code: egen double countobs = count(ddupcprice)
	*sum countobs,d

	collapse  (firstnm) ddSato ddfirmshare ddrelativeshare firmbuyers firmid_base lnsharefirmgroup lag_lnsharefirmgroup lngeoprice lngeoprice_base lag_lngeoprice lag_lngeoprice_base lnsharefirmgroup_base lag_lnsharefirmgroup_base ddgeomeanshare, by(product_group_code firmid fm panel_year quarter time) fast

	sort product_group_code firmid panel_year quarter time
	
	egen firm_group = group(firmid product_group_code)
	sort firm_group time
	xtset firm_group time
	
	gen double lag_firmbuyers = L4.firmbuyers
	gen double weight = 1/firmbuyers+1/lag_firmbuyers
	
	gen double bias = weight
	
	* Trim by Sato-Vartia index
	drop if ddSato == .
	drop if ddfirmshare == .
	drop if ddrelativeshare == .	

	* Drop base firm, bad firms
	drop if fm == firmid_base

	
	bys firmid product_group_code: egen double countobs = count(ddfirmshare)
	
	
	* Weighting
	drop if weight == .
	gen double countweight = countobs^(3/2)
	replace weight = weight ^(-1/2)
	replace weight = weight*countweight
	drop countweight countobs


	sort firmid time 

	
	drop time
	sort panel_year quarter
	egen double time = group(panel_year quarter)


	drop if product_group_code == .
	sort product_group_code firmid  time

	drop panel_year quarter
	

	order fm product_group_code ddfirmshare ddSato ddrelativeshare weight  lnsharefirmgroup lag_lnsharefirmgroup lnsharefirmgroup_base lag_lnsharefirmgroup_base lngeoprice lag_lngeoprice lngeoprice_base lag_lngeoprice_base

	saveold PreGMM2V2_v3_LD.dta, replace


* ***************************************
* This code estimates the elasticity parameter SigmaF and merges it together with the SigmaU and delta estimates. 
* ***************************************


** Prepare double differenced variables for the estimation and drop missing values 
gen double ddgeomeanprice = lngeoprice- lag_lngeoprice - (lngeoprice_base-lag_lngeoprice_base)

* merge in the double differenced relative price, geometric mean of the relative price etc. 
sort product_group_code
merge product_group_code using EstimationStaggeredCon_LongDiff2.dta, keep(sigu omega)
tab _merge
drop if _merge !=3
drop _merge

* clean 
drop if ddSato == .
drop if ddrelativeshare ==.
drop if ddgeomeanprice == .
gen double ddpft = ddSato
drop if ddpft == .

* rename double differenced variables to the name used by the estimation routine. 
gen double yother = ddfirmshare
gen double x1other = ddpft
gen double x2other = ddgeomeanprice
gen double x3other = ddrelativeshare*(1/(1-sigu))

* trim extreme values 
sum ddfirmshare,d
local ddfmin = `r(p1)'
local ddfmax = `r(p99)'
drop if ddfirmshare < `ddfmin'
drop if ddfirmshare > `ddfmax'
sum ddSato,d
local ddsmin = `r(p1)'
local ddsmax = `r(p99)'
drop if ddSato < `ddsmin'
drop if ddSato > `ddsmax'

* drop product groups with small number of observations
bys product_group_code fm: egen double t = count(yother)
bys product_group_code: egen tsum = sum(t)
bys product_group_code: egen countobs = count(t)
drop if countobs < 2
sort product_group_code
egen double pglist = group(product_group_code)

* saved the dataset used in the estimation 
save estimationdata2sls_LD.dta,replace

* estimate SigmaF by using the IV approach proposed by Broda and Weinstein (2006) 
use estimationdata2sls_LD.dta, clear

*
sum pglist, meanonly
local max = `r(max)'
*
forvalues i = 1/`max' {
forvalues k = 1/1 {
use estimationdata2sls_LD.dta,clear
keep if pglist == `i'
local pg = product_group_code
local obs = countobs
local sumt = tsum
local f = `k'+0.0001

xtset fm time

reg yother x1other, robust

capture noisily:ivreg2 yother (x1other = x3other), gmm2s robust endogtest(x1other) small first 

local rc = _rc

if `rc' == 0 {
capture: local sigf_est = (1-(_b[x1other]))

disp `sigf_est'

capture: local sigf_se = _se[x1other] 

disp `sigf_se'

capture: local ssr = e(rss) 
capture: local r2 = e(r2) 
}

drop _all
set obs 1
gen group = `pg'
if `rc' == 0 {
capture: gen double sigf = `sigf_est' 
capture: gen double sigf_SE = `sigf_se' 
capture: gen double SSR = `ssr' 
capture: gen double obs = `obs' 
capture: gen double timesum = `sumt' 
capture: gen double r2 = `r2'
}

if `i' > 1 | `k' >1 {
	append using FirmNew2slsV2_LD.dta
	}
	save FirmNew2slsV2_LD.dta, replace
	
}
}


use FirmNew2slsV2_LD.dta, clear

rename group product_group_code
rename SSR SSR_2
rename obs obsother
rename r2 rn_2
sort product_group_code

* merge in the SigmaU and delta estimates 
merge product_group_code using EstimationStaggeredCon_LongDiff2.dta
tab _merge
drop _merge 
* drop missing values 
gen double ssrtest = SSR_2+SSR
drop if SSR == .
drop if sigf_SE == 0
drop if sigf == .
drop if sigu == .
gsort product_group_code ssrtest
collapse (firstnm) sigu sigf omega sigu_SE sigf_SE omega_SE ssrtest SSR SSR_2 obs obsother r2 rn_2, by(product_group_code)
sum sigf,d
* drop if the number of observations is less than 30
drop if obs < 30
* save results
cd ${TERMINAL}/results/
save NewGMMresultsV2_LD.dta, replace



