version 12.1
set type double
global TERMINAL "/mnt/data0/work/MPF_FINAL"



*clear all
set more off
set type double

cd ${TERMINAL}/data

use RedoFullPostestimationV2_v5.dta, clear 
*
* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001
*
* set the directory where results are saved 
cd ${TERMINAL}/results/reg_output/geometric_mean
*
* Drop product codes
drop if product_group_code==4505 | product_group_code==5515
* Drop missing values 
drop if firmqualityt == . | upcqualityt == . | aut == .| SigmaU == . | SigmaF == . | value == . | mft == . | grouppriceindex == .
* Keep the time periods used for differentiation 
keep if panel_year == 2004 & quarter == 4 | panel_year == 2011 & quarter == 4
replace time = 1 if panel_year == 2004
replace time = 2 if panel_year == 2011

bys product_group_code firmid panel_year quarter: gen list = _n
gen count = 1 if list == 1
bys product_group_code firmid: egen timeperiods = sum(count)
drop if timeperiods !=2
* generate variables 
bys product_group_code firmid panel_year quarter: egen double firmproduc = count(value)
gen double avgsales = firmsalestotal/firmproduc
bys panel_year quarter product_group_code firmid: egen double totalfirmsales = total(value)
* generate per period firm share of product group 
bys panel_year quarter product_group_code: egen double productgroupsales = total(value)
gen firmshare2=totalfirmsales/productgroupsales
* define the cutoff rule for large firms: firms with market shares larger than 0.5%

* Define the marketing and product upgrading effects 
gen double lnuqual = lnupcquality/firmproduc
bys upc  firmid product_group_code (panel_year quarter): gen double lag_uqual=lnuqual[_n-1] if time[_n] == time[_n-1]+1 & upc[_n] == upc[_n-1]
gen double current=(lnuqual!=.) 
gen double previous=(lag_uqual!=.)	
gen double common=((current==1 & previous==1))
gen double current_only=(current==1 & common==0)


*keep if product_group_code==504

bys upc: gen both=(_N==2)
by upc: gen single=(_N==1)
by upc: gen single1 = (_N==1)&(time==1)
by upc: gen single2 = (_N==1)&(time==2)

collapse (sum) both single*, by(product_group_code)
gen turn = single/(both+single)
gen entry = single1/(both+single)
gen exit = single2/(both+single)

save pg_turn, replace
