version 12.1
set type double
global TERMINAL "/mnt/data0/work/MPF_FINAL"



clear all
set more off
set type double

* Set which firms to use in estimation.
* Want to exclude small firms from estimates
* But include them in calculating the turnover rate

cd ${TERMINAL}/results/reg_output/geometric_mean/qje

use VDG_PG_regs_d_d_lnFQ,clear
keep if parmseq==1
gen e_type=1
local N=_N
expand 2
local N1 = `N'+1
local N2 = _N
*replace estimate = stderr[_n-`N'] in `N1'/`N2'
replace estimate = stderr in `N1'/`N2'
replace e_type = 2 if _n>`N'

keep product_group_code estimate e_type parmseq
tempfile temp1
save `temp1'

use VDG_PG_regs_d_d_lnfirmprod,clear
keep if parmseq==1
gen e_type=1
local N=_N
expand 2
local N1 = `N'+1
local N2 = _N
*replace estimate = stderr[_n-`N'] in `N1'/`N2'
replace estimate = stderr in `N1'/`N2'
replace e_type = 2 if _n>`N'

replace parmseq = 2
keep product_group_code estimate e_type parmseq
tempfile temp2
save `temp2'

use VDG_PG_regs_d_d_lnGeomeanAut,clear
keep if parmseq==1
gen e_type=1
local N=_N
expand 2
local N1 = `N'+1
local N2 = _N
*replace estimate = stderr[_n-`N'] in `N1'/`N2'
replace estimate = stderr in `N1'/`N2'
replace e_type = 2 if _n>`N'

replace parmseq = 3
keep product_group_code estimate e_type parmseq
tempfile temp3
save `temp3'

use VDG_PG_regs_d_d_lnAQR,clear
keep if parmseq==1
gen e_type=1
local N=_N
expand 2
local N1 = `N'+1
local N2 = _N
*replace estimate = stderr[_n-`N'] in `N1'/`N2'
replace estimate = stderr in `N1'/`N2'
replace e_type = 2 if _n>`N'

replace parmseq = 4
keep product_group_code estimate e_type parmseq
tempfile temp4
save `temp4'

use VDG_PG_regs_d_d_lnMft,clear
keep if parmseq==1
gen e_type=1
local N=_N
expand 2
local N1 = `N'+1
local N2 = _N
*replace estimate = stderr[_n-`N'] in `N1'/`N2'
replace estimate = stderr in `N1'/`N2'
replace e_type = 2 if _n>`N'

replace parmseq = 5
keep product_group_code estimate e_type parmseq
tempfile temp5
save `temp5'


use VDG_PG_regs_d_d_product_quality_upgrading2,clear
keep if parmseq==1
gen e_type=1
local N=_N
expand 2
local N1 = `N'+1
local N2 = _N
*replace estimate = stderr[_n-`N'] in `N1'/`N2'
replace estimate = stderr in `N1'/`N2'
replace e_type = 2 if _n>`N'

replace parmseq = 6
keep product_group_code estimate e_type parmseq


forval i = 1/5 {
	append using `temp`i''
	}


reshape wide estimate,i(product_group_code e_type) j(parmseq)

merge m:1 product_group_code using ../pg_turn, ///
	keep(3) nogen
replace turn = . if e_type==2


la var estimate1 "Firm Appeal"
la var estimate2 "Scope"
la var estimate3 "Average MC"
la var estimate4 "Cost Dispersion"
la var estimate5 "Markup"
la var estimate6 "Upgrading"
la var turn "Turnover"


keep if e_type==1


cd ${TERMINAL}/results/tables

eststo clear
foreach v of varlist estimate* {
eststo: reg `v' turn
}

esttab est2 est6 using M10_VDturn_reg_small.tex, compress se not ar2 replace booktabs ///
nonumbers label coef(_cons "Constant") substitute(\_ _) ///
title(Variance Decomposition Turnover Regressions \label{tab:VDturn_reg_small}) ///
star(* 0.10 ** 0.05 *** 0.01)

! perl -i -pe 's/([\d\-\.]+)([\\\s\&e])/\\$\1\\$\2/g' M10_VDturn_reg_small.tex
! perl -i -pe 's/\(([\d\-\.]+)\)/\\$(\1)\\$ /g' M10_VDturn_reg_small.tex




