version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

ssc install lmnwhitenl

** Test for heteroskedasticity ***
clear
set more off
set matsize 11000
cd "${TERMINAL}/data"

use estimationdataTEST.dta,clear

* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001

sum pglist, meanonly





*set trace on

local max = `r(max)'

forvalues i = 1/`max' {
use estimationdataTEST.dta,clear
keep if pglist == `i'

local u = 3
local w = 0.2

local pg = product_group_code

*nl (y2_bar ={c1=0}*b1+((({sigu=`u'}-2)*({omega})-1)/((1+{omega})*({sigu}-1)))*z1_bar+({omega=`w'}/((1+{omega})*({sigu}-1)))*z2_bar), eps(1e-10) vce(robust) hasconstant(c1)

capture: lmnwhitenl y2_bar, fun({c1=0}*b1+((({sigu=`u'}-2)*({omega})-1)/((1+{omega})*({sigu}-1)))*z1_bar+({omega=`w'}/((1+{omega})*({sigu}-1)))*z2_bar)) in(c1 0 sigu `u' omega `w')

local pval = e(lmnwp)

*reg y2_bar z1_bar z2_bar

** This is just a test of linear heteroskedasticity
*estat hettest, iid
****

*whitetst

*estat imtest, white



drop _all
set obs 1
gen group = `pg'

capture: gen double pval = `pval' 



if `i' > 1 {
	append using TestHeterosked.dta
	}
	save TestHeterosked.dta, replace
}

clear

use TestHeterosked
rename group product_group_code

sort product_group_code
merge product_group_code using "${TERMINAL}/results/NewGMMresultsV2_test.dta"
keep if _merge == 3

count if pval >0.05


qui sum
local N = `r(N)'
qui sum if pval < 0.05
local N_reject = `r(N)'
local pct_reject = `N_reject'/`N'*100
di "Reject in following percent of cases:"
di `pct_reject'

clear
set obs 1
gen bin = 1
gen reject = `pct_reject'
la var reject "Product Groups in Which Homoskedastic Null Rejected (\%)"
la var bin ""
la def bin 1 ""
la val bin bin
local vv1: var la reject

cd ${TERMINAL}/results/tables/
tabout bin using M6_white.tex, c(mean reject) h2(`vv0'&`vv1'\\) ///
	replace sum ptotal(none) f(`dec_list') h3(nil) ///
	style(tex) bt topf(top.tex) botf(bot.tex) ///
	topstr(White Homoskedasticity Test|0.33\textwidth) ///
	botstr(\;|tab:white)

