version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear
set more off
set type double
cd ${TERMINAL}/data


use RedoFullPostestimationV2_v5.dta, clear
*
* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001
bys product_group_code firmid panel_year quarter: egen double geoprice = gmean(price)
collapse (sum) quantity (firstnm) geoprice firmsalestotal firmpriceindex firmqualityt, by(product_group_code firmid panel_year quarter) fast
gen double quantweightedavgprice = firmsalestotal/quantity
gen double lnqweightprice = ln(quantweightedavgprice)
gen double lngeomeanprice = ln(geoprice)
gen double lnfirmsales = ln(firmsalestotal)
gen double lnfirmCESprice = ln(firmpriceindex/firmqualityt)
gen double firmpricediffqweight = lnfirmCESprice - lnqweightprice
gen double firmpricediffgeo = lnfirmCESprice - lngeomeanprice
gen double ConventionalOutput = firmsalestotal/quantweightedavgprice
gen double CESOutput = firmsalestotal/(firmpriceindex/firmqualityt)
bys product_group_code panel_year quarter: egen double totalconoutput = sum(ConventionalOutput)
by product_group_code panel_year quarter: egen double totalcesoutput = sum(CESOutput)
gen double ConventionalShare = ConventionalOutput/totalconoutput
gen double CESshare = CESOutput/totalcesoutput 
gen double lnpriceratio = ln(quantweightedavgprice/(firmpriceindex/firmqualityt))
areg lnpriceratio lnfirmsales, absorb(product_group_code)
saveold ${TERMINAL}/data/ConventionalVSRealShare_v5.dta, replace
*/

use ConventionalVSRealShare_v5, clear
twoway (scatter CESshare ConventionalShare)(function y=x, range(0 1) n(1000))(lfit CESshare ConventionalShare), ///
	scheme(s2mono)  xtitle("CES-Adjusted Real Output Share") ///
	ytitle(Conventional Real Output Share) legend(label(1 "Observations") label(2 "45 Degree Line") label(3 "Linear Fit"))
	
graph export ${TERMINAL}/results/figures/Fig2_agg_bias_qje.eps, replace
*graph export ${TERMINAL}/results/figures/Fig2_agg_bias_qje.tif, replace


