version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

set more off 
cd ${TERMINAL}/data

foreach cf in "I_B" "I_C" "II_B" "II_C" {
use counterfactual_`cf'_v7, clear

rename relativewelfare relativeCPI
rename overallwelfare oldCPI
rename overallwelfare newCPI

drop priceindexsum*
rename priceindex oldIndex
rename priceindex newIndex

collapse (mean) totalsalesquart oldIndex newIndex oldCPI newCPI relativeCPI new_totalvariablefirmprofit totalvariablefirmprofit new_firm_sales firmsalestotal, by(panel_year quarter product_group_code firmid) fast

* Sales
egen double new_std_firmsales=sd(new_firm_sales)
egen double new_mean_firmsales=mean(new_firm_sales)
gen double new_coef_var=new_std_firmsales/new_mean_firmsales

egen double old_std_firmsales=sd(firmsalestotal)
egen double old_mean_firmsales=mean(firmsalestotal)
gen double old_coef_var=old_std_firmsales/old_mean_firmsales

gen double relative_coef_var=new_coef_var/old_coef_var

* Profits
egen double new_std_firmprofit=sd(new_totalvariablefirmprofit)
egen double new_mean_firmprofit=mean(new_totalvariablefirmprofit)
gen double new_coef_var_profit=new_std_firmprofit/new_mean_firmprofit

egen double old_std_firmprofit=sd(totalvariablefirmprofit)
egen double old_mean_firmprofit=mean(totalvariablefirmprofit)
gen double old_coef_var_profit=old_std_firmprofit/old_mean_firmprofit

gen double relative_coef_var_profit=new_coef_var_profit/old_coef_var_profit

bys panel_year quarter: gen double CV=totalsalesquart*(1-(newIndex/oldIndex)) if _n==1

collapse (mean) oldCPI newCPI relativeCPI relative_coef_var relative_coef_var_profit (sum) new_totalvariablefirmprofit totalvariablefirmprofit new_firm_sales firmsalestotal CV totalsalesquart

gen relativeprofit = new_totalvariablefirmprofit/totalvariablefirmprofit
gen relativewelfare = CV+relativeprofit/firmsalestotal

tempfile `cf'
save ``cf''
}

append using `II_B', gen(ap1)
append using `I_C', gen(ap2)
append using `I_B', gen(ap3)

replace ap1=2 if ap2==1
replace ap1=3 if ap3==1
replace ap1=-ap1
drop ap2 ap3

*save qje/counterfactual_profit_table_v3, replace
*use qje/counterfactual_profit_table_v3, clear

gen relativeprofit2 = new_totalvariablefirmprofit-totalvariablefirmprofit
replace relativewelfare = (CV+relativeprofit2)/firmsalestotal


la var ap1 "Counterfactual
la def ap1 -3 "\emph{I-B:} Bertrand to Monopolistic Competition" -2 "\emph{I-C:} Cournot to Monopolistic Competition" ///
	   -1 "\emph{II-B:} Multiproduct to Single-Product Bertrand" 0 "\emph{II-C:} Multiproduct to Single-Product Cournot"
la val ap1 ap1

la var relative_coef_var "Coef.\ Var.\ Firm Sales"
la var relativeprofit "Profits"
la var relativeCPI "Consumer Price Index"
la var relativewelfare "Aggregate Welfare"

local vv1 : var la relative_coef_var
local vv2 : var la relativeCPI
local vv3 : var la relativeprofit
local vv4 : var la relativewelfare


replace relativeCPI = 1/relativeCPI

local K = 0
foreach v of varlist relative_coef_var relativeCPI {
	local ++K
	gen length= length(string(trunc(`v')))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	}
	
local dec_list "2 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)
*local over "&\multicolumn{1}{c}{Coef.\ Var.}&&\multicolumn{2}{c}{Aggregate Welfare}\\"

di "`col_format'"

cd ${TERMINAL}/results/tables

tabout ap1 using 12_counterfactual_profit_v7.tex, ///
	c(mean relative_coef_var mean relativeCPI) ///
	h2(nil) h3(&`vv1'&`vv2'\\) ///
	replace sum f(`dec_list') ptotal(none) ///
	style(tex) bt topf(top_cf_Scol.tex) botf(bot_Scol.tex) ///
	topstr(Counterfactual Exercises (Relative to Observed)|0.75\textwidth|`col_format') ///
	botstr(Each statistic is expressed as the value in the counterfactual divided by the value in the observed data.|tab:counterfactuals_profit)

! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' 12_counterfactual_profit_v7.tex
! perl -i -pe 's/\#\]\}\n//g' 12_counterfactual_profit_v7.tex


local vv1 "Coef\.\\ Var\.\\ Firm Sales"
forval i=1/`K' {
	! perl -i -pe 's/&`vv`i''/&{\\parbox{\\linewidth}{\\centering `vv`i''}}/g' 12_counterfactual_profit_v7.tex
	}


! head -40 12_counterfactual_profit_v7.tex



