version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

** Counterfactual exercises
clear
set more off
*
cd ${TERMINAL}/data
use RedoFullPostestimationV2_v5.dta
*
* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001
* use RedoFullPostestimationV2.dta, clear
 
* recalculate total sales by quarter
drop totalsalesquart
bys panel_year quarter: egen totalsalesquart = total(value)
replace sharegroupagg = groupsalestotal/totalsalesquart

* sigmaF 
gen SigmaF_up=SigmaF+1
gen SigmaF_down=SigmaF-1
* replace SigmaF SigmaF_up
* replace SigmaF SigmaF_down
*

** Cournot **
drop upcprofit lowestprofit lpv lowestprofitvalue totalvariablefirmprofit
gen double CournotElasticity = 1/((1/SigmaF)-((1/SigmaF)-1)*sharefirmgroup)
gen double CournotMarkup = (CournotElasticity/(CournotElasticity-1))-1

replace mft = CournotMarkup + 1
replace aut = price/mft
replace autshifter = aut/((1+omega)*(quantity^omega))
gen double upcprofit = ((((1+omega)*mft)-1)/((1+omega)*mft))*[(firmqualityt^(SigmaF-1))*(upcqualityt^(SigmaU-1))*(firmpriceindex^(SigmaU-SigmaF))*(price^(1-SigmaU))*groupsalestotal*(grouppriceindex^(SigmaF-1))]
bys panel_year quarter product_group_code firmid: egen double totalvariablefirmprofit = sum(upcprofit)


gen double groupCD = ln(grouppriceindex)*sharegroupagg

bys panel_year quarter product_group_code: gen double glist=_n
gen double indicatorg = 0
replace indicatorg = 1 if glist == 1

gen double groupcdtosum = groupCD*indicatorg

bys panel_year quarter: egen double priceindexsum = sum(groupcdtosum)
gen double priceindex = exp(priceindexsum)
gen double welfare_quarterly = totalsalesquart/priceindex

bys panel_year quarter: gen double qlist=_n
gen double indicatorq = 0
replace indicatorq = 1 if qlist == 1

gen double welfaretosum = welfare_quarterly*indicatorq
egen double overallwelfare = sum(welfaretosum)

*gen double mft1 = SigmaU/(SigmaU-1)
*gen double mft1 = SigmaF/(SigmaF-1)


*gen double newprice = (price/mft)*mft1

* drop all producs except the firm's largest
gsort product_group_code firmid panel_year quarter -shareprodfirm
by product_group_code firmid panel_year quarter: gen double ulist = _n
keep if ulist == 1

** compute new firm price index 
gen double newrelu = (price/upcqualityt)^(1-SigmaU)
bys panel_year quarter product_group_code firmid: egen double snrel=sum(newrelu)
gen double newfirmpriceindex = snrel^(1/(1-SigmaU))

** compute the new share of the firm within the product group g (S_f_t) 
gen double firmsharenum = (newfirmpriceindex/firmqualityt)^(1-SigmaF)
by panel_year quarter product_group_code: egen double firmsharedenom=sum(firmsharenum) 
gen double newsharefirmgroup = firmsharenum/firmsharedenom

* new perceived elasticity (epsilon_f_t)
gen double newperceivedelasticity = 1/((1/SigmaF)-((1/SigmaF)-1)*newsharefirmgroup)
* new markup (mu_f_t)
gen double mft1 = newperceivedelasticity/(newperceivedelasticity-1)

*sort panel_year quarter product_group_code
*save firmcounter.dta, replace
*collapse (firstnm) firmqualityt newfirmpriceindex SigmaF, by(panel_year quarter product_group_code firmid) fast
* collapse to firm level

** compute group price index (P_g_t) after the new firm price (P_f_t) index is computed
gen double newrel_g = (newfirmpriceindex/firmqualityt)^(1-SigmaF)

by panel_year quarter product_group_code firmid: gen double flist=_n

gen double indicator = 0
replace indicator = 1 if flist == 1

gen double firmtosum = newrel_g*indicator

*bys panel_year quarter product_group_code: egen double newrelsum_g=sum(newrel_g)
by panel_year quarter product_group_code: egen double newrelsum_g=sum(firmtosum)
gen double new_grouppriceindex = newrelsum_g^(1/(1-SigmaF))

*collapse (firstnm) new_grouppriceindex, by(panel_year quarter product_group_code ) fast
*sort panel_year quarter product_group_code 
*save groupcounter.dta, replace
* Merge in 
*use firmcounter.dta, clear
*merge m:1 panel_year quarter product_group_code  using groupcounter.dta
*drop _merge

gen double y_u_t_new=(firmqualityt^(SigmaF-1))*(upcqualityt^(SigmaU-1))*(newfirmpriceindex^(SigmaU-SigmaF))*(1/(price^SigmaU))*groupsalestotal*(new_grouppriceindex^(SigmaF-1))

gen double newprice1 = 0.1*mft1*((1+omega)*autshifter*y_u_t_new^omega)+0.9*price
*gen double newprice1 = mft1*((1+omega)*autshifter*(y_u_t_new^omega))


*** Iterate on this equilibrium until convergence is reached
local diff = 100
local j = 1
while `diff' > 0.000001 & `j' < 300 {
local j = `j' + 1
local k = `j' - 1

** compute new firm price index 
gen double newrelu`j' = (newprice`k'/upcqualityt)^(1-SigmaU)
by panel_year quarter product_group_code firmid: egen double snrel`j'=sum(newrelu`j')
gen double newfirmpriceindex`j' = snrel`j'^(1/(1-SigmaU))

** compute the new share of the firm within the product group g (S_f_t) 
gen double firmsharenum`j' = (newfirmpriceindex`j'/firmqualityt)^(1-SigmaF)
by panel_year quarter product_group_code: egen double firmsharedenom`j'=sum(firmsharenum`j') 
gen double newsharefirmgroup`j' = firmsharenum`j'/firmsharedenom`j'

* new perceived elasticity (epsilon_f_t)
gen double newperceivedelasticity`j' = 1/((1/SigmaF)-((1/SigmaF)-1)*newsharefirmgroup`j')
* new markup (mu_f_t)
replace mft1 = newperceivedelasticity`j'/(newperceivedelasticity`j'-1)


** compute group price index (P_g_t) after the new firm price (P_f_t) index is computed
gen double newrel_g`j' = (newfirmpriceindex`j'/firmqualityt)^(1-SigmaF)

gen double firmtosum`j' = newrel_g`j'*indicator

by panel_year quarter product_group_code: egen double newrelsum_g`j'=sum(firmtosum`j')
gen double new_grouppriceindex`j' = newrelsum_g`j'^(1/(1-SigmaF))

gen double y_u_t_new`j'=(firmqualityt^(SigmaF-1))*(upcqualityt^(SigmaU-1))*(newfirmpriceindex`j'^(SigmaU-SigmaF))*(1/(newprice`k'^SigmaU))*groupsalestotal*(new_grouppriceindex`j'^(SigmaF-1))

gen double newprice`j' = 0.1*mft1*((1+omega)*autshifter*(y_u_t_new`j'^omega))+0.9*newprice`k'
gen changeprice`j' = abs(newprice`j' - newprice`k')
egen diffval`j' = max(changeprice`j')
local diff = diffval`j'[1]
disp `j'
disp `diff'

drop newrelu`j' snrel`j' newrel_g`j' firmtosum`j' newrelsum_g`j' changeprice`j' diffval`j' newprice`k' firmsharenum`j' firmsharedenom`j' newperceivedelasticity`j'

if `k' > 1 {
drop new_grouppriceindex`k' y_u_t_new`k' newfirmpriceindex`k' newsharefirmgroup`k'
}

}

gen double groupCD`j' = ln(new_grouppriceindex`j')*sharegroupagg

drop indicatorg glist

bys panel_year quarter product_group_code: gen double glist=_n
gen double indicatorg = 0
replace indicatorg = 1 if glist == 1

gen double groupcdtosum`j'= groupCD`j'*indicatorg

bys panel_year quarter: egen double priceindexsum`j' = sum(groupcdtosum`j')

gen double priceindex`j' = exp(priceindexsum`j')

** ????? totalsalesquarter (isn't it data?) 
gen double welfare_quarterly`j' = totalsalesquart/priceindex`j'

drop indicatorq qlist

bys panel_year quarter: gen double qlist=_n
gen double indicatorq = 0
replace indicatorq = 1 if qlist == 1

gen double welfaretosum`j' = welfare_quarterly`j'*indicatorq
egen double overallwelfare`j' = sum(welfaretosum`j')

gen double relativewelfare = overallwelfare`j'/overallwelfare

* generate new firm sales and profits
gen double new_upc_sales=newprice`j'*y_u_t_new`j'
bys panel_year quarter product_group_code firmid: egen double new_firm_sales=sum(new_upc_sales) 

by panel_year quarter product_group_code: egen newgroupsalestotal = total(new_upc_sales)
gen double new_upcprofit = ((((1+omega)*mft1)-1)/((1+omega)*mft1))*[(firmqualityt^(SigmaF-1))*(upcqualityt^(SigmaU-1))*(newfirmpriceindex`j'^(SigmaU-SigmaF))*(newprice`j'^(1-SigmaU))*newgroupsalestotal*(new_grouppriceindex`j'^(SigmaF-1))]
by panel_year quarter product_group_code firmid: egen double new_totalvariablefirmprofit = total(new_upcprofit)

save counterfactual_II_C_v7.dta, replace


