version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

set more off
clear 
cd ${TERMINAL}/data
use size_distribution_by_Decile_final_v5.dta, clear

*egen a = rank(decile) // 10 is largest decile
egen a = rank(-decile) // 1 is largest decile
drop decile
rename a decile

sort decile
replace wavg_share = wavg_share*100
replace wtshare = wtshare*100

la var decile "Sales Decile"
la var wN "\#_Firms_in_Decile"
la var wtshare "Share_of_Value"
la var wavg_nUPC "Avg.\_\#UPCs_per_Firm"
la var wmed_nUPC "Med.\_\#UPCs_per_Firm"
la var wavg_share "Avg.\_Firm_Mkt_Share"
la var wavg_ln_sales "Mean_Firm_Sales_(Thousands)"
la var wavg_sdlnu "Avg.\_Std.\_Dev.\_UPC_Sales"

* Reduce space?
*la var decile "Decile (Largest=10)"
la var decile "Ranked Decile" // for largest = 1
la var wtshare "Decile Market Share"
la var wavg_share "Mean Firm Market Share"
la var wavg_ln_sales "Mean Log Firm Sales"
la var wavg_sdlnu "Avg. Std. Dev. log UPC Sales"
la var wavg_nUPC "Mean No. UPCs per Firm"
la var wmed_nUPC "Median No. UPCs per Firm"


local K = 0
foreach v of varlist wtshare wavg_share wavg_ln_sales wavg_sdlnu wavg_nUPC wmed_nUPC {
	local ++K
	local V: var la `v'
	*la var `v' "{\parbox{\linewidth}{\centering_`V'}}"
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	}
	
local dec_list "2 2 1 1 1 1 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"


local v0 : var la decile
local v1 : var la wtshare
local v2 : var la wavg_share
local v3 : var la wavg_ln_sales
local v4 : var la wavg_sdlnu
local v5 : var la wavg_nUPC
local v6 : var la wmed_nUPC


cd ${TERMINAL}/results/tables
keep decile wN wtshare wavg_nUPC wmed_nUPC wavg_share wavg_ln_sales wavg_sdlnu


tabout decile using 2_size_distro_decile2_Scol.tex, c(mean wtshare mean wavg_share mean wavg_ln_sales mean wavg_sdlnu mean wavg_nUPC mean wmed_nUPC) ///
	h2(`v0'&`v1'&`v2'&`v3'&`v4'&`v5'&`v6'\\) replace sum ptotal(none) h3(nil) ///
	f(`dec_list') style(tex) bt topf(top_Scol.tex) botf(bot_Scol.tex) ///
	topstr(Size Distribution by Decile|\textwidth|`col_format') ///
	botstr(Largest decile is ranked first. Weighted by product group--quarter sales. UPC counts and mean firm sales are across firm within each decile.|tab:sizedec)



	
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' 2_size_distro_decile2_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' 2_size_distro_decile2_Scol.tex

local w1 "Decile Market Share"
local w2 "Mean Firm Market Share"
local w3 "Mean Log Firm Sales"
local w4 "Avg\. Std\. Dev\. log UPC Sales"
local w5 "Mean No\. UPCs per Firm"
local w6 "Median No\. UPCs per Firm"

local ww1 "Decile Market Share"
local ww2 "Mean Firm Market Share"
local ww3 "Mean Log Firm Sales"
local ww4 "Avg.\\ Std.\\ Dev.\\ log UPC Sales"
local ww5 "Mean No.\\ UPCs per Firm"
local ww6 "Median No.\\ UPCs per Firm"

forval i=1/`K' {
	! perl -i -pe 's/`w`i''/{\\parbox{\\linewidth}{\\centering `ww`i''}}/g' 2_size_distro_decile2_Scol.tex
	}

