version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

set more off
cd ${TERMINAL}/data
use size_distribution_by_Rank_final_v5.dta, clear


*rename decile firm_rank
*sort firm_rank
*keep if firm_rank<=10

keep if decile<=10
rename decile firm_rank
la var firm_rank "Firm Rank" // for descending by size
* to sort backwards...
/*
gsort -firm_rank
replace firm_rank=_n
la var firm_rank "Firm Rank (Largest=1)"
la def firm_rank 1 "10" 2 "9" 3 "8" 4 "7" 5 "6" 6 "5" 7 "4" 8 "3" 9 "2" 10 "1"
la val firm_rank firm_rank
*/

replace wavg_share = wavg_share*100

la var wavg_share "Firm Market Share (%)"
la var wavg_ln_sales "Log Firm Sales"
la var wavg_nUPC "No. UPCs per Firm"

local K = 0
foreach v of varlist wavg_share wavg_ln_sales wavg_nUPC {
	local ++K
	local V: var la `v'
	*la var `v' "{\parbox{\linewidth}{\centering_`V'}}"
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	}
	
local dec_list "1 1 1"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"

local v0 : var la firm_rank
local v1 : var la wavg_share
local v2 : var la wavg_ln_sales
local v3 : var la wavg_nUPC

cd ${TERMINAL}/results/tables
keep firm_rank wavg_share wavg_ln_sales wavg_nUPC

tabout firm_rank using 3_size_distro_firm_rk_Scol.tex, c(mean wavg_share mean wavg_ln_sales mean wavg_nUPC) ///
	h3(nil) h2(`v0'&`v1'&`v2'&`v3'\\) replace sum f(`dec_lsit') ptotal(none) ///
	style(tex) bt topf(top_Scol.tex) botf(bot_Scol.tex) ///
	topstr(Size Distribution by Firm Rank|\textwidth|`col_format') ///
	botstr(Largest firm is ranked first. Weighted by product group--quarter sales.|tab:sizerank)


! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' 3_size_distro_firm_rk_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' 3_size_distro_firm_rk_Scol.tex



la var wavg_share "Firm Market Share (%)"
la var wavg_ln_sales "Log Firm Sales"
la var wavg_nUPC "No. UPCs per Firm"

local w1 "Firm Market Share \(%\)"
local w2 "Log Firm Sales"
local w3 "No\. UPCs per Firm"

local ww1 "Firm Market Share (\\%)"
local ww2 "Log Firm Sales"
local ww3 "No.\\ UPCs per Firm"

forval i=1/`K' {
	! perl -i -pe 's/`w`i''/{\\parbox{\\linewidth}{\\centering\\strut `ww`i''}}/g' 3_size_distro_firm_rk_Scol.tex
	}


