version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

set more off
cd ${TERMINAL}/results/
use NewGMMresultsV2_test.dta, clear
gen sig_diff = sigu-sigf
pctile su = sigu,nq(100)
pctile sf = sigf,nq(100)
pctile sdiff = sig_diff,nq(100)
pctile p_omega = omega,nq(100)
keep if su!=.

gen ptile = _n
gsort -ptile
gen ranked_ptile = _n

keep if ranked_ptile==1|ranked_ptile==5|ranked_ptile==10|ranked_ptile==25|ranked_ptile==50|ranked_ptile==75|ranked_ptile==90|ranked_ptile==95|ranked_ptile==99

la var ranked_ptile "Ranked Percentile"
la var su "$\sigma^U_g$"
la var sf "$\sigma^F_g$"
la var sdiff "$\sigma^U_g-\sigma^F_g$"
la var p_omega "$\delta_g$"

local K = 0
foreach v in su sf sdiff p_omega {
	local ++K
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	di "`v`K''"
	}

local dec_list "1 1 1 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"

local v0 : var la ranked_ptile
local v1 : var la su
local v2 : var la sf
local v3 : var la sdiff
local v4 : var la p_omega

cd  tables
tabout ranked_ptile using 5_gmm_distro_Scol.tex, c(mean su mean sf mean sdiff mean p_omega) h2(nil) ///
	h3(`v0'&`v1'&`v2'&`v3'&`v4'\\) replace sum ptotal(none) f(`dec_list') ///
	style(tex) bt topf(top_Scol.tex) botf(bot_Scol_gmm.tex) ///
	topstr(Distribution of 100 GMM Estimates|.75\textwidth|`col_format') ///
	botstr(Percentiles are decreasing: largest estimate is ranked first.|tab:elasticityest)
	

! perl -i -pe 's/\\&/\&/g' 5_gmm_distro_Scol.tex
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' 5_gmm_distro_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' 5_gmm_distro_Scol.tex



local w1 "\\\$\\sigma\^U_g\\\$"
local w2 "\\\$\\sigma\^F_g\\\$"
local w3 "\\\$\\sigma\^U_g-\\sigma\^F_g\\\$"
local w4 "\\\$\\delta_g\\\$"

local ww1 "\\\$\\sigma\^U_g\\\$"
local ww2 "\\\$\\sigma\^F_g\\\$"
local ww3 "\\\$\\sigma\^U_g-\\sigma\^F_g\\\$"
local ww4 "\\\$\\delta_g\\\$"


forval i=1/`K' {
	! perl -i -pe 's/`w`i''(\&|\\)/{\\parbox{\\linewidth}{\\centering `ww`i''}}\1/g' 5_gmm_distro_Scol.tex
	}


! head -50 5_gmm_distro_Scol.tex

