version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

set more off
cd ${TERMINAL}
use data/markups_cannib_all_firms_v5, clear

pctile cm=c_mu,nq(100)
pctile bm=b_mu_epsilonF,nq(100)
pctile sigfm=b_mu_sigmaF,nq(100)
pctile sigum=b_mu_sigmaU,nq(100)

keep if cm!=.

gen ptile = _n
gsort -ptile
gen ranked_ptile = _n

keep if ranked_ptile==10|ranked_ptile==25|ranked_ptile==50|ranked_ptile==75|ranked_ptile==90

la var ranked_ptile "Ranked Percentile"
/*la var cm "Cournot Using $\varepsilon^F$"
la var bm "Bertrand Using $\varepsilon^F$"
la var sigfm "Using $\sigma^F$"
la var sigum "Using $\sigma^U$"
*/

la var cm "Cournot"
la var bm "Bertrand"
la var sigfm "Monopolistic Competition (\$\sigma^F_g\$)"
la var sigum "Monopolistic Competition (\$\sigma^U_g\$)"

local K = 0
foreach v in cm bm sigfm sigum {
	local ++K
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	di "`v`K''"
	}

local dec_list "2 2 2 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"



local v0 : var la ranked_ptile
local v1 : var la cm
local v2 : var la bm
local v3 : var la sigfm
local v4 : var la sigum

cd results/tables

tabout ranked_ptile using 8_markup_distro_Scol.tex, c(mean cm mean bm mean sigfm mean sigum) h2(nil) ///
	h3(`v0'&`v1'&`v2'&`v3'&`v4'\\) replace sum ptotal(none) f(2 2 2 2) ///
	style(tex) bt topf(top_Scol.tex) botf(bot_Scol_markup_distro.tex) ///
	topstr(Distribution of Markups|0.9\textwidth|`col_format') ///
	botstr(Percentiles are decreasing: largest is ranked first. Markup=(Price-Marginal Cost)/Marginal Cost.|tab:markups)
	


! perl -i -pe 's/\\&/\&/g' 8_markup_distro_Scol.tex
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' 8_markup_distro_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' 8_markup_distro_Scol.tex

/*
local w1 "Cournot Using \\\$\\varepsilon\^F\\\$"
local w2 "Bertrand Using \\\$\\varepsilon\^F\\\$"
local w3 "Using \\\$\\sigma\^F\\\$"
local w4 "Using \\\$\\sigma\^U\\\$"

local ww1 "Cournot Using \\\$\\varepsilon^F\\\$"
local ww2 "Bertrand Using \\\$\\varepsilon^F\\\$"
local ww3 "Using \\\$\\sigma^F\\\$"
local ww4 "Using \\\$\\sigma^U\\\$"
*/


local w1 "Cournot"
local w2 "Bertrand"
local w3 "Monopolistic Competition \(\\\$\\sigma\^F_g\\\$\)"
local w4 "Monopolistic Competition \(\\\$\\sigma\^U_g\\\$\)"

local ww1 "Cournot"
local ww2 "Bertrand"
local ww3 "Monopolistic Competition (\\\$\\sigma\^F_g\\\$)"
local ww4 "Monopolistic Competition (\\\$\\sigma\^U_g\\\$)"


forval i=1/`K' {
	local ww`i' "`w`i''"
	! perl -i -pe 's/`w`i''(\&|\\)/{\\parbox{\\linewidth}{\\centering `ww`i''}}\1/g' 8_markup_distro_Scol.tex
	}
! perl -i -pe 's/(sigma\^[FU]_g)\)\}/\\$\\\1\\$)}/g' 8_markup_distro_Scol.tex
! head -20 8_markup_distro_Scol.tex

