version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear
set more off
set type double
cd ${TERMINAL}/data
use RedoFullPostestimationV2_v5.dta, clear
*
* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001
*
* perturbe sigmaF by one st.dev. up (sigmaF_up) and one st. dev. down (sigmaF_down)
egen sigmaF_sd=sd(SigmaF)
*gen sigmaF_up=SigmaF+sigmaF_sd
*gen sigmaF_down=SigmaF-sigmaF_sd
gen sigmaF_up=SigmaF+10
gen sigmaF_down=SigmaF-10
*** perturbe by 1 only 
* Cournot elasticity (c_epsilon) and Cournot markup (c_mu)
gen c_epsilon = 1/((1/SigmaF)-((1/SigmaF)-1)*sharefirmgroup)
gen c_epsilon_up = 1/((1/sigmaF_up)-((1/sigmaF_up)-1)*sharefirmgroup)
gen c_epsilon_down = 1/((1/sigmaF_down)-((1/sigmaF_down)-1)*sharefirmgroup)
gen c_mu = (c_epsilon/(c_epsilon-1))-1
gen c_mu_up = (c_epsilon_up/(c_epsilon_up-1))-1
gen c_mu_down = (c_epsilon_down/(c_epsilon_down-1))-1
* Bertrand markup (b_mu) using sigmaF
gen b_mu_sigmaF = (SigmaF/(SigmaF-1))-1
gen b_mu_sigmaF_up = (sigmaF_up/(sigmaF_up-1))-1
gen b_mu_sigmaF_down = (sigmaF_down/(sigmaF_down-1))-1
* Bertrand markup (b_mu) using sigmaU
gen b_mu_sigmaU = (SigmaU/(SigmaU-1))-1
* Bertrand markup (b_mu) using epsilonF
gen epsilonF=SigmaF-(SigmaF-1)*sharefirmgroup
gen epsilonF_up=sigmaF_up-(sigmaF_up-1)*sharefirmgroup
gen epsilonF_down=sigmaF_down-(sigmaF_down-1)*sharefirmgroup
gen b_mu_epsilonF=(epsilonF/(epsilonF-1))-1
gen b_mu_epsilonF_up=(epsilonF_up/(epsilonF_up-1))-1
gen b_mu_epsilonF_down=(epsilonF_down/(epsilonF_down-1))-1
** Distribution of the perturbed markups: 
* Compute within product group - firm averages across year - quarter and get the percentiles 
preserve 
collapse (mean) SigmaF sigmaF_up sigmaF_down c_epsilon c_epsilon_up c_epsilon_down c_mu c_mu_up c_mu_down b_mu_sigmaU b_mu_sigmaF b_mu_sigmaF_up b_mu_sigmaF_down epsilonF epsilonF_up epsilonF_down b_mu_epsilonF b_mu_epsilonF_up  b_mu_epsilonF_down, by(product_group_code firmid) fast
sum b_mu_sigmaU SigmaF sigmaF_up sigmaF_down c_epsilon c_epsilon_up c_epsilon_down c_mu c_mu_up c_mu_down b_mu_sigmaF b_mu_sigmaF_up b_mu_sigmaF_down epsilonF epsilonF_up epsilonF_down b_mu_epsilonF b_mu_epsilonF_up  b_mu_epsilonF_down, d
restore 
** Distribution of the perturbed markups relative to the Product Group Average markup 
bys panel_year quarter product_group_code firmid: egen firm_sales=sum(value)
collapse (mean) firm_sales c_mu c_mu_up c_mu_down b_mu_sigmaF b_mu_sigmaF_up b_mu_sigmaF_down b_mu_sigmaU b_mu_epsilonF b_mu_epsilonF_up b_mu_epsilonF_down, by(product_group_code firmid) fast
bys product_group_code: egen max_firm_sales=max(firm_sales)
foreach X in c_mu c_mu_up c_mu_down b_mu_sigmaF b_mu_sigmaF_up b_mu_sigmaF_down b_mu_sigmaU b_mu_epsilonF b_mu_epsilonF_up b_mu_epsilonF_down{
bys product_group_code: egen avg_`X'=mean(`X')
}
foreach X in c_mu b_mu_sigmaF b_mu_sigmaU b_mu_epsilonF b_mu_epsilonF_up b_mu_epsilonF_down{
gen norm_`X'= `X'/avg_`X'
}
save markups_cannib_all_firms_v5, replace
* markup distribution largest firm 
preserve 
keep if firm_sales==max_firm_sales
sum norm_c_mu norm_b_mu_sigmaF norm_b_mu_sigmaU norm_b_mu_epsilonF, d
restore 
* markup distribution 2nd largest firm 
preserve 
drop if firm_sales==max_firm_sales
bys product_group_code: egen max_firm_sales2=max(firm_sales)
keep if firm_sales==max_firm_sales2
sum norm_c_mu norm_b_mu_sigmaF norm_b_mu_sigmaU norm_b_mu_epsilonF, d
restore 
