version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

* ************************
* This code tests the robustness of different nesting structures as follows: 
* (i) it estimates equations: 
* 
* where: g - product group code; f - firm; bm - brand module; u - upc; t - time; s - share; p - price 
* 
* (ii) it saves the R^2 from each regression and compute the averages of these R^2
* ************************
clear
set more off
set type double
cd ${TERMINAL}/data
use RedoFullPostestimationV2_v5.dta, clear
*
* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001
*
sort panel_year quarter product_module_code product_group_code brand_code_uc firmid upc
keep panel_year quarter product_module_code product_group_code brand_code_uc firmid upc value price
save nest_test_v5.dta, replace 
*** Nesting I (Benchmark): Product group - Firm - UPC 
** generate variables 
* generate the UPC shares (s_g_f_u_t), firm share (s_g_f_t) and their logs 
bys panel_year quarter product_group_code firmid: egen sales_g_f_t = sum(value) 
bys panel_year quarter product_group_code firmid: egen n_g_f_t=count(upc)  
gen ln_n_g_f_t=log(n_g_f_t)
gen s_g_f_u_t = value/sales_g_f_t
gen ln_s_g_f_u_t=log(s_g_f_u_t)
bys panel_year quarter product_group_code: egen sales_g_t = sum(value) 
gen s_g_f_t = sales_g_f_t/sales_g_t
gen ln_s_g_f_t=log(s_g_f_t)
gen p_g_f_u_t=price 
gen ln_p_g_f_u_t=log(p_g_f_u_t)
* the geometric average of UPC prices (geo_p_g_f_t) and UPC shares (geo_s_g_f_t) for each firm
bys panel_year quarter product_group_code firmid: egen mean_s_g_f_u_t = mean(s_g_f_u_t)
gen geo_s_g_f_t = exp(mean_s_g_f_u_t)
gen norm_s_g_f_u_t=s_g_f_u_t/geo_s_g_f_t
gen norm_s_g_f_u_t2=s_g_f_u_t/(geo_s_g_f_t*n_g_f_t)
bys panel_year quarter product_group_code firmid: egen sum_norm_s_g_f_u_t = sum(norm_s_g_f_u_t)
bys panel_year quarter product_group_code firmid: egen sum_norm_s_g_f_u_t2 = sum(norm_s_g_f_u_t2)
gen ln_sum_norm_s_g_f_u_t=log(sum_norm_s_g_f_u_t)
gen ln_sum_norm_s_g_f_u_t2=log(sum_norm_s_g_f_u_t2)
bys panel_year quarter product_group_code firmid: egen mean_p_g_f_u_t = mean(p_g_f_u_t)
gen geo_p_g_f_t = exp(mean_p_g_f_u_t)
gen ln_geo_p_g_f_t=log(geo_p_g_f_t)
egen prod_gr=group(product_group_code) 
egen time=group(panel_year quarter)
egen firm_time=group(firmid panel_year quarter)
save nest_test.dta, replace 
** run regressions
* nest 2 
preserve 
matrix R2_1_N2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test.dta, clear 
keep if prod_gr==`X'
qui areg ln_s_g_f_u_t ln_p_g_f_u_t if prod_gr==`X', absorb(firm_time)
qui predict ft_fe_`X',d
qui gen dem_ln_s_g_f_u_t_`X'=ln_s_g_f_u_t-ft_fe_`X'
qui reg dem_ln_s_g_f_u_t_`X' ln_p_g_f_u_t
matrix R2_1_N2[`X',1]=e(r2)
}
svmat float R2_1_N2
keep R2_1_N2
drop if R2_1_N2==.
gen pg=_n
save R2_1_N2.dta, replace 
sum
restore
* nest 1 
preserve 
collapse (firstnm) ln_s_g_f_t ln_geo_p_g_f_t ln_sum_norm_s_g_f_u_t ln_sum_norm_s_g_f_u_t2 ln_n_g_f_t, by(panel_year quarter product_group_code firmid)
egen prod_gr=group(product_group_code)
egen time=group(panel_year quarter) 
save nest_test_coll.dta, replace  
* with both price and sum of share normalized by geo mean share 
matrix R2_1_N1_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_f_t ln_geo_p_g_f_t ln_sum_norm_s_g_f_u_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_f_t=ln_s_g_f_t-t_fe_`X'
reg dem_ln_s_g_f_t ln_geo_p_g_f_t ln_sum_norm_s_g_f_u_t
matrix R2_1_N1_3[`X',1]=e(r2)
}
svmat float R2_1_N1_3
keep R2_1_N1_3
drop if R2_1_N1_3==.
gen pg=_n
save R2_1_N1_3.dta, replace 
sum 
* with price and sum of shares normalized by geo mean share and number of products 
matrix R2_1_N1_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_f_t ln_geo_p_g_f_t ln_sum_norm_s_g_f_u_t2, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_f_t=ln_s_g_f_t-t_fe_`X'
reg dem_ln_s_g_f_t ln_geo_p_g_f_t ln_sum_norm_s_g_f_u_t2
matrix R2_1_N1_2[`X',1]=e(r2)
}
svmat float R2_1_N1_2
keep R2_1_N1_2
drop if R2_1_N1_2==.
gen pg=_n
save R2_1_N1_2.dta, replace
sum 
* with price and sum of shares normalized by geo mean share and number of products 
matrix R2_1_N1_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_f_t ln_geo_p_g_f_t ln_sum_norm_s_g_f_u_t2 ln_n_g_f_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_f_t=ln_s_g_f_t-t_fe_`X'
reg dem_ln_s_g_f_t ln_geo_p_g_f_t ln_sum_norm_s_g_f_u_t2 ln_n_g_f_t
matrix R2_1_N1_4[`X',1]=e(r2)
}
svmat float R2_1_N1_4
keep R2_1_N1_4
drop if R2_1_N1_4==.
gen pg=_n
save R2_1_N1_4.dta, replace
sum 
* without sum of normalized share
matrix R2_1_N1_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_f_t ln_geo_p_g_f_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_f_t=ln_s_g_f_t-t_fe_`X'
reg dem_ln_s_g_f_t ln_geo_p_g_f_t
matrix R2_1_N1_1[`X',1]=e(r2)
}
svmat float R2_1_N1_1
keep R2_1_N1_1
drop if R2_1_N1_1==.
gen pg=_n
save R2_1_N1_1.dta, replace 
sum
restore 
* ---------------------------------------------
*** Nesting II Product group - Module - UPC 
sort panel_year quarter product_group_code product_module_code upc
** generate variables 
* generate the UPC shares (s_g_m_u_t), module share (s_g_m_t) and their logs 
bys panel_year quarter product_group_code product_module_code: egen sales_g_m_t = sum(value) 
bys panel_year quarter product_group_code product_module_code: egen n_g_m_t=count(upc)
gen ln_n_g_m_t=log(n_g_m_t)
gen s_g_m_u_t = value/sales_g_m_t
gen ln_s_g_m_u_t=log(s_g_m_u_t)
gen s_g_m_t = sales_g_m_t/sales_g_t
gen ln_s_g_m_t=log(s_g_m_t)
gen p_g_m_u_t=price 
gen ln_p_g_m_u_t=log(p_g_m_u_t)
* the geometric average of UPC prices (geo_p_g_m_t) and UPC shares (geo_s_g_m_t) for each module
bys panel_year quarter product_group_code product_module_code: egen mean_s_g_m_u_t = mean(s_g_m_u_t)
gen geo_s_g_m_t = exp(mean_s_g_m_u_t)
gen norm_s_g_m_u_t=s_g_m_u_t/geo_s_g_m_t
gen norm_s_g_m_u_t2=s_g_m_u_t/(geo_s_g_m_t*n_g_m_t)
bys panel_year quarter product_group_code product_module_code: egen sum_norm_s_g_m_u_t = sum(norm_s_g_m_u_t)
bys panel_year quarter product_group_code product_module_code: egen sum_norm_s_g_m_u_t2 = sum(norm_s_g_m_u_t2)
gen ln_sum_norm_s_g_m_u_t=log(sum_norm_s_g_m_u_t)
gen ln_sum_norm_s_g_m_u_t2=log(sum_norm_s_g_m_u_t2)
bys panel_year quarter product_group_code product_module_code: egen mean_p_g_m_u_t = mean(p_g_m_u_t)
gen geo_p_g_m_t = exp(mean_p_g_m_u_t)
gen ln_geo_p_g_m_t=log(geo_p_g_m_t)
egen module_time=group(product_module_code panel_year quarter)
save nest_test.dta, replace
** run regressions
* Nest 2: upc 
preserve 
matrix R2_2_N2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_u_t ln_p_g_m_u_t, absorb(module_time)
predict mt_fe_`X',d
gen dem_ln_s_g_m_u_t_`X'=ln_s_g_m_u_t-mt_fe_`X'
reg dem_ln_s_g_m_u_t_`X' ln_p_g_m_u_t
matrix R2_2_N2[`X',1]=e(r2)
}
svmat float R2_2_N2
keep R2_2_N2
drop if R2_2_N2==.
gen pg=_n
save R2_2_N2.dta, replace 
sum
restore
* nest 1: module 
preserve 
collapse (firstnm) ln_s_g_m_t ln_geo_p_g_m_t ln_sum_norm_s_g_m_u_t ln_sum_norm_s_g_m_u_t2 ln_n_g_m_t, by(panel_year quarter product_group_code product_module_code)
egen prod_gr=group(product_group_code)
egen time=group(panel_year quarter) 
save nest_test_coll.dta, replace  
* with both price and sum of share normalized by geo mean share 
matrix R2_2_N1_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_p_g_m_t ln_sum_norm_s_g_m_u_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t ln_geo_p_g_m_t ln_sum_norm_s_g_m_u_t
matrix R2_2_N1_3[`X',1]=e(r2)
}
svmat float R2_2_N1_3
keep R2_2_N1_3
drop if R2_2_N1_3==.
gen pg=_n
save R2_2_N1_3.dta, replace
sum
* with price and sum of shares normalized by geo mean share and number of products 
matrix R2_2_N1_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_p_g_m_t ln_sum_norm_s_g_m_u_t2, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t ln_geo_p_g_m_t ln_sum_norm_s_g_m_u_t2
matrix R2_2_N1_2[`X',1]=e(r2)
}
svmat float R2_2_N1_2
keep R2_2_N1_2
drop if R2_2_N1_2==.
gen pg=_n
save R2_2_N1_2.dta, replace
sum
* with price and sum of shares normalized by geo mean share and number of products 
matrix R2_2_N1_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_p_g_m_t ln_sum_norm_s_g_m_u_t2 ln_n_g_m_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t ln_geo_p_g_m_t ln_sum_norm_s_g_m_u_t2 ln_n_g_m_t
matrix R2_2_N1_4[`X',1]=e(r2)
}
svmat float R2_2_N1_4
keep R2_2_N1_4
save R2_2_N1_4.dta, replace
sum
* without sum of normalized share
matrix R2_2_N1_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_p_g_m_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' ln_geo_p_g_m_t
matrix R2_2_N1_1[`X',1]=e(r2)
}
svmat float R2_2_N1_1
keep R2_2_N1_1
drop if R2_2_N1_1==.
gen pg=_n
save R2_2_N1_1.dta, replace 
sum
restore 
* ----- 
*** Nesting III Product group - BrandModule - UPC 
sort panel_year quarter product_group_code product_module_code brand_code_uc upc
egen brand_module=group(product_module_code brand_code_uc)
** generate variables 
* generate the UPC shares (s_g_bm_u_t), brand - module share (s_g_bm_t) and their logs 
bys panel_year quarter product_group_code brand_module: egen sales_g_bm_t = sum(value) 
bys panel_year quarter product_group_code brand_module: egen n_g_bm_t = count(upc) 
gen ln_n_g_bm_t=log(n_g_bm_t)
gen s_g_bm_u_t = value/sales_g_bm_t
gen ln_s_g_bm_u_t=log(s_g_bm_u_t)
gen s_g_bm_t = sales_g_bm_t/sales_g_t
gen ln_s_g_bm_t=log(s_g_bm_t)
gen p_g_bm_u_t=price 
gen ln_p_g_bm_u_t=log(p_g_bm_u_t)
* the geometric average of UPC prices (geo_p_g_bm_t) and UPC shares (geo_s_g_bm_t) for each brand-module
bys panel_year quarter product_group_code brand_module: egen mean_s_g_bm_u_t = mean(s_g_bm_u_t)
gen geo_s_g_bm_t = exp(mean_s_g_bm_u_t)
gen norm_s_g_bm_u_t=s_g_bm_u_t/geo_s_g_bm_t
gen norm_s_g_bm_u_t2=s_g_bm_u_t/(geo_s_g_bm_t*n_g_bm_t)
bys panel_year quarter product_group_code brand_module: egen sum_norm_s_g_bm_u_t = sum(norm_s_g_bm_u_t)
bys panel_year quarter product_group_code brand_module: egen sum_norm_s_g_bm_u_t2 = sum(norm_s_g_bm_u_t2)
gen ln_sum_norm_s_g_bm_u_t=log(sum_norm_s_g_bm_u_t)
gen ln_sum_norm_s_g_bm_u_t2=log(sum_norm_s_g_bm_u_t2)
bys panel_year quarter product_group_code brand_module: egen mean_p_g_bm_u_t = mean(p_g_bm_u_t)
gen geo_p_g_bm_t = exp(mean_p_g_bm_u_t)
gen ln_geo_p_g_bm_t=log(geo_p_g_bm_t)
egen brand_module_time=group(brand_module panel_year quarter)
save nest_test.dta, replace 
** run regressions
* Nest 2: upc 
preserve 
matrix R2_3_N2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_bm_u_t ln_p_g_bm_u_t, absorb(brand_module_time)
predict bmt_fe_`X',d
gen dem_ln_s_g_bm_u_t_`X'=ln_s_g_bm_u_t-bmt_fe_`X'
reg dem_ln_s_g_bm_u_t_`X' ln_p_g_bm_u_t
matrix R2_3_N2[`X',1]=e(r2)
}
svmat float R2_3_N2
keep R2_3_N2
drop if R2_3_N2==.
gen pg=_n
save R2_3_N2.dta, replace 
sum
restore
* nest 1: BrandModule 
preserve 
collapse (firstnm) ln_s_g_bm_t ln_geo_p_g_bm_t ln_sum_norm_s_g_bm_u_t ln_sum_norm_s_g_bm_u_t2 ln_n_g_bm_t, by(panel_year quarter product_group_code brand_module)
egen prod_gr=group(product_group_code)
egen time=group(panel_year quarter) 
save nest_test_coll.dta, replace 
* with both price and sum of share normalized by geo mean share  
matrix R2_3_N1_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_bm_t ln_geo_p_g_bm_t ln_sum_norm_s_g_bm_u_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_bm_t=ln_s_g_bm_t-t_fe_`X'
reg dem_ln_s_g_bm_t ln_geo_p_g_bm_t ln_sum_norm_s_g_bm_u_t
matrix R2_3_N1_3[`X',1]=e(r2)
}
svmat float R2_3_N1_3
keep R2_3_N1_3
drop if R2_3_N1_3==.
gen pg=_n
save R2_3_N1_3.dta, replace 
sum 
* with price and sum of shares normalized by geo mean share and number of products 
matrix R2_3_N1_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_bm_t ln_geo_p_g_bm_t ln_sum_norm_s_g_bm_u_t2, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_bm_t=ln_s_g_bm_t-t_fe_`X'
reg dem_ln_s_g_bm_t ln_geo_p_g_bm_t ln_sum_norm_s_g_bm_u_t2
matrix R2_3_N1_2[`X',1]=e(r2)
}
svmat float R2_3_N1_2
keep R2_3_N1_2
drop if R2_3_N1_2==.
gen pg=_n
save R2_3_N1_2.dta, replace 
sum 
* with price and sum of shares normalized by geo mean share and number of products 
matrix R2_3_N1_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_bm_t ln_geo_p_g_bm_t ln_sum_norm_s_g_bm_u_t2 ln_n_g_bm_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_bm_t=ln_s_g_bm_t-t_fe_`X'
reg dem_ln_s_g_bm_t ln_geo_p_g_bm_t ln_sum_norm_s_g_bm_u_t2 ln_n_g_bm_t
matrix R2_3_N1_4[`X',1]=e(r2)
}
svmat float R2_3_N1_4
keep R2_3_N1_4
drop if R2_3_N1_4==.
gen pg=_n
save R2_3_N1_4.dta, replace 
sum 
* without sum of normalized share
matrix R2_3_N1_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_bm_t ln_geo_p_g_bm_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_bm_t=ln_s_g_bm_t-t_fe_`X'
reg dem_ln_s_g_bm_t ln_geo_p_g_bm_t
matrix R2_3_N1_1[`X',1]=e(r2)
}
svmat float R2_3_N1_1
keep R2_3_N1_1
drop if R2_3_N1_1==.
gen pg=_n
save R2_3_N1_1.dta, replace 
sum
restore
* ----- 
*** Nesting IV: Product group - FirmModule - UPC 
sort panel_year quarter product_group_code product_module_code firmid upc
egen firm_module=group(product_module_code firmid)
** generate variables 
* generate the UPC shares (s_g_fm_u_t), firm - module share (s_g_fm_t) and their logs 
bys panel_year quarter product_group_code firm_module: egen sales_g_fm_t = sum(value) 
bys panel_year quarter product_group_code firm_module: egen n_g_fm_t = count(upc)
gen ln_n_g_fm_t=log(n_g_fm_t)
gen s_g_fm_u_t = value/sales_g_fm_t
gen ln_s_g_fm_u_t=log(s_g_fm_u_t)
gen s_g_fm_t = sales_g_fm_t/sales_g_t
gen ln_s_g_fm_t=log(s_g_fm_t)
gen p_g_fm_u_t=price 
gen ln_p_g_fm_u_t=log(p_g_fm_u_t)
* the geometric average of UPC prices (geo_p_g_fm_t) and UPC shares (geo_s_g_fm_t) for each firm - module
bys panel_year quarter product_group_code firm_module: egen mean_s_g_fm_u_t = mean(s_g_fm_u_t)
gen geo_s_g_fm_t = exp(mean_s_g_fm_u_t)
gen norm_s_g_fm_u_t=s_g_fm_u_t/geo_s_g_fm_t
gen norm_s_g_fm_u_t2=s_g_fm_u_t/(geo_s_g_fm_t*n_g_fm_t)
bys panel_year quarter product_group_code firm_module: egen sum_norm_s_g_fm_u_t = sum(norm_s_g_fm_u_t)
bys panel_year quarter product_group_code firm_module: egen sum_norm_s_g_fm_u_t2 = sum(norm_s_g_fm_u_t2)
gen ln_sum_norm_s_g_fm_u_t=log(sum_norm_s_g_fm_u_t)
gen ln_sum_norm_s_g_fm_u_t2=log(sum_norm_s_g_fm_u_t2)
bys panel_year quarter product_group_code firm_module: egen mean_p_g_fm_u_t = mean(p_g_fm_u_t)
gen geo_p_g_fm_t = exp(mean_p_g_fm_u_t)
gen ln_geo_p_g_fm_t=log(geo_p_g_fm_t)
egen firm_module_time=group(firm_module panel_year quarter)
save nest_test.dta, replace 
** run regressions
* Nest 2: upc 
preserve 
matrix R2_4_N2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_fm_u_t ln_p_g_fm_u_t, absorb(firm_module_time)
predict fmt_fe_`X',d
gen dem_ln_s_g_fm_u_t_`X'=ln_s_g_fm_u_t-fmt_fe_`X'
reg dem_ln_s_g_fm_u_t_`X' ln_p_g_fm_u_t
matrix R2_4_N2[`X',1]=e(r2)
}
svmat float R2_4_N2
keep R2_4_N2
drop if R2_4_N2==.
gen pg=_n
save R2_4_N2.dta, replace 
sum
restore
* nest 1: FirmModule 
preserve 
collapse (firstnm) ln_s_g_fm_t ln_geo_p_g_fm_t ln_sum_norm_s_g_fm_u_t ln_sum_norm_s_g_fm_u_t2 ln_n_g_fm_t, by(panel_year quarter product_group_code firm_module)
egen prod_gr=group(product_group_code)
egen time=group(panel_year quarter) 
save nest_test_coll.dta, replace  
matrix R2_4_N1_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_fm_t ln_geo_p_g_fm_t ln_sum_norm_s_g_fm_u_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_fm_t=ln_s_g_fm_t-t_fe_`X'
reg dem_ln_s_g_fm_t ln_geo_p_g_fm_t ln_sum_norm_s_g_fm_u_t
matrix R2_4_N1_3[`X',1]=e(r2)
}
svmat float R2_4_N1_3
keep R2_4_N1_3
drop if R2_4_N1_3==.
gen pg=_n
save R2_4_N1_3.dta, replace 
sum
*
matrix R2_4_N1_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_fm_t ln_geo_p_g_fm_t ln_sum_norm_s_g_fm_u_t2, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_fm_t=ln_s_g_fm_t-t_fe_`X'
reg dem_ln_s_g_fm_t ln_geo_p_g_fm_t ln_sum_norm_s_g_fm_u_t2
matrix R2_4_N1_2[`X',1]=e(r2)
}
svmat float R2_4_N1_2
keep R2_4_N1_2
drop if R2_4_N1_2==.
gen pg=_n
save R2_4_N1_2.dta, replace
sum
*
matrix R2_4_N1_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_fm_t ln_geo_p_g_fm_t ln_sum_norm_s_g_fm_u_t2 ln_n_g_fm_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_fm_t=ln_s_g_fm_t-t_fe_`X'
reg dem_ln_s_g_fm_t ln_geo_p_g_fm_t ln_sum_norm_s_g_fm_u_t2 ln_n_g_fm_t
matrix R2_4_N1_4[`X',1]=e(r2)
}
svmat float R2_4_N1_4
keep R2_4_N1_4
drop if R2_4_N1_4==.
gen pg=_n
save R2_4_N1_4.dta, replace
sum
* without sum of normalized share
matrix R2_4_N1_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_fm_t ln_geo_p_g_fm_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_fm_t=ln_s_g_fm_t-t_fe_`X'
reg dem_ln_s_g_fm_t ln_geo_p_g_fm_t
matrix R2_4_N1_1[`X',1]=e(r2)
}
svmat float R2_4_N1_1
keep R2_4_N1_1
drop if R2_4_N1_1==.
gen pg=_n
save R2_4_N1_1.dta, replace 
sum
restore
* ------------------------------------
*** Nesting V: Product group - Module - BrandModule - UPC 
sort panel_year quarter product_group_code product_module_code brand_module upc
** generate variables 
* generate the UPC shares (s_g_m_bm_u_t), module - brandModule share (s_g_m_bm_t), module share (s_g_m_t) and their logs 
bys panel_year quarter product_group_code product_module_code brand_module: egen sales_g_m_bm_t = sum(value) 
bys panel_year quarter product_group_code product_module_code brand_module: egen n_g_m_bm_t = count(upc) 
gen ln_n_g_m_bm_t=log(n_g_m_bm_t)
gen s_g_m_bm_u_t = value/sales_g_m_bm_t
gen ln_s_g_m_bm_u_t=log(s_g_m_bm_u_t)
gen s_g_m_bm_t=sales_g_m_bm_t/sales_g_m_t
gen ln_s_g_m_bm_t=log(s_g_m_bm_t)
gen p_g_m_bm_u_t=price 
gen ln_p_g_m_bm_u_t=log(p_g_m_bm_u_t)
* the geometric average of UPC prices (geo_p_g_m_bm_t), brandModule prices (geo_p_g_m_t), UPC shares (geo_s_g_m_bm_t), brandModule shares (geo_s_g_m_t) and Module sahres (geo_s_g_t for each brand-module
bys panel_year quarter product_group_code product_module_code brand_module: egen mean_s_g_m_bm_u_t = mean(s_g_m_bm_u_t)
gen geo_s_g_m_bm_u_t = exp(mean_s_g_m_bm_u_t)
gen norm_s_g_m_bm_u_t=s_g_m_bm_u_t/geo_s_g_m_bm_u_t
gen norm_s_g_m_bm_u_t2=s_g_m_bm_u_t/(geo_s_g_m_bm_u_t*n_g_m_bm_t)
bys panel_year quarter product_group_code product_module_code brand_module: egen sum_norm_s_g_m_bm_u_t = sum(norm_s_g_m_bm_u_t)
gen ln_sum_norm_s_g_m_bm_u_t=log(sum_norm_s_g_m_bm_u_t)
bys panel_year quarter product_group_code product_module_code brand_module: egen sum_norm_s_g_m_bm_u_t2 = sum(norm_s_g_m_bm_u_t2)
gen ln_sum_norm_s_g_m_bm_u_t2=log(sum_norm_s_g_m_bm_u_t2)
*
bys panel_year quarter product_group_code product_module_code: egen mean_ln_sum_norm_s_g_m_bm_u_t=mean(ln_sum_norm_s_g_m_bm_u_t)
gen geo_ln_sum_norm_s_g_m_bm_u_t=exp(mean_ln_sum_norm_s_g_m_bm_u_t)
gen ln_geo_ln_sum_norm_s_g_m_bm_u_t=log(geo_ln_sum_norm_s_g_m_bm_u_t)
*
bys panel_year quarter product_group_code product_module_code: egen mean_s_g_m_bm_t=mean(s_g_m_bm_t)
gen geo_s_g_m_bm_t=exp(mean_s_g_m_bm_t)
gen norm_s_g_m_bm_t=s_g_m_bm_t/geo_s_g_m_bm_t
gen norm_s_g_m_bm_t2=s_g_m_bm_t/(geo_s_g_m_bm_t*n_g_m_t)
bys panel_year quarter product_group_code product_module_code: egen sum_norm_s_g_m_bm_t = sum(norm_s_g_m_bm_t)
gen ln_sum_norm_s_g_m_bm_t=log(sum_norm_s_g_m_bm_t)
bys panel_year quarter product_group_code product_module_code: egen sum_norm_s_g_m_bm_t2 = sum(norm_s_g_m_bm_t2)
gen ln_sum_norm_s_g_m_bm_t2=log(sum_norm_s_g_m_bm_t2)
*
bys panel_year quarter product_group_code product_module_code brand_module: egen mean_p_g_m_bm_u_t = mean(p_g_m_bm_u_t)
gen geo_p_g_m_bm_u_t = exp(mean_p_g_m_bm_u_t)
gen ln_geo_p_g_m_bm_u_t=log(geo_p_g_m_bm_u_t)
*
bys panel_year quarter product_group_code product_module_code: egen mean_ln_geo_p_g_m_bm_u_t=mean(ln_geo_p_g_m_bm_u_t)
gen geo_ln_geo_p_g_m_bm_u_t=exp(mean_ln_geo_p_g_m_bm_u_t)
gen ln_geo_ln_geo_p_g_m_bm_u_t=log(geo_ln_geo_p_g_m_bm_u_t)
save nest_test.dta, replace 
** run regressions
* Nest 3: upc 
preserve 
matrix R2_5_N3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_bm_u_t ln_p_g_m_bm_u_t, absorb(brand_module_time)
predict bmt_fe_`X',d
gen dem_ln_s_g_m_bm_u_t_`X'=ln_s_g_m_bm_u_t-bmt_fe_`X'
reg dem_ln_s_g_m_bm_u_t_`X' ln_p_g_m_bm_u_t
matrix R2_5_N3[`X',1]=e(r2)
}
svmat float R2_5_N3
keep R2_5_N3
drop if R2_5_N3==.
gen pg=_n
save R2_5_N3.dta, replace 
sum
restore
* nest 2: Brand-Module 
preserve 
collapse (firstnm) ln_s_g_m_bm_t  ln_geo_p_g_m_bm_u_t ln_sum_norm_s_g_m_bm_u_t ln_sum_norm_s_g_m_bm_u_t2 ln_n_g_m_bm_t, by(panel_year quarter product_group_code product_module_code brand_module)
egen prod_gr=group(product_group_code)
egen module_time=group(product_module_code panel_year quarter)
save nest_test_coll.dta, replace
matrix R2_5_N2_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_bm_t  ln_geo_p_g_m_bm_u_t ln_sum_norm_s_g_m_bm_u_t, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_bm_t`X'=ln_s_g_m_bm_t-mt_fe_`X'
reg dem_ln_s_g_m_bm_t`X' ln_geo_p_g_m_bm_u_t ln_sum_norm_s_g_m_bm_u_t
matrix R2_5_N2_3[`X',1]=e(r2)
}
svmat float R2_5_N2_3
keep R2_5_N2_3
drop if R2_5_N2_3==.
gen pg=_n
save R2_5_N2_3.dta, replace 
sum 
* 
matrix R2_5_N2_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_bm_t  ln_geo_p_g_m_bm_u_t ln_sum_norm_s_g_m_bm_u_t2, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_bm_t`X'=ln_s_g_m_bm_t-mt_fe_`X'
reg dem_ln_s_g_m_bm_t`X' ln_geo_p_g_m_bm_u_t ln_sum_norm_s_g_m_bm_u_t2
matrix R2_5_N2_2[`X',1]=e(r2)
}
svmat float R2_5_N2_2
keep R2_5_N2_2
drop if R2_5_N2_2==.
gen pg=_n
save R2_5_N2_2.dta, replace 
sum 
*  
matrix R2_5_N2_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_bm_t  ln_geo_p_g_m_bm_u_t ln_sum_norm_s_g_m_bm_u_t2 ln_n_g_m_bm_t, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_bm_t`X'=ln_s_g_m_bm_t-mt_fe_`X'
reg dem_ln_s_g_m_bm_t`X' ln_geo_p_g_m_bm_u_t ln_sum_norm_s_g_m_bm_u_t2 ln_n_g_m_bm_t
matrix R2_5_N2_4[`X',1]=e(r2)
}
svmat float R2_5_N2_4
keep R2_5_N2_4
drop if R2_5_N2_4==.
gen pg=_n
save R2_5_N2_4.dta, replace 
sum 
* without sum of normalized shares 
matrix R2_5_N2_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_bm_t  ln_geo_p_g_m_bm_u_t, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_bm_t`X'=ln_s_g_m_bm_t-mt_fe_`X'
reg dem_ln_s_g_m_bm_t`X' ln_geo_p_g_m_bm_u_t
matrix R2_5_N2_1[`X',1]=e(r2)
}
svmat float R2_5_N2_1
keep R2_5_N2_1
drop if R2_5_N2_1==.
gen pg=_n
save R2_5_N2_1.dta, replace
sum 
restore 
* nest 1: module 
preserve 
collapse (firstnm) ln_s_g_m_t ln_geo_ln_sum_norm_s_g_m_bm_u_t ln_sum_norm_s_g_m_bm_t ln_sum_norm_s_g_m_bm_t2 ln_geo_ln_geo_p_g_m_bm_u_t ln_n_g_m_t, by(panel_year quarter product_group_code product_module_code)
egen prod_gr=group(product_group_code)
egen time=group(panel_year quarter) 
save nest_test_coll.dta, replace  
matrix R2_5_N1_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_ln_sum_norm_s_g_m_bm_u_t ln_sum_norm_s_g_m_bm_t ln_geo_ln_geo_p_g_m_bm_u_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t- t_fe_`X'
reg dem_ln_s_g_m_t`X' ln_geo_ln_sum_norm_s_g_m_bm_u_t ln_sum_norm_s_g_m_bm_t ln_geo_ln_geo_p_g_m_bm_u_t
matrix R2_5_N1_3[`X',1]=e(r2)
}
svmat float R2_5_N1_3
keep R2_5_N1_3
drop if R2_5_N1_3==.
gen pg=_n
save R2_5_N1_3.dta, replace 
sum 
*
matrix R2_5_N1_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_ln_sum_norm_s_g_m_bm_u_t ln_sum_norm_s_g_m_bm_t2 ln_geo_ln_geo_p_g_m_bm_u_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t- t_fe_`X'
reg dem_ln_s_g_m_t`X' ln_geo_ln_sum_norm_s_g_m_bm_u_t ln_sum_norm_s_g_m_bm_t2 ln_geo_ln_geo_p_g_m_bm_u_t
matrix R2_5_N1_2[`X',1]=e(r2)
}
svmat float R2_5_N1_2
keep R2_5_N1_2
drop if R2_5_N1_2==.
gen pg=_n
save R2_5_N1_2.dta, replace
sum
*
matrix R2_5_N1_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_ln_sum_norm_s_g_m_bm_u_t ln_sum_norm_s_g_m_bm_t2 ln_geo_ln_geo_p_g_m_bm_u_t ln_n_g_m_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t- t_fe_`X'
reg dem_ln_s_g_m_t`X' ln_geo_ln_sum_norm_s_g_m_bm_u_t ln_sum_norm_s_g_m_bm_t2 ln_geo_ln_geo_p_g_m_bm_u_t ln_n_g_m_t
matrix R2_5_N1_4[`X',1]=e(r2)
}
svmat float R2_5_N1_4
keep R2_5_N1_4
drop if R2_5_N1_4==.
gen pg=_n
save R2_5_N1_4.dta, replace
sum
* without sum of normalized shares 
matrix R2_5_N1_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_ln_geo_p_g_m_bm_u_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t- t_fe_`X'
reg dem_ln_s_g_m_t`X' ln_geo_ln_geo_p_g_m_bm_u_t
matrix R2_5_N1_1[`X',1]=e(r2)
}
svmat float R2_5_N1_1
keep R2_5_N1_1
drop if R2_5_N1_1==.
gen pg=_n
save R2_5_N1_1.dta, replace 
sum
restore 
* ------------------------------------
*** Nesting VI: Product group - Module - FrimModule - UPC 
sort panel_year quarter product_group_code product_module_code firm_module upc
** generate variables 
* generate the UPC shares (s_g_m_fm_u_t), module - firmModule share (s_g_m_fm_t), module share (s_g_m_t) and their logs 
bys panel_year quarter product_group_code product_module_code firm_module: egen sales_g_m_fm_t = sum(value) 
bys panel_year quarter product_group_code product_module_code firm_module: egen n_g_m_fm_t = count(upc)
gen ln_n_g_m_fm_t=log(n_g_m_fm_t)
gen s_g_m_fm_u_t = value/sales_g_m_fm_t
gen ln_s_g_m_fm_u_t=log(s_g_m_fm_u_t)
gen s_g_m_fm_t=sales_g_m_fm_t/sales_g_m_t
gen ln_s_g_m_fm_t=log(s_g_m_fm_t)
gen p_g_m_fm_u_t=price 
gen ln_p_g_m_fm_u_t=log(p_g_m_fm_u_t)
* the geometric average of UPC prices (geo_p_g_m_fm_t), brandModule prices (geo_p_g_m_t), UPC shares (geo_s_g_m_fm_t), brandModule shares (geo_s_g_m_t) and Module sahres (geo_s_g_t) for each firm-module
bys panel_year quarter product_group_code product_module_code firm_module: egen mean_s_g_m_fm_u_t = mean(s_g_m_fm_u_t)
gen geo_s_g_m_fm_u_t = exp(mean_s_g_m_fm_u_t)
gen norm_s_g_m_fm_u_t=s_g_m_fm_u_t/geo_s_g_m_fm_u_t
gen norm_s_g_m_fm_u_t2=s_g_m_fm_u_t/(geo_s_g_m_fm_u_t*n_g_m_fm_t)
bys panel_year quarter product_group_code product_module_code firm_module: egen sum_norm_s_g_m_fm_u_t = sum(norm_s_g_m_fm_u_t)
gen ln_sum_norm_s_g_m_fm_u_t=log(sum_norm_s_g_m_fm_u_t)
bys panel_year quarter product_group_code product_module_code firm_module: egen sum_norm_s_g_m_fm_u_t2 = sum(norm_s_g_m_fm_u_t2)
gen ln_sum_norm_s_g_m_fm_u_t2=log(sum_norm_s_g_m_fm_u_t2)
*
bys panel_year quarter product_group_code product_module_code: egen mean_ln_sum_norm_s_g_m_fm_u_t=mean(ln_sum_norm_s_g_m_fm_u_t)
gen geo_ln_sum_norm_s_g_m_fm_u_t=exp(mean_ln_sum_norm_s_g_m_fm_u_t)
gen ln_geo_ln_sum_norm_s_g_m_fm_u_t=log(geo_ln_sum_norm_s_g_m_fm_u_t)
*
bys panel_year quarter product_group_code product_module_code: egen mean_s_g_m_fm_t=mean(s_g_m_fm_t)
gen geo_s_g_m_fm_t=exp(mean_s_g_m_fm_t)
gen norm_s_g_m_fm_t=s_g_m_fm_t/geo_s_g_m_fm_t
gen norm_s_g_m_fm_t2=s_g_m_fm_t/(geo_s_g_m_fm_t*n_g_m_t)
bys panel_year quarter product_group_code product_module_code: egen sum_norm_s_g_m_fm_t = sum(norm_s_g_m_fm_t)
gen ln_sum_norm_s_g_m_fm_t=log(sum_norm_s_g_m_fm_t)
bys panel_year quarter product_group_code product_module_code: egen sum_norm_s_g_m_fm_t2 = sum(norm_s_g_m_fm_t2)
gen ln_sum_norm_s_g_m_fm_t2=log(sum_norm_s_g_m_fm_t2)
*
bys panel_year quarter product_group_code product_module_code firm_module: egen mean_p_g_m_fm_u_t = mean(p_g_m_fm_u_t)
gen geo_p_g_m_fm_u_t = exp(mean_p_g_m_fm_u_t)
gen ln_geo_p_g_m_fm_u_t=log(geo_p_g_m_fm_u_t)
*
bys panel_year quarter product_group_code product_module_code: egen mean_ln_geo_p_g_m_fm_u_t=mean(ln_geo_p_g_m_fm_u_t)
gen geo_ln_geo_p_g_m_fm_u_t=exp(mean_ln_geo_p_g_m_fm_u_t)
gen ln_geo_ln_geo_p_g_m_fm_u_t=log(geo_ln_geo_p_g_m_fm_u_t)
save nest_test.dta, replace 
** run regressions
* Nest 3: upc 
preserve 
matrix R2_6_N3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_u_t ln_p_g_m_fm_u_t, absorb(firm_module_time)
predict fmt_fe_`X',d
gen dem_ln_s_g_m_fm_u_t_`X'=ln_s_g_m_fm_u_t-fmt_fe_`X'
reg dem_ln_s_g_m_fm_u_t_`X' ln_p_g_m_fm_u_t
matrix R2_6_N3[`X',1]=e(r2)
}
svmat float R2_6_N3
keep R2_6_N3
drop if R2_6_N3==.
gen pg=_n
save R2_6_N3.dta, replace 
sum
restore
* nest 2: Firm-Module 
preserve 
collapse (firstnm) ln_s_g_m_fm_t  ln_geo_p_g_m_fm_u_t ln_sum_norm_s_g_m_fm_u_t ln_sum_norm_s_g_m_fm_u_t2 ln_n_g_m_fm_t, by(panel_year quarter product_group_code product_module_code firm_module)
egen prod_gr=group(product_group_code)
egen module_time=group(product_module_code panel_year quarter)
save nest_test_coll.dta, replace
matrix R2_6_N2_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t  ln_geo_p_g_m_fm_u_t ln_sum_norm_s_g_m_fm_u_t, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' ln_geo_p_g_m_fm_u_t ln_sum_norm_s_g_m_fm_u_t
matrix R2_6_N2_3[`X',1]=e(r2)
}
svmat float R2_6_N2_3
keep R2_6_N2_3
drop if R2_6_N2_3==.
gen pg=_n
save R2_6_N2_3.dta, replace
sum 
*
matrix R2_6_N2_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t  ln_geo_p_g_m_fm_u_t ln_sum_norm_s_g_m_fm_u_t2, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' ln_geo_p_g_m_fm_u_t ln_sum_norm_s_g_m_fm_u_t2
matrix R2_6_N2_2[`X',1]=e(r2)
}
svmat float R2_6_N2_2
keep R2_6_N2_2
drop if R2_6_N2_2==.
gen pg=_n
save R2_6_N2_2.dta, replace
sum 
*
matrix R2_6_N2_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t  ln_geo_p_g_m_fm_u_t ln_sum_norm_s_g_m_fm_u_t2 ln_n_g_m_fm_t, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' ln_geo_p_g_m_fm_u_t ln_sum_norm_s_g_m_fm_u_t2 ln_n_g_m_fm_t
matrix R2_6_N2_4[`X',1]=e(r2)
}
svmat float R2_6_N2_4
keep R2_6_N2_4
drop if R2_6_N2_4==.
gen pg=_n
save R2_6_N2_4.dta, replace
sum 
* without sum of normalized shares 
matrix R2_6_N2_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t  ln_geo_p_g_m_fm_u_t, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' ln_geo_p_g_m_fm_u_t
matrix R2_6_N2_1[`X',1]=e(r2)
}
svmat float R2_6_N2_1
keep R2_6_N2_1
drop if R2_6_N2_1==.
gen pg=_n
save R2_6_N2_1.dta, replace 
sum 
restore 
* nest 1: Module 
preserve 
collapse (firstnm) ln_s_g_m_t ln_geo_ln_sum_norm_s_g_m_fm_u_t ln_sum_norm_s_g_m_fm_t ln_sum_norm_s_g_m_fm_t2 ln_geo_ln_geo_p_g_m_fm_u_t ln_n_g_m_t, by(panel_year quarter product_group_code product_module_code)
egen prod_gr=group(product_group_code)
egen time=group(panel_year quarter) 
save nest_test_coll.dta, replace  
matrix R2_6_N1_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_ln_sum_norm_s_g_m_fm_u_t ln_sum_norm_s_g_m_fm_t ln_geo_ln_geo_p_g_m_fm_u_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' ln_geo_ln_sum_norm_s_g_m_fm_u_t ln_sum_norm_s_g_m_fm_t ln_geo_ln_geo_p_g_m_fm_u_t
matrix R2_6_N1_3[`X',1]=e(r2)
}
svmat float R2_6_N1_3
keep R2_6_N1_3
drop if R2_6_N1_3==.
gen pg=_n
save R2_6_N1_3.dta, replace
sum
*
matrix R2_6_N1_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_ln_sum_norm_s_g_m_fm_u_t ln_sum_norm_s_g_m_fm_t2 ln_geo_ln_geo_p_g_m_fm_u_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' ln_geo_ln_sum_norm_s_g_m_fm_u_t ln_sum_norm_s_g_m_fm_t2 ln_geo_ln_geo_p_g_m_fm_u_t
matrix R2_6_N1_2[`X',1]=e(r2)
}
svmat float R2_6_N1_2
keep R2_6_N1_2
drop if R2_6_N1_2==.
gen pg=_n
save R2_6_N1_2.dta, replace
sum 
*
matrix R2_6_N1_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_ln_sum_norm_s_g_m_fm_u_t ln_sum_norm_s_g_m_fm_t2 ln_geo_ln_geo_p_g_m_fm_u_t ln_n_g_m_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' ln_geo_ln_sum_norm_s_g_m_fm_u_t ln_sum_norm_s_g_m_fm_t2 ln_geo_ln_geo_p_g_m_fm_u_t ln_n_g_m_t
matrix R2_6_N1_4[`X',1]=e(r2)
}
svmat float R2_6_N1_4
keep R2_6_N1_4
drop if R2_6_N1_4==.
gen pg=_n
save R2_6_N1_4.dta, replace
sum 
* without sum of normalized shares 
matrix R2_6_N1_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_t ln_geo_ln_geo_p_g_m_fm_u_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' ln_geo_ln_geo_p_g_m_fm_u_t
matrix R2_6_N1_1[`X',1]=e(r2)
}
svmat float R2_6_N1_1
keep R2_6_N1_1
drop if R2_6_N1_1==.
gen pg=_n
save R2_6_N1_1.dta, replace 
restore 
* ------------------------------------
*** Nesting VII: 2. Product group : Module : Firm - Module : Brand : UPC
sort panel_year quarter product_group_code product_module_code firm_module brand_code_uc upc
** generate variables 
* generate the UPC shares (s_g_m_fm_u_t), module - firmModule share (s_g_m_fm_t), module share (s_g_m_t) and their logs 
* N4
bys panel_year quarter product_group_code product_module_code firm_module brand_code_uc: egen sales_g_m_fm_b_t = sum(value) 
bys panel_year quarter product_group_code product_module_code firm_module brand_code_uc: egen n_g_m_fm_b_t = count(upc) 
gen ln_n_g_m_fm_b_t=log(n_g_m_fm_b_t)
gen s_g_m_fm_b_u_t = value/sales_g_m_fm_b_t
gen ln_s_g_m_fm_b_u_t=log(s_g_m_fm_b_u_t)
* 
gen s_g_m_fm_b_t = sales_g_m_fm_b_t/sales_g_m_fm_t
gen ln_s_g_m_fm_b_t=log(s_g_m_fm_b_t)
*
gen p_g_m_fm_b_u_t=price
gen ln_p_g_m_fm_b_u_t=log(p_g_m_fm_b_u_t)
* the geometric average of UPC prices (geo_p_g_m_fm_t), brandModule prices (geo_p_g_m_t), UPC shares (geo_s_g_m_fm_t), brandModule shares (geo_s_g_m_t) and Module sahres (geo_s_g_t) for each firm-module
* N3
bys panel_year quarter product_group_code product_module_code firm_module brand_code_uc: egen mean_s_g_m_fm_b_u_t = mean(s_g_m_fm_b_u_t)
gen geo_s_g_m_fm_b_u_t = exp(mean_s_g_m_fm_b_u_t)
gen norm_s_g_m_fm_b_u_t=s_g_m_fm_b_u_t/geo_s_g_m_fm_b_u_t
bys panel_year quarter product_group_code product_module_code firm_module brand_code_uc: egen sum_norm_s_g_m_fm_b_u_t = sum(norm_s_g_m_fm_b_u_t)
gen ln_sum_norm_s_g_m_fm_b_u_t=log(sum_norm_s_g_m_fm_b_u_t)
*
gen norm_s_g_m_fm_b_u_t2=s_g_m_fm_b_u_t/(geo_s_g_m_fm_b_u_t*n_g_m_fm_b_t)
bys panel_year quarter product_group_code product_module_code firm_module brand_code_uc: egen sum_norm_s_g_m_fm_b_u_t2 = sum(norm_s_g_m_fm_b_u_t2)
gen ln_sum_norm_s_g_m_fm_b_u_t2=log(sum_norm_s_g_m_fm_b_u_t2)
*
bys panel_year quarter product_group_code product_module_code firm_module brand_code_uc: egen mean_p_g_m_fm_b_u_t = mean(p_g_m_fm_b_u_t)
gen geo_p_g_m_fm_b_u_t=exp(mean_p_g_m_fm_b_u_t)
gen ln_geo_p_g_m_fm_b_u_t=log(geo_p_g_m_fm_b_u_t)
* N2
bys panel_year quarter product_group_code product_module_code firm_module: egen mean_s_g_m_fm_b_t = mean(s_g_m_fm_b_t)
gen geo_s_g_m_fm_b_t = exp(mean_s_g_m_fm_b_t)
gen norm_s_g_m_fm_b_t=s_g_m_fm_b_t/geo_s_g_m_fm_b_t
bys panel_year quarter product_group_code product_module_code firm_module: egen sum_norm_s_g_m_fm_b_t = sum(norm_s_g_m_fm_b_t)
gen ln_sum_norm_s_g_m_fm_b_t=log(sum_norm_s_g_m_fm_b_t)
*
gen norm_s_g_m_fm_b_t2=s_g_m_fm_b_t/(geo_s_g_m_fm_b_t*n_g_m_fm_t)
bys panel_year quarter product_group_code product_module_code firm_module: egen sum_norm_s_g_m_fm_b_t2 = sum(norm_s_g_m_fm_b_t2)
gen ln_sum_norm_s_g_m_fm_b_t2=log(sum_norm_s_g_m_fm_b_t2)
*
bys panel_year quarter product_group_code product_module_code firm_module: egen mean_lnsumnorm_s_g_m_fm_b_u_t = mean(ln_sum_norm_s_g_m_fm_b_u_t)
gen geo_lnsumnorm_sgmfmbut=exp(mean_lnsumnorm_s_g_m_fm_b_u_t)
gen lngeo_lnsumnorm_sgmfmbut=log(geo_lnsumnorm_sgmfmbut)
* 
bys panel_year quarter product_group_code product_module_code firm_module: egen mean_lngeo_pgmfmbut = mean(ln_geo_p_g_m_fm_b_u_t)
gen geo_lngeo_pgmfmbut=exp(mean_lngeo_pgmfmbut)
gen lngeo_lngeo_pgmfmbut=log(geo_lngeo_pgmfmbut)
* N1 
* geo geo of geo price 
bys panel_year quarter product_group_code product_module_code: egen mean_lngeo_lngeo_pgmfmbut = mean(lngeo_lngeo_pgmfmbut)
gen geo_lngeo_lngeo_pgmfmbut=exp(mean_lngeo_lngeo_pgmfmbut)
gen lngeo_lngeo_lngeo_pgmfmbut=log(geo_lngeo_lngeo_pgmfmbut)
* geo geo of geo share 
bys panel_year quarter product_group_code product_module_code: egen mean_lngeo_lnsumnorm_sgmfmbut = mean(lngeo_lnsumnorm_sgmfmbut)
gen geo_lngeo_lnsumnorm_sgmfmbut=exp(mean_lngeo_lnsumnorm_sgmfmbut)
gen lngeo_lngeo_lnsumnorm_sgmfmbut=log(geo_lngeo_lnsumnorm_sgmfmbut)
* geo of geo share 
bys panel_year quarter product_group_code product_module_code: egen mean_lnsumnorm_sgmfmbt = mean(ln_sum_norm_s_g_m_fm_b_t)
gen geo_lnsumnorm_sgmfmbt=exp(mean_lnsumnorm_sgmfmbt)
gen lngeo_lnsumnorm_sgmfmbt=log(geo_lnsumnorm_sgmfmbt)
* geo share 
capture: bys panel_year quarter product_group_code product_module_code: egen mean_s_g_m_fm_t = mean(s_g_m_fm_t)
capture: gen geo_s_g_m_fm_t = exp(mean_s_g_m_fm_t)
capture: gen norm_s_g_m_fm_t=s_g_m_fm_t/ geo_s_g_m_fm_t
capture: bys panel_year quarter product_group_code product_module_code: egen sum_norm_s_g_m_fm_t = sum(norm_s_g_m_fm_t)
capture: gen ln_sum_norm_s_g_m_fm_t=log(sum_norm_s_g_m_fm_t)
*
capture: gen norm_s_g_m_fm_t2=s_g_m_fm_t/(geo_s_g_m_fm_t*n_g_m_t) 
capture: bys panel_year quarter product_group_code product_module_code: egen sum_norm_s_g_m_fm_t2 = sum(norm_s_g_m_fm_t2)
capture: gen ln_sum_norm_s_g_m_fm_t2=log(sum_norm_s_g_m_fm_t2)
*
egen firm_module_brand_time=group(firm_module brand_code_uc panel_year quarter)
save nest_test.dta, replace 
** run regressions
* nest 4: upc
preserve 
matrix R2_7_N4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_b_u_t ln_p_g_m_fm_b_u_t, absorb(firm_module_brand_time)
predict fmbt_fe_`X',d
gen dem_ln_s_g_m_fm_b_u_t_`X'=ln_s_g_m_fm_b_u_t-fmbt_fe_`X'
reg dem_ln_s_g_m_fm_b_u_t_`X' ln_p_g_m_fm_b_u_t
matrix R2_7_N4[`X',1]=e(r2)
}
svmat float R2_7_N4
keep R2_7_N4
drop if R2_7_N4==.
gen pg=_n
save R2_7_N4.dta, replace 
sum
restore 
* nest 3: brand 
preserve 
collapse (firstnm) ln_s_g_m_fm_b_t ln_n_g_m_fm_b_t ln_sum_norm_s_g_m_fm_b_u_t ln_sum_norm_s_g_m_fm_b_u_t2 ln_geo_p_g_m_fm_b_u_t, by(panel_year quarter product_group_code product_module_code firm_module brand_code_uc)
egen prod_gr=group(product_group_code)
egen module_firm_time=group(firm_module panel_year quarter)
save nest_test_coll.dta, replace
matrix R2_7_N3_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_b_t  ln_sum_norm_s_g_m_fm_b_u_t ln_geo_p_g_m_fm_b_u_t, absorb(module_firm_time)
predict mft_fe_`X', d
gen dem_ln_s_g_m_fm_b_t`X'=ln_s_g_m_fm_b_t-mft_fe_`X'
reg dem_ln_s_g_m_fm_b_t`X' ln_sum_norm_s_g_m_fm_b_u_t ln_geo_p_g_m_fm_b_u_t
matrix R2_7_N3_3[`X',1]=e(r2)
}
svmat float R2_7_N3_3
keep R2_7_N3_3
drop if R2_7_N3_3==.
gen pg=_n
save R2_7_N3_3.dta, replace 
sum 
*
matrix R2_7_N3_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_b_t  ln_sum_norm_s_g_m_fm_b_u_t2 ln_geo_p_g_m_fm_b_u_t, absorb(module_firm_time)
predict mft_fe_`X', d
gen dem_ln_s_g_m_fm_b_t`X'=ln_s_g_m_fm_b_t-mft_fe_`X'
reg dem_ln_s_g_m_fm_b_t`X' ln_sum_norm_s_g_m_fm_b_u_t2 ln_geo_p_g_m_fm_b_u_t
matrix R2_7_N3_2[`X',1]=e(r2)
}
svmat float R2_7_N3_2
keep R2_7_N3_2
drop if R2_7_N3_2==.
gen pg=_n
save R2_7_N3_2.dta, replace 
sum 
* 
matrix R2_7_N3_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_b_t  ln_sum_norm_s_g_m_fm_b_u_t2 ln_n_g_m_fm_b_t ln_geo_p_g_m_fm_b_u_t, absorb(module_firm_time)
predict mft_fe_`X', d
gen dem_ln_s_g_m_fm_b_t`X'=ln_s_g_m_fm_b_t-mft_fe_`X'
reg dem_ln_s_g_m_fm_b_t`X' ln_sum_norm_s_g_m_fm_b_u_t2 ln_n_g_m_fm_b_t ln_geo_p_g_m_fm_b_u_t
matrix R2_7_N3_4[`X',1]=e(r2)
}
svmat float R2_7_N3_4
keep R2_7_N3_4
drop if R2_7_N3_4==.
gen pg=_n
save R2_7_N3_4.dta, replace 
sum 
* without sum of normalized shares 
matrix R2_7_N3_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_b_t  ln_geo_p_g_m_fm_b_u_t, absorb(module_firm_time)
predict mft_fe_`X', d
gen dem_ln_s_g_m_fm_b_t`X'=ln_s_g_m_fm_b_t-mft_fe_`X'
reg dem_ln_s_g_m_fm_b_t`X' ln_geo_p_g_m_fm_b_u_t
matrix R2_7_N3_1[`X',1]=e(r2)
}
svmat float R2_7_N3_1
keep R2_7_N3_1
drop if R2_7_N3_1==.
gen pg=_n
save R2_7_N3_1.dta, replace 
sum
restore 
* nest 2: firm module 
preserve 
collapse (firstnm) ln_s_g_m_fm_t ln_n_g_m_fm_t ln_sum_norm_s_g_m_fm_b_t ln_sum_norm_s_g_m_fm_b_t2 lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut, by(panel_year quarter product_group_code product_module_code firm_module)
egen prod_gr=group(product_group_code)
egen module_time=group(product_module_code panel_year quarter)
save nest_test_coll.dta, replace
matrix R2_7_N2_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t ln_sum_norm_s_g_m_fm_b_t lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' ln_sum_norm_s_g_m_fm_b_t lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut
matrix R2_7_N2_3[`X',1]=e(r2)
}
svmat float R2_7_N2_3
keep R2_7_N2_3
drop if R2_7_N2_3==.
gen pg=_n
save R2_7_N2_3.dta, replace 
sum 
*
matrix R2_7_N2_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t ln_sum_norm_s_g_m_fm_b_t2 lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' ln_sum_norm_s_g_m_fm_b_t2 lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut
matrix R2_7_N2_2[`X',1]=e(r2)
}
svmat float R2_7_N2_2
keep R2_7_N2_2
drop if R2_7_N2_2==.
gen pg=_n
save R2_7_N2_2.dta, replace
sum 
*
matrix R2_7_N2_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t ln_sum_norm_s_g_m_fm_b_t2 ln_n_g_m_fm_t lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' ln_sum_norm_s_g_m_fm_b_t2 ln_n_g_m_fm_t lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut
matrix R2_7_N2_4[`X',1]=e(r2)
}
svmat float R2_7_N2_4
keep R2_7_N2_4
drop if R2_7_N2_4==.
gen pg=_n
save R2_7_N2_4.dta, replace
sum 
* without sum of normalized shares 
matrix R2_7_N2_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t lngeo_lngeo_pgmfmbut, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' lngeo_lngeo_pgmfmbut
matrix R2_7_N2_1[`X',1]=e(r2)
}
svmat float R2_7_N2_1
keep R2_7_N2_1
drop if R2_7_N2_1==.
gen pg=_n
save R2_7_N2_1.dta, replace 
sum
restore 
* nest 1: module 
preserve 
collapse (firstnm) ln_s_g_m_t lngeo_lngeo_lngeo_pgmfmbut lngeo_lngeo_lnsumnorm_sgmfmbut lngeo_lnsumnorm_sgmfmbt ln_sum_norm_s_g_m_fm_t ln_sum_norm_s_g_m_fm_t2, by(panel_year quarter product_group_code product_module_code)
egen prod_gr=group(product_group_code)
egen time=group(panel_year quarter)
save nest_test_coll.dta, replace
matrix R2_7_N1_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg  ln_s_g_m_t lngeo_lngeo_lngeo_pgmfmbut lngeo_lngeo_lnsumnorm_sgmfmbut lngeo_lnsumnorm_sgmfmbt ln_sum_norm_s_g_m_fm_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' lngeo_lngeo_lngeo_pgmfmbut lngeo_lngeo_lnsumnorm_sgmfmbut lngeo_lnsumnorm_sgmfmbt ln_sum_norm_s_g_m_fm_t
matrix R2_7_N1_3[`X',1]=e(r2)
}
svmat float R2_7_N1_3
keep R2_7_N1_3
drop if R2_7_N1_3==.
gen pg=_n
save R2_7_N1_3.dta, replace
sum 
*
matrix R2_7_N1_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg  ln_s_g_m_t lngeo_lngeo_lngeo_pgmfmbut lngeo_lngeo_lnsumnorm_sgmfmbut lngeo_lnsumnorm_sgmfmbt ln_sum_norm_s_g_m_fm_t2, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' lngeo_lngeo_lngeo_pgmfmbut lngeo_lngeo_lnsumnorm_sgmfmbut lngeo_lnsumnorm_sgmfmbt ln_sum_norm_s_g_m_fm_t2
matrix R2_7_N1_2[`X',1]=e(r2)
}
svmat float R2_7_N1_2
keep R2_7_N1_2
drop if R2_7_N1_2==.
gen pg=_n
save R2_7_N1_2.dta, replace
sum 
* without sum of normalized shares 
matrix R2_7_N1_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg  ln_s_g_m_t lngeo_lngeo_lngeo_pgmfmbut, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' lngeo_lngeo_lngeo_pgmfmbut
matrix R2_7_N1_1[`X',1]=e(r2)
}
svmat float R2_7_N1_1
keep R2_7_N1_1
drop if  R2_7_N1_1==.
gen pg=_n
save R2_7_N1_1.dta, replace 
sum 
restore

