version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

* ************************
* This code tests the robustness of different nesting structures as follows: 
* (i) it estimates equations: 
* 
* where: g - product group code; f - firm; bm - brand module; u - upc; t - time; s - share; p - price 
* 
* (ii) it saves the R^2 from each regression and compute the averages of these R^2
* ************************

clear
set more off
set type double
cd ${TERMINAL}/data/qje
use ../nest_test,clear
** run regressions
* nest 4: upc
preserve 
matrix R2_7_N4=J(98,1,0)
foreach X of numlist 1/98{
use ../nest_test.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_b_u_t ln_p_g_m_fm_b_u_t, absorb(firm_module_brand_time)
predict fmbt_fe_`X',d
gen dem_ln_s_g_m_fm_b_u_t_`X'=ln_s_g_m_fm_b_u_t-fmbt_fe_`X'
reg dem_ln_s_g_m_fm_b_u_t_`X' ln_p_g_m_fm_b_u_t
matrix R2_7_N4[`X',1]=e(r2)
}
svmat float R2_7_N4
keep R2_7_N4
drop if R2_7_N4==.
gen pg=_n
save R2_7_N4.dta, replace 
sum
restore 
* nest 3: brand 
preserve 
collapse (firstnm) ln_s_g_m_fm_b_t ln_n_g_m_fm_b_t ln_sum_norm_s_g_m_fm_b_u_t ln_sum_norm_s_g_m_fm_b_u_t2 ln_geo_p_g_m_fm_b_u_t, by(panel_year quarter product_group_code product_module_code firm_module brand_code_uc)
egen prod_gr=group(product_group_code)
egen module_firm_time=group(firm_module panel_year quarter)
save nest_test_coll.dta, replace
matrix R2_7_N3_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_b_t  ln_sum_norm_s_g_m_fm_b_u_t ln_geo_p_g_m_fm_b_u_t, absorb(module_firm_time)
predict mft_fe_`X', d
gen dem_ln_s_g_m_fm_b_t`X'=ln_s_g_m_fm_b_t-mft_fe_`X'
reg dem_ln_s_g_m_fm_b_t`X' ln_sum_norm_s_g_m_fm_b_u_t ln_geo_p_g_m_fm_b_u_t
matrix R2_7_N3_3[`X',1]=e(r2)
}
svmat float R2_7_N3_3
keep R2_7_N3_3
drop if R2_7_N3_3==.
gen pg=_n
save R2_7_N3_3.dta, replace 
sum 
*
matrix R2_7_N3_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_b_t  ln_sum_norm_s_g_m_fm_b_u_t2 ln_geo_p_g_m_fm_b_u_t, absorb(module_firm_time)
predict mft_fe_`X', d
gen dem_ln_s_g_m_fm_b_t`X'=ln_s_g_m_fm_b_t-mft_fe_`X'
reg dem_ln_s_g_m_fm_b_t`X' ln_sum_norm_s_g_m_fm_b_u_t2 ln_geo_p_g_m_fm_b_u_t
matrix R2_7_N3_2[`X',1]=e(r2)
}
svmat float R2_7_N3_2
keep R2_7_N3_2
drop if R2_7_N3_2==.
gen pg=_n
save R2_7_N3_2.dta, replace 
sum 
* 
matrix R2_7_N3_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_b_t  ln_sum_norm_s_g_m_fm_b_u_t2 ln_n_g_m_fm_b_t ln_geo_p_g_m_fm_b_u_t, absorb(module_firm_time)
predict mft_fe_`X', d
gen dem_ln_s_g_m_fm_b_t`X'=ln_s_g_m_fm_b_t-mft_fe_`X'
reg dem_ln_s_g_m_fm_b_t`X' ln_sum_norm_s_g_m_fm_b_u_t2 ln_n_g_m_fm_b_t ln_geo_p_g_m_fm_b_u_t
matrix R2_7_N3_4[`X',1]=e(r2)
}
svmat float R2_7_N3_4
keep R2_7_N3_4
drop if R2_7_N3_4==.
gen pg=_n
save R2_7_N3_4.dta, replace 
sum 
* without sum of normalized shares 
matrix R2_7_N3_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_b_t  ln_geo_p_g_m_fm_b_u_t, absorb(module_firm_time)
predict mft_fe_`X', d
gen dem_ln_s_g_m_fm_b_t`X'=ln_s_g_m_fm_b_t-mft_fe_`X'
reg dem_ln_s_g_m_fm_b_t`X' ln_geo_p_g_m_fm_b_u_t
matrix R2_7_N3_1[`X',1]=e(r2)
}
svmat float R2_7_N3_1
keep R2_7_N3_1
drop if R2_7_N3_1==.
gen pg=_n
save R2_7_N3_1.dta, replace 
sum
restore 
* nest 2: firm module 
preserve 
collapse (firstnm) ln_s_g_m_fm_t ln_n_g_m_fm_t ln_sum_norm_s_g_m_fm_b_t ln_sum_norm_s_g_m_fm_b_t2 lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut, by(panel_year quarter product_group_code product_module_code firm_module)
egen prod_gr=group(product_group_code)
egen module_time=group(product_module_code panel_year quarter)
save nest_test_coll.dta, replace
matrix R2_7_N2_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t ln_sum_norm_s_g_m_fm_b_t lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' ln_sum_norm_s_g_m_fm_b_t lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut
matrix R2_7_N2_3[`X',1]=e(r2)
}
svmat float R2_7_N2_3
keep R2_7_N2_3
drop if R2_7_N2_3==.
gen pg=_n
save R2_7_N2_3.dta, replace 
sum 
*
matrix R2_7_N2_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t ln_sum_norm_s_g_m_fm_b_t2 lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' ln_sum_norm_s_g_m_fm_b_t2 lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut
matrix R2_7_N2_2[`X',1]=e(r2)
}
svmat float R2_7_N2_2
keep R2_7_N2_2
drop if R2_7_N2_2==.
gen pg=_n
save R2_7_N2_2.dta, replace
sum 
*
matrix R2_7_N2_4=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t ln_sum_norm_s_g_m_fm_b_t2 ln_n_g_m_fm_t lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' ln_sum_norm_s_g_m_fm_b_t2 ln_n_g_m_fm_t lngeo_lnsumnorm_sgmfmbut lngeo_lngeo_pgmfmbut
matrix R2_7_N2_4[`X',1]=e(r2)
}
svmat float R2_7_N2_4
keep R2_7_N2_4
drop if R2_7_N2_4==.
gen pg=_n
save R2_7_N2_4.dta, replace
sum 
* without sum of normalized shares 
matrix R2_7_N2_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg ln_s_g_m_fm_t lngeo_lngeo_pgmfmbut, absorb(module_time)
predict mt_fe_`X', d
gen dem_ln_s_g_m_fm_t`X'=ln_s_g_m_fm_t-mt_fe_`X'
reg dem_ln_s_g_m_fm_t`X' lngeo_lngeo_pgmfmbut
matrix R2_7_N2_1[`X',1]=e(r2)
}
svmat float R2_7_N2_1
keep R2_7_N2_1
drop if R2_7_N2_1==.
gen pg=_n
save R2_7_N2_1.dta, replace 
sum
restore 
* nest 1: module 
preserve 
collapse (firstnm) ln_s_g_m_t lngeo_lngeo_lngeo_pgmfmbut lngeo_lngeo_lnsumnorm_sgmfmbut lngeo_lnsumnorm_sgmfmbt ln_sum_norm_s_g_m_fm_t ln_sum_norm_s_g_m_fm_t2, by(panel_year quarter product_group_code product_module_code)
egen prod_gr=group(product_group_code)
egen time=group(panel_year quarter)
save nest_test_coll.dta, replace
matrix R2_7_N1_3=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg  ln_s_g_m_t lngeo_lngeo_lngeo_pgmfmbut lngeo_lngeo_lnsumnorm_sgmfmbut lngeo_lnsumnorm_sgmfmbt ln_sum_norm_s_g_m_fm_t, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' lngeo_lngeo_lngeo_pgmfmbut lngeo_lngeo_lnsumnorm_sgmfmbut lngeo_lnsumnorm_sgmfmbt ln_sum_norm_s_g_m_fm_t
matrix R2_7_N1_3[`X',1]=e(r2)
}
svmat float R2_7_N1_3
keep R2_7_N1_3
drop if R2_7_N1_3==.
gen pg=_n
save R2_7_N1_3.dta, replace 
sum 
*
matrix R2_7_N1_2=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg  ln_s_g_m_t lngeo_lngeo_lngeo_pgmfmbut lngeo_lngeo_lnsumnorm_sgmfmbut lngeo_lnsumnorm_sgmfmbt ln_sum_norm_s_g_m_fm_t2, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' lngeo_lngeo_lngeo_pgmfmbut lngeo_lngeo_lnsumnorm_sgmfmbut lngeo_lnsumnorm_sgmfmbt ln_sum_norm_s_g_m_fm_t2
matrix R2_7_N1_2[`X',1]=e(r2)
}
svmat float R2_7_N1_2
keep R2_7_N1_2
drop if R2_7_N1_2==.
gen pg=_n
save R2_7_N1_2.dta, replace
sum 
* without sum of normalized shares 
matrix R2_7_N1_1=J(98,1,0)
foreach X of numlist 1/98{
use nest_test_coll.dta, clear 
keep if prod_gr==`X'
areg  ln_s_g_m_t lngeo_lngeo_lngeo_pgmfmbut, absorb(time)
predict t_fe_`X', d
gen dem_ln_s_g_m_t`X'=ln_s_g_m_t-t_fe_`X'
reg dem_ln_s_g_m_t`X' lngeo_lngeo_lngeo_pgmfmbut
matrix R2_7_N1_1[`X',1]=e(r2)
}
svmat float R2_7_N1_1
keep R2_7_N1_1
drop if  R2_7_N1_1==.
gen pg=_n
save R2_7_N1_1.dta, replace 
sum 
restore

