version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

set more off
cd ${TERMINAL}/data

use nest_test_R2.dta, clear
foreach v of varlist R2* {
	egen avg`v'=mean(`v')
	egen std`v'=sd(`v')
	}
collapse (mean) avg* std*
gen n=_n
reshape long avg, i(n) j(nestmean) string
reshape long std,i(n nestmean) j(nestsd) string
keep if nestmean==nestsd
drop nestsd n
rename nestmean nest

gen nestnum1=regexm(nest,"N2")
gen nestnum=regexs(1) if regexm(nest,"R2_([0-9]).*")
destring nestnum, replace
gen nest1="Product Group" if nestnum1==0
replace nest1="Module" if nestnum1==1
gen nest2="Firm" if nestnum==1
replace nest2="Brand-Module" if nestnum==3|nestnum==5
replace nest2="Firm-Module" if nestnum==4|nestnum==6|nestnum==7
gen nest3="UPC"
replace nest3="Brand" if nestnum==7
gen nest4="N/A"
replace nest4="UPC" if nestnum==7


gen bin = _n
toroman bin, gen(specification)

sum bin
forval i=`r(min)'/`r(max)'{
	local v`i' = specification[`i']+"&"+nest1[`i']+"&"+nest2[`i']+"&"+nest3[`i']+"&"+nest4[`i']
	}

la var bin "Specification&Nest 1&Nest 2&Nest 3&Nest 4"
la def bin 1 "`v1'" 2 "`v2'" 3 "`v3'" 4 "`v4'" 5 "`v5'" 6 "`v6'"
la val bin bin

local vv0 : var la bin
local vv1 "Mean"
local vv2 "Std. Dev."


local K = 0
foreach v in avg std {
	local ++K
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	di "`vv`K''"
	}

local dec_list "2 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"

cd ${TERMINAL}/results/tables

tabout bin using 11_nest_test_Scol.tex, c(mean avg mean std) h2(`vv0'&`vv1'&`vv2'\\) ///
	replace sum ptotal(none) f(`dec_list') h3(nil) ///
	style(tex) bt topf(top_nest_Scol.tex) botf(bot_Scol.tex) ///
	topstr(Within Nest $ R^2$ |.9\textwidth|`col_format') ///
	botstr(\;|tab:Within_Nest)

* have to invoke regexr through terminal to clean up
! perl -i -pe 's/\\&/\&/g' 11_nest_test_Scol.tex
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' 11_nest_test_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' 11_nest_test_Scol.tex

local w1 "Mean"
local ww1 "Mean"
local w2 "Std\. Dev\."
local ww2 "Std.\\ Dev."

forval i=1/`K' {
	! perl -i -pe 's/`w`i''/{\\parbox{\\linewidth}{\\centering\\strut `ww`i''}}/g' 11_nest_test_Scol.tex
	}

