version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

set more off
cd ${TERMINAL}/data
use markups_cannib_all_firms_v5, clear

gen double firm_sales2=firm_sales if firm_sales!=max_firm_sales
replace firm_sales2=0 if firm_sales2==.
bys product_group_code: egen double max_firm_sales2=max(firm_sales2) 

gen double firm_sales3=firm_sales if firm_sales<max_firm_sales2
replace firm_sales3=0 if firm_sales3==.
bys product_group_code: egen double max_firm_sales3=max(firm_sales3) 

pctile cm1=norm_c_mu if firm_sales==max_firm_sales,nq(100)
pctile bm1=norm_b_mu_epsilonF if firm_sales==max_firm_sales,nq(100)
pctile cm2=norm_c_mu if firm_sales==max_firm_sales2,nq(100)
pctile bm2=norm_b_mu_epsilonF if firm_sales==max_firm_sales2,nq(100)
pctile cm3=norm_c_mu if firm_sales==max_firm_sales3,nq(100)
pctile bm3=norm_b_mu_epsilonF if firm_sales==max_firm_sales3,nq(100)

keep if cm1!=.

gen ptile=_n
gsort -ptile
gen ranked_ptile = _n

keep if ranked_ptile==10|ranked_ptile==25|ranked_ptile==50|ranked_ptile==75|ranked_ptile==90

la var ranked_ptile "Ranked Percentile"
la var cm1 "Largest"
la var bm1 "Largest"
la var cm2 "Second"
la var bm2 "Second"
la var cm3 "Third"
la var bm3 "Third"

local K = 0
foreach v of varlist cm1 bm1 cm2 bm2 cm3 bm3 {
	local ++K
	local V: var la `v'
	*la var `v' "{\parbox{\linewidth}{\centering_`V'}}"
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	}
	
local dec_list "2 2 2 2 2 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)
di "`col_format'"

local v0 : var la ranked_ptile
local v1 : var la cm1
local v2 : var la cm2
local v3 : var la cm3
local v4 : var la bm1
local v5 : var la bm2
local v6 : var la bm3
local vv0 "Cournot"
local vv1 "Bertrand"



cd ../results/tables
tabout ranked_ptile using 9_relative_markups_Scol.tex, ///
	c(mean cm1 mean cm2 mean cm3 mean bm1 mean bm2 mean bm3) ///
	h2(&\multicolumn{3}{c}{`vv0'}&\multicolumn{3}{c}{`vv1'}\\) cl2(2-4 5-7) ///
	h3(`v0'&`v1'&`v2'&`v3'&`v4'&`v5'&`v6'\\) replace sum ptotal(none) f(`dec_list') ///
	style(tex) bt topf(top_Scol.tex) botf(bot_Scol_rel_markups.tex) ///
	topstr(Distribution of Largest Firms' Markups Relative to Product Group Average|.9\textwidth|`col_format') ///
	botstr(Percentiles are decreasing: largest is ranked first. Markup=(Price-Marginal Cost)/Marginal Cost.|tab:markups2)
	
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' 9_relative_markups_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' 9_relative_markups_Scol.tex

forval i=1/`K' {
	local w`i' "`v`i''"
	local ww`i' "`w`i''"
	! perl -i -pe 's/`w`i''(\&|\\)/{\\parbox{\\linewidth}{\\centering\\vphantom{g} `ww`i''}}\1/g' 9_relative_markups_Scol.tex
	}
! head -50  9_relative_markups_Scol.tex

