version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

cd ${TERMINAL}/data
set more off


use Nr_UPC_whole_sample_final.dta, clear



replace y_q_pg_w_avgupcsales = y_q_pg_w_avgupcsales/1000
replace y_q_pg_w_sharevaluebin = y_q_pg_w_sharevaluebin*100

la var y_q_pg_w_firmid "No. of Firms"
la var y_q_pg_w_sharevaluebin "Share of Value (%)"
la var y_q_pg_w_avgupcsales "Mean Sales (Thousands)"
la var y_q_pg_w_medianupcsales "Median Sales (Thousands)"
la var y_q_pg_w_sdlnupcsales "Avg. St. Dev. UPC Sales"

la var bin "No.\ of UPCs"
la def bin 1 "1"  2  "2--5"  3 "6--10" 4 "11--20" 5 "21--50" 6 "51--100" 7 ">100" 
la val bin bin

local K = 0
foreach v of varlist y_q_pg_w_firmid y_q_pg_w_sharevaluebin y_q_pg_w_avgupcsales y_q_pg_w_medianupcsales y_q_pg_w_sdlnupcsales {
	local ++K
	local V: var la `v'
	*la var `v' "{\parbox{\linewidth}{\centering_`V'}}"
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	}
	
local dec_list "0 1 0 0 2 2"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"


local v0 : var la bin	
local v1 : var la y_q_pg_w_firmid
local v2 : var la y_q_pg_w_sharevaluebin
local v3 : var la y_q_pg_w_avgupcsales
local v4 : var la y_q_pg_w_medianupcsales
local v5 : var la y_q_pg_w_sdlnupcsales

replace y_q_pg_w_sdlnupcsales = . if bin ==1


cd ${TERMINAL}/results/tables

tabout bin using 4_sample_stat2_Scol.tex, c(mean y_q_pg_w_firmid mean y_q_pg_w_sharevaluebin ///
	mean y_q_pg_w_avgupcsales mean y_q_pg_w_medianupcsales mean y_q_pg_w_sdlnupcsales) ///
	h2(`v0'&`v1'&`v2'&`v3'&`v4'&`v5'\\) h3(nil) ///
	replace sum f(`dec_list') ptotal(none) ///
	style(tex) bt topf(top_Scol.tex) botf(bot_Scol.tex) ///
	topstr(Size Distribution by Number of UPCs|\textwidth|`col_format') ///
	botstr(Weighted by product group--quarter sales. To get last column, calculate standard deviation over log UPC sales by product group--quarter, then take weighted average across product group--quarters. |tab:sizeupc)
	
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' 4_sample_stat2_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' 4_sample_stat2_Scol.tex
! perl -i -pe 's/\>100/\\$>100\\$/g' 4_sample_stat2_Scol.tex


local w1 "No\. of Firms"
local w2 "Share of Value \(%\)"
local w3 "Mean Sales \(Thousands\)"
local w4 "Median Sales \(Thousands\)"
local w5 "Avg\. St\. Dev\. UPC Sales"

local ww1 "No.\\ of Firms"
local ww2 "Share of Value (\\%)"
local ww3 "Mean Sales (Thousands)"
local ww4 "Median Sales (Thousands)"
local ww5 "Avg.\\ St.\\ Dev.\\ UPC Sales"


forval i=1/`K' {
	! perl -i -pe 's/`w`i''/{\\parbox{\\linewidth}{\\centering `ww`i''}}/g' 4_sample_stat2_Scol.tex
	}
	
	! head -30 4_sample_stat2_Scol.tex
