version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"
set more off
 

use ${TERMINAL}/data/coll_by_yqpg.dta, clear
egen double total_value=sum(value) 
gen double y_q_pg_weight=value/total_value
rename upcsales meanupcsales

drop *firmlist*

foreach v of varlist *ln* {
	local v1 = regexr("`v'","ln.+","")
	local v2 = regexr("`v'",".*lnfirmsales","")
	rename `v' `v1'lnfirmrevenue`v2'
	}
	
foreach v of varlist *upcsales* {
	local v1 = regexr("`v'","upcsales.*","")
	local v2 = regexr("`v'",".*upcsales","")
	rename `v' `v1'zupcrevenue`v2'
	}

foreach v of varlist mean* med* sd* *90 *10 max* {
	replace `v' = `v'*y_q_pg_weight
	}
/*	
foreach stat in mean med sd max {
	rename `stat'* *`stat'
	}
*/

foreach stat in 10 90 {
	rename *`stat' p`stat'*
	}

collapse (sum) mean* med* sd* p90* p10* max*

tempfile temp
save `temp'

local i = 0
*foreach var in firmlist firmsales lnfirmrevenue upcs upcrevenue {
foreach var in mean med p10 p90 sd max {
	local ++i
	use `temp', clear
	keep `var'*
	gen a = _n
	reshape long `var', i(a) j(stat) string
	tempfile temp`i'
	save `temp`i''
	}
use `temp1'
forval j=2/`i' {
	merge 1:1 stat using `temp`j'', nogen
	}

save `temp', replace


 
** Now have to add in the firm id variables
use ${TERMINAL}/data/coll_by_yqpg.dta, clear
egen double total_value=sum(value) 
gen double y_q_pg_weight=value/total_value

qui sum firmid [aw=y_q_pg_weight],d
gen mean=r(mean)
gen med=r(p50)
gen sd=r(sd)
gen p10=r(p10)
gen p90=r(p90)
gen max=r(max)

collapse (mean) mean med sd p10 p90 max
gen stat = "firmid"
append using `temp'

foreach v of varlist mean med sd p10 p90 max {
	replace `v' = `v'/1000 if stat=="firmsales" | stat=="zupcrevenue"
	}

local v1 "No.\ Firms per Product Group"
local v2  "Firm Sales"
local v3  "Log Firm Sales"
local v4  "No.\ of UPCs per Firm"
local v5 "UPC Sales"

gen bin = _n
la var bin "Variable"
la def bin 1 "`v1'"  2  "`v2'"  3 "`v3'" 4 "`v4'" 5 "`v5'"
la val bin bin

local vv0 ""
local vv1 "Mean"
local vv2 "Median"
local vv3 "Std. Dev."
local vv4 "10th Percentile"
local vv5 "90th Percentile"
local vv6 "Max Value"



local K = 0
foreach v of varlist mean med sd p10 p90 max {
	local ++K
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	}
	
local dec_list "0 0 0 0 0 0"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"


cd ${TERMINAL}/results/tables

tabout bin using 1_sample_stat_Scol.tex, c(mean mean mean med mean sd mean p10 mean p90 mean max) ///
	h3(nil) h2(`vv0'&`vv1'&`vv2'&`vv3'&`vv4'&`vv5'&`vv6'\\) ///
	replace sum f(`dec_list') ptotal(none) ///
	style(tex) bt topf(top_Scol.tex) botf(bot_Scol.tex) ///
	topstr(Sample Statistics|\textwidth|`col_format') ///
	botstr(Weighted by product group--quarter sales. Firm and UPC sales in thousands.|tab:samplestat)
	
	
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' 1_sample_stat_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' 1_sample_stat_Scol.tex

local w1 "Mean"
local w2 "Median"
local w3 "Std\. Dev\."
local w4 "10th Percentile"
local w5 "90th Percentile"
local w6 "Max Value"

local ww1 "Mean"
local ww2 "Median"
local ww3 "Std.\\ Dev."
local ww4 "10th Percentile"
local ww5 "90th Percentile"
local ww6 "Max Value"

forval i=1/`K' {
	! perl -i -pe 's/`w`i''/{\\parbox{\\linewidth}{\\centering `ww`i''}}/g' 1_sample_stat_Scol.tex
	}



