version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

clear all
set more off
local nosig "_nosigma"
set type double

cd ${TERMINAL}/data
use product_group_code firmid firmqualityt upcqualityt lnupcquality ///
	aut lnupcmc SigmaU SigmaF value grouppriceindex firmpriceindex ///
	mft panel_year quarter lnprice sharefirmgroup using RedoFullPostestimationV2_v5.dta, clear
*
* drop product groups: 3501 (FRESH MEAT) and 4001 (FRESH PRODUCE)
sort product_group_code
drop if product_group_code==3501 | product_group_code==4001

* set the directory where results are saved 
cd ${TERMINAL}/results/qje
*
* drop missing values 
drop if firmqualityt == . | upcqualityt == . | aut == .| SigmaU == . | SigmaF == . | value == . | mft == . | grouppriceindex == .


* define variables 
bys panel_year quarter product_group_code firmid: egen totalfirmsales = total(value)
bys panel_year quarter product_group_code: egen productgroupsales = total(value)
gen firmshare2=totalfirmsales/productgroupsales
bys product_group_code firmid panel_year quarter: egen geomeanAut = gmean(aut)
*
** define cutoff for small firms: firms with less than 0.5% share and drop them 
* drop if firmshare2<0.005 // don't do this
*
* take logs 
gen double loggeomeanaut = log(geomeanAut)
gen double lnFirmQuality = ln(firmqualityt)
* 
gen double lnvalue = ln(value)

* UPC LEVEL
foreach v of varlist lnvalue lnprice lnupcquality lnupcmc {
	bys panel_year quarter product_group_code firmid: egen a`v' = mean(`v')
	gen d`v' = `v'-a`v'
	}

la var dlnvalue "\$\Delta^f\ln E_{ut}^U\$"
la var dlnupcquality "\$\Delta^f\ln\varphi_{ut}^U\$"
la var dlnupcmc "\$\Delta^f\ln\gamma_{ut}\$"
la var dlnprice "\$\Delta^f\ln P_{ut}^U\$"

rename dlnvalue dA
rename dlnprice dB
rename dlnupcquality dC
rename dlnupcmc dD
order d*,alpha

save ../../data/qje/corr_table_upc_data, replace

*/
cd ${TERMINAL}/results/qje
use ../../data/qje/corr_table_upc_data, clear

eststo clear
qui estpost corr d*, matrix

cd ${TERMINAL}/results/tables
esttab using 6_vd_corrs_upc_noscale.tex, not unstack compress noobs ///
	label booktabs nonumbers nostar replace  b(2) substitute(\_ _) ///
	title(Sales Component Correlations (UPC Level) \label{tab:upc_corr_noscale}) ///
	addnote("All correlations significant at the 0.1 percent level. \$\Delta^f \ln E^U_{ut}\$ is the log sales of each bar code less the log geometric mean sales of all bar codes sold by the firm. \$\Delta^f \ln P^U_{ut}\$ is the log price of each bar code less the log geometric mean price of all bar codes sold by the firm. \$\Delta^f \ln\varphi^U_{ut}\$ is the log appeal of each bar code. \$\Delta^f \ln\gamma^U_{ut}\$ is the log marginal cost of each bar code less the log geometric mean marginal cost of all bar codes sold by the firm. Calculations on data from The Nielsen Company (US), LLC and provided by the Marketing Data Center at The University of Chicago Booth School of Business.")
! perl -i -pe 's/\s+\&\\multicolumn\{4\}.*//g' 6_vd_corrs_upc_noscale.tex
! perl -i -pe 's/(\\bottomrule)/\1\n\\addlinespace[.75ex]/g' 6_vd_corrs_upc_noscale.tex
! perl -i -pe 'undef $/; s/\\multicolumn\{\d\}\{l\}\{\\footnotesize((?:(?!\\\\).)*)\\\\\n(\\end\{tabular\})/\2\n\\flushleft\\scriptsize{\\emph{Note:} \1/g' 6_vd_corrs_upc_noscale.tex
! head -50 6_vd_corrs_upc_noscale.tex

bys product_group_code firmid panel_year quarter: egen firmproduc = count(value)
gen double AQratio = ((aut/geomeanAut)/upcqualityt)^(1-SigmaU)
gen double logtotalsales = log(totalfirmsales)
collapse (mean) sharefirmgroup loggeomeanaut firmpriceindex firmqualityt mft ///
		SigmaF SigmaU logtotalsales firmproduc ///
	 (sum)  AQratio, by(panel_year quarter product_group_code firmid) fast

replace AQratio = AQratio/firmproduc
sort panel_year quarter
egen time=group(panel_year quarter)
sort product_group_code firmid
egen pf=group(product_group_code firmid)

xtset pf time

* NEW SET UP TO SUM TO ONE
rename loggeomeanaut lnGeomeanAut
gen double lnsharefirmgroup = ln(sharefirmgroup)
gen double lnfirmpriceindex = ln(firmpriceindex)
gen double lnFirmQuality = ln(firmqualityt)
gen double lnmftterm = ln(mft)
gen double lnAQratio = ln(AQratio)
gen double logfirmprod = log(firmproduc)

if "`nosig'"!="_nosigma" {
	replace lnmftterm = ln(mft)*(1-SigmaF)
	replace lnGeomeanAut = (1-SigmaF)*lnGeomeanAut
	replace lnFirmQuality = (SigmaF-1)*lnFirmQuality
	replace lnAQratio = lnAQratio * (1-SigmaF)/(1-SigmaU)
	replace logfirmprod = logfirmprod * (1-SigmaF)/(1-SigmaU)
	}

drop if lnFirmQuality == . 

foreach X in lnfirmpriceindex logtotalsales lnFirmQuality lnAQratio lnmftterm logfirmprod lnGeomeanAut {
    bys panel_year quarter product_group_code: egen double a`X'=mean(`X')
    gen double d`X'=`X'-a`X'
    }


la var dlogtotalsales "\$\Delta^g\ln E_{ft}^F\$"
la var dlnFirmQuality "\$\Delta^g\ln \varphi_{ft}^F\$"
la var dlnAQratio "\$\Delta^g\ln CD_{ft}\$"
la var dlogfirmprod "\$\Delta^g\ln N_{ft}^U\$"
la var dlnmftterm "\$\Delta^g\ln \mu_{ft}^F\$"
la var dlnGeomeanAut "\$\Delta^g\ln \tilde\gamma_{ft}\$"
la var dlnfirmpriceindex "\$\Delta^g\ln P_{ft}^F\$"

rename dlogtotalsales dA
rename dlnfirmpriceindex dB
rename dlnFirmQuality dC
rename dlogfirmprod dD
rename dlnGeomeanAut dE
rename dlnAQratio dF
rename dlnmftterm dG
order *,alpha

eststo clear
qui estpost corr d*, matrix
esttab using 7_vd_corrs_noscale.tex, not unstack compress noobs ///
	label booktabs nonumbers nostar replace  b(2) substitute(\_ _) ///
	title(Sales Component Correlations (Firm Level) \label{tab:firm_corr_noscale}) ///
	addnote("All correlations significant at the 0.1 percent level. The difference operator \$\Delta^g \ln x_{ft}\$ denotes the value of log \$x\$ for firm \$f\$ in quarter \$t\$, less the log geometric mean value of \$x\$ among all firms in product group \$g\$ that quarter. The variable \$x\$ is one of the following: \$E^F_{ft}\$ is firm sales, \$P^F_{ft}\$ is the firm price index, \$\varphi^F_{ft}\$ is firm appeal, \$N^U_{ft}\$ is the number of products sold by a firm, \$\tilde\gamma^F_{ft}\$ is the average marginal cost among a firm's products, \$CD_{ft}=\frac{1}{N_{ft}^U}\sum_{u\in\Omega_{ft}^U}\left(\frac{\gamma_{ut}/\tilde{\gamma}_{ut}}{\varphi_{ut}^U}\right)^{1-\sigma_g^U}\$ is the firm's cost dispersion, and \$\mu^F_{ft}\$ is the firm's markup.")
	*addnote("All correlations significant at the 0.1 percent level. \$\Delta^g \ln E^F_{ft}\$ is the log of each firm's sales less the log geometric mean sales among all firms in the product group. \$\Delta^g \ln P^F_{ft}\$ is the log price of a firm less the log geometric mean price among all firms in the product group. \$\Delta^g \ln\varphi^F_{ft}\$ is the log appeal of each firm less the geometric mean appeal among all firms in the product group. \$\Delta^g \ln N^U_{ft}\$ is the log number of products sold by the firm less the log geometric mean number of products among all firms in the product group. \$\Delta^g\ln\tilde\gamma^F_{ft}\$ is the log average marginal cost of each firm less the log geometric mean average marginal cost among all firms in the product group. \$\Delta^g \ln CD_{ft}\$ is the log cost dispersion \$CD_{ft}=\frac{1}{N_{ft}^U}\sum_{u\in\Omega_{ft}^U}\left(\frac{\gamma_{ut}/\tilde{\gamma}_{ut}}{\varphi_{ut}^U}\right)^{1-\sigma_g^U}\$ less the log geometric mean cost dispersion among all firms in the product group. \$\Delta^g \ln\mu^F_{ft}\$ is the log firm markup less the log geometric mean markup among all firms in the product group.") 
	*addnote("All correlations significant at the 0.1 percent level. The cost dispersion term is \$CD_{ft} = \frac{1}{N_{ft}^U}\sum_{u\in\Omega_{ft}^U}\left(\frac{\gamma_{ut}/\tilde{\gamma}_{ut}}{\varphi_{ut}^U}\right)^{1-\sigma_g^U}\$.")
! perl -i -pe 's/\s+\&\\multicolumn\{7\}.*//g' 7_vd_corrs_noscale.tex
! perl -i -pe 's/(\\bottomrule)/\1\n\\addlinespace[.75ex]/g' 7_vd_corrs_noscale.tex
! perl -i -pe 'undef $/; s/\\multicolumn\{\d\}\{l\}\{\\footnotesize((?:(?!\\\\).)*)\\\\\n(\\end\{tabular\})/\2\n\\flushleft\\scriptsize{\\emph{Note:} \1/g' 7_vd_corrs_noscale.tex

! head -50 7_vd_corrs_noscale.tex


*corr d*,c
