version 12.1
set type double


global TERMINAL "/mnt/data0/work/MPF_FINAL"

set more off
cd ${TERMINAL}/results/reg_output/geometric_mean

local k = 1


tempfile temp

foreach DSlabel in "v5" "large" {
*foreach DSlabel in "v5" {
	use RedoDecompositionData_avgDiff_`DSlabel'.dta,clear
	foreach XX in "Quality lnFirmQuality" "Cost_dispersion lnAQratio" "Markup lnmftterm" "Scope logfirmprod" "Average_MC lnGeomeanAut" {
		local X: word 2 of `XX'
		local Xnice: word 1 of `XX'
		
		qui reg d`X' dlogtotalsales
		gen coef_`Xnice'=_b[dlogtotalsales]
		gen se_`Xnice'=_se[dlogtotalsales]
		}
	collapse (mean) coef* se*
	if `k'==1 {
		gen app`k'=0
		}
	else {
		append using `temp', gen(app`k')
		}
	save `temp', replace
	local ++k
	}

foreach DSlabel in "v5" "v5_large" {
*foreach DSlabel in "v5" {
	use decomp_data_whole_sample_v3_diffAvg2_`DSlabel'.dta, clear
	foreach XX in "Quality d_d_lnFQ" "Cost_dispersion d_d_lnAQR" "Markup d_d_lnMft" "Scope d_d_lnfirmprod" "Average_MC d_d_lnGeomeanAut" ///
		"Upgrading d_d_product_quality_upgrading2" {
			local X: word 2 of `XX'
			local Xnice: word 1 of `XX'
			qui reg `X' d_d_logtotalsales
			gen coef_`Xnice'=_b[d_d_logtotalsales]
			gen se_`Xnice'=_se[d_d_logtotalsales]
			}
	collapse (mean) coef* se*
	append using `temp', gen(app`k')
	save `temp', replace
	local ++k
	}

gen decomp = 0
foreach v of varlist app* {
	local dnum=substr("`v'",-1,.)
	replace decomp = `dnum' if `v'==0
	}



expand 2
local end_loop= `k'-1
forval i=1/`end_loop' {
	local j = `end_loop'+`i'
	foreach v in Quality Scope Average_MC Cost_dispersion Markup Upgrading {
		replace coef_`v'=se_`v'[`i'] in `j'
		}
	}
drop se_*
gen bin = _n
bys decomp (bin): gen stat=_n
replace bin = _n

tempfile posttemp
save `posttemp'


keep if decomp==1 | decomp==3
replace bin = _n
la var bin "\multicolumn{1}{c}{Decomposition}"
la def bin 1 "\emph{Cross-Sectional}" 2 "(SE)" 3 "\emph{Firm Growth}" 4 "(SE)"
la val bin bin

local v0: var la bin
local v1 "Appeal"
local v2 "Scope"
local v3 "Average MC"
local v4 "Cost Dispersion"
local v5 "Markup"
local v6 "Upgrading"

local vv1 "Mean"
local vv2 "(SE)"

local c1 ""
foreach v in Upgrading Markup Cost_dispersion Average_MC Scope Quality {
	local c1 "mean coef_`v' `c1'"
	}
	

local K = 0
foreach v in coef_Quality coef_Scope coef_Average_MC coef_Cost_dispersion coef_Markup coef_Upgrading {
	local ++K
	gen length= length(string(round(`v',1)))
	qui sum length
	local int_`K' = `r(max)'	
	drop length
	di "`v`K''"
	}

local dec_list "3 4 3 4 5 4"
local col_format ""
forval k = `K'(-1)1 {
	local k_start = 2*(`k'-1)+1
	local dec_`k' = substr("`dec_list'",`k_start',1)
	local col_format "`int_`k''|`dec_`k''|`col_format'"
	}
local col_format = substr("`col_format'",1,length("`col_format'")-1)

di "`col_format'"



cd ${TERMINAL}/results/tables/
tabout bin using var_decomp3_v5_panel1.tex, c(`c1') h2(`v0'&`v1'&`v2'&`v3'&`v4'&`v5'&`v6'\\) ///
	replace sum ptotal(none) f(`dec_list') h3(nil) ///
	style(tex) bt topf(top_vardecomp_v5_Scol.tex) botf(bot_vardecomp_v5_Scol.tex) ///
	topstr(Variance Decompositions|\textwidth|`col_format') ///
	botstr(\textwidth|`col_format')



use `posttemp', clear

keep if decomp==2 | decomp==4
replace bin = _n
la var bin "{\multicolumn{1}{c}{Decomposition}}"
la def bin 1 "\emph{Cross-Sectional}" 2 "(SE)" 3 "\emph{Firm Growth}" 4 "(SE)"
la val bin bin


local c1 ""
foreach v in Upgrading Markup Cost_dispersion Average_MC Scope Quality {
	local c1 "mean coef_`v' `c1'"
	}

cd ${TERMINAL}/results/tables

tabout bin using 10_var_decomp3_v5_Scol.tex, c(`c1') h2(`v0'&`v1'&`v2'&`v3'&`v4'&`v5'&`v6'\\) ///
	replace sum ptotal(none) f(`dec_list') h3(nil) ///
	style(tex) bt topf(var_decomp3_v5_panel1.tex) botf(bot_Scol.tex) ///
	botstr(\emph{MC} is marginal cost |tab:VarDec)
	
! perl -i -pe 's/\\&/\&/g' 10_var_decomp3_v5_Scol.tex
! perl -i -pe 's/X\[c\]\{S\[table-format=\#\.\n//g' 10_var_decomp3_v5_Scol.tex
! perl -i -pe 's/\#\]\}\n//g' 10_var_decomp3_v5_Scol.tex
! perl -i -pe 's{(\)\K|\G)\&([\d\.]+)}{&(\2)}g' 10_var_decomp3_v5_Scol.tex
! perl -i -pe 'undef $/; s/(\\\\)\n.*\(SE\)/\1*\n/g' 10_var_decomp3_v5_Scol.tex

forval i=1/`K' {
	! perl -i -pe 's/`v`i''/{\\parbox{\\linewidth}{\\centering `v`i''}}/g' 10_var_decomp3_v5_Scol.tex
	}
	
! rm var_decomp3_v5_panel1.tex

! head -50 10_var_decomp3_v5_Scol.tex
