% light48_model_0:  
% e = a ~ exp(cbar)
% x = 1
%

clear all;
small = 1.0e-10;
rng(3418);

% -- File Directories   

% --- Read Spatial Data ---
Tdata = readtable(['data1_fips.xlsx']);
fips_vec = Tdata{:,'fips'};
latlon_mat = Tdata{:,{'latitude','longitude'}};
light_vec = Tdata{:,'rad_nogf_cl2010'};

% Compute number of ordinates per state
unique_fips=unique(fips_vec);  % unique elements in fips;
nc = size(unique_fips,1);
fprintf('Number of states %3i \n',nc);
fprintf('  State: Number of obs per state \n');
for i = 1:nc;
    ii = fips_vec == unique_fips(i);
    ni = sum(ii);
    fprintf('   %3i: %5i \n',[i ni]);
end;
