% Plot Results for Light MC .. Results with heteroskedasiticity and rhobar = 0.10

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
matdir = 'mat/';

% Plot UMs Results
% Read Results 
scpc_b = NaN(14,6);   % Benchmark
cscpc_b = NaN(14,6);  % Benchmark
scpc_h = NaN(14,6);   % heteroskedasticity
cscpc_h = NaN(14,6);  % heteroskedasticity
scpc_p = NaN(14,6);   % additional persistence
cscpc_p = NaN(14,6);  % additional persistence

b1 = 4;
for i = 1:14;
    b2 = b1 + 5;
    
    rng_str = ['A' num2str(b1) ':F' num2str(b2)];
    tmp = readmatrix('HeteroTable.xlsx','Range',rng_str);
    ii = tmp < 0;
    tmp(ii) = NaN;
    scpc_b(i,:) = tmp(:,1)';
    cscpc_b(i,:) = tmp(:,2)';
    scpc_h(i,:) = tmp(:,3)';
    cscpc_h(i,:) = tmp(:,4)';
    scpc_p(i,:) = tmp(:,5)';
    cscpc_p(i,:) = tmp(:,6)';
    
    b1 = b1+10;
end;

%% 

trend = (1:1:14)';
eps = 0.1;
t1 = trend-2*eps;
t2 = trend-eps;
t3 = trend+eps;
t4 = trend+2*eps;

% lw = 4;
% ms = 10;
% leg_fs = 20;
% ax_fs = 20;
% tit_fs = 25;

lw = 2;
ms = 5;
leg_fs = 10;
ax_fs = 10;

fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
% fig = figure;
tmp1 = linspace(0,20,100)';
tmp2 = 0.05*ones(100,1);

errorbar(t1,scpc_b(:,6),scpc_b(:,6)-scpc_b(:,1),scpc_b(:,6)-scpc_b(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Black','MarkerFaceColor','Black','LineWidth',lw,'Color','Black');
hold on;
 d2 = errorbar(t2,scpc_h(:,6),scpc_h(:,6)-scpc_h(:,1),scpc_h(:,6)-scpc_h(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Black','MarkerFaceColor','Black','LineWidth',lw,'Color','Black');
 d2.Bar.LineStyle = 'dotted';
 errorbar(t3,cscpc_b(:,6),cscpc_b(:,6)-cscpc_b(:,1),cscpc_b(:,6)-cscpc_b(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Blue','MarkerFaceColor','Blue','LineWidth',lw,'Color','Blue');
 d2 = errorbar(t4,cscpc_h(:,6),cscpc_h(:,6)-cscpc_h(:,1),cscpc_h(:,6)-cscpc_h(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Blue','MarkerFaceColor','Blue','LineWidth',lw,'Color','Blue');
 d2.Bar.LineStyle = 'dotted';
 plot(tmp1,tmp2,': k','LineWidth',2);
hold off;
ylim([0 0.4]);
xlim([0,14.5]);
xlabel('Experiment','FontSize',ax_fs);
ylabel('Rejection Frequency','FontSize',ax_fs);
xticks((1:1:16));
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',ax_fs);
legend('SCPC (Homoskedastic, solid)','SCPC (Heteroskedastic, dots)','C-SCPC (Homoskedastic, solid)','C-SCPC (Heteroskedastic, dots)','Location','Northwest','FontSize',leg_fs);
figure_to_png(figdir, 'Figure_Light_1_a_Hetero');
close(fig);

